<?php
    /**
     * Adds post meta and title in single
     * 
     * @since 1.0.0
     * @package Blog Postx Pro
    */

    use BlogPostx\CustomizerDefault as BPX;
    $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
    $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
    $is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
    $is_one = ( ( $single_post_layout === 'layout-one' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-one' ) );
    $is_seven = ( ( $single_post_layout === 'layout-seven' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-seven' ) );
    $block_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'single_block_reorder' ) );
    $visible_blocks = count( array_keys( $block_reorder, true ) );

    if( $block_reorder ) :
        $partialClass = 'single-header-content-wrap ' . blog_postx_convert_number_to_numeric_string( $visible_blocks ) . '-items';
        echo '<div class="', esc_attr( $partialClass ) ,'">';
            foreach( $block_reorder as $value => $option ) :
                switch( $value ) :
                    case 'title' :
                            /* Title */
                            blog_postx_single_title( $option );
                        break;
                    case 'category' :
                            /* Category */
                            if( $option && ( ! $is_one ) ) blog_postx_get_post_categories( get_the_ID(), 2 );
                        break;
                    case 'meta' :
                            /* Meta */
                            if( $option ) :
                                $meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'single_meta_reorder' ) );
                                ?>
                                    <div class="post-meta-wrap">
                                        <?php 
                                            /* Category */

                                            if( $meta_reorder[ 'date' ] || $meta_reorder[ 'read_time' ] || $meta_reorder[ 'comments' ] || $meta_reorder[ 'author' ] ) : ?>
                                                <span class="post-meta">
                                                    <?php
                                                        if( $meta_reorder ) :
                                                            foreach( $meta_reorder as $value => $option ) :
                                                                switch( $value ) :
                                                                    case 'date':
                                                                            /* Date */
                                                                            if( $option ) blog_postx_posted_on();
                                                                        break;
                                                                    case 'author':
                                                                            /* Author */
                                                                            if( $option ) blog_postx_posted_by( 'single-layout-two', get_the_ID() ); 
                                                                        break;
                                                                    case 'read_time':
                                                                            /* Read Time */
                                                                            blog_postx_single_read_time( $option );
                                                                        break;
                                                                    case 'comments':
                                                                            /* Comments */
                                                                            blog_postx_single_comments( $option );
                                                                        break;
                                                                endswitch;
                                                            endforeach;
                                                        endif;
                                                    ?>
                                                </span>
                                            <?php endif;
                                        ?>
                                    </div>
                                <?php
                            endif;
                        break;
                endswitch;
            endforeach;
        echo '</div>';
    endif;