<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
$previous = get_previous_post();
$next = get_next_post();
$articleClass = '';
if( empty( $previous ) ) $articleClass .= 'no-prev';
if( empty( $next ) ) $articleClass .= 'no-next';

$single_post_content_alignment = BPX\blog_postx_get_customizer_option( 'single_post_content_alignment' );
$single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
$single_thumbnail_option = true;
$single_image_size = BPX\blog_postx_get_customizer_option( 'single_image_size' );

$single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
$is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
$is_layout_one = ( ( $single_post_layout === 'layout-one' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-one' ) );
$is_layout_five = ( ( $single_post_layout === 'layout-five' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-five' ) );
$is_layout_six = ( ( $single_post_layout === 'layout-six' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-six' ) );

$postInnerClass = 'post-inner';
if( ( $is_layout_one || $is_layout_five || $is_layout_six ) && ( ! $single_thumbnail_option ) ) $postInnerClass .= ' no-single-featured-image';
?>
<article <?php blog_postx_schema_article_attributes(); ?> id="post-<?php the_ID(); ?>" <?php post_class( $articleClass ); ?>>
	<div class="<?php echo esc_attr( $postInnerClass ); ?>">
		<?php
			if( $is_layout_one || $is_layout_five ) :
				$single_block_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'single_block_reorder' ) );
				if( $single_thumbnail_option && $is_layout_one ) :
					?>
						<header class="entry-header" >
							<?php
								blog_postx_post_thumbnail( $single_image_size );
								if( $single_block_reorder[ 'category' ] ) blog_postx_get_post_categories( get_the_ID(), 2 );
							?>
						</header><!-- .entry-header -->
					<?php
				endif;
				get_template_part( 'template-parts/single/partial', 'meta' );
			endif;

			if( ( $is_layout_five || $is_layout_six ) && $single_thumbnail_option ) blog_postx_post_thumbnail( $single_image_size );

			$contentClass = 'entry-content content-alignment--' . esc_attr( $single_post_content_alignment );
		?>
		<div <?php blog_postx_schema_article_body_attributes(); ?> class="<?php echo esc_attr( $contentClass ); ?>">
			<?php
				do_action( 'blog_postx_before_single_content_hook' );
				the_content(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'blog-postx' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						wp_kses_post( get_the_title() )
					)
				);
				do_action( 'blog_postx_after_single_content_hook' );

				wp_link_pages(
					array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'blog-postx' ),
						'after'  => '</div>',
					)
				);
			?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php
				$tag_count = get_tags([ 'object_ids' => get_the_ID() ]);
				if( count( $tag_count ) != 0 ) blog_postx_tags_list();
				blog_postx_entry_footer();
			?>
		</footer><!-- .entry-footer -->

	</div>

	<?php
		// author box
		blog_postx_single_author_box();

		// post navigation
		blog_postx_single_post_navigation();

		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) comments_template();
	?>
</article><!-- #post-<?php the_ID(); ?> -->
<?php
	/**
	 * hook - blog_postx_single_post_append_hook
	 * 
	 * @since 1.0.0
	 */
	do_action( 'blog_postx_single_post_append_hook' );