<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
$custom_class = 'has-featured-image';
if( ! has_post_thumbnail() ) $custom_class = 'no-featured-image';
$archive_meta_reorder = $args[ 'archive_meta_reorder' ];
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $custom_class ); ?>>

    <div class="blog-postx-article-inner blog-postx-article-inner">

        <?php
        
            echo '<figure class="post-thumbnail-wrapper">';

                echo '<div class="post-thumnail-inner-wrapper">';
                    
                    blog_postx_archive_thumbnail();        

                echo '</div>';

                blog_postx_archive_category();

            echo '</figure>';

            echo '<div class="inner-content">';

                echo '<div class="content-wrap">';
                

                    blog_postx_posted_on( $archive_meta_reorder[ 'date' ] );

                    blog_postx_archive_title();

                    blog_postx_archive_excerpt();

                echo '</div>';

                echo '<div class="post-meta">';

                    blog_postx_posted_by( $archive_meta_reorder[ 'date' ] );

                    echo '<span class="post-meta">';

                        blog_postx_archive_read_time( $archive_meta_reorder[ 'read_time' ] );

                        blog_postx_archive_comment( $archive_meta_reorder[ 'comment' ] );

                        blog_postx_archive_button();
                    
                    echo '</span>';

                echo '</div>';

            echo '</div>';

            /**
             * hook - blog_postx_archive_button_html_hook
             * 
             * @since 1.0.0
             */
            do_action( 'blog_postx_archive_post_append_hook' );
        ?>

    </div>

</article>