<?php
/**
 * Template part for displaying posts with gallery format
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
$custom_class = 'has-featured-image';
if( array_key_exists( 'css_classes', $args ) ) $custom_class .= $args['css_classes'];
if( ! has_post_thumbnail() ) $custom_class = 'no-featured-image';
$archive_post_layout = $args[ 'archive_post_layout' ];
$show_archive_category_in_mobile = $args[ 'show_archive_category_in_mobile' ];
$show_archive_date_in_mobile = $args[ 'show_archive_date_in_mobile' ];
$archive_layout_meta = blog_postx_get_archive_layout_meta();
$is_customizer_layout = ( $archive_layout_meta == 'customizer-layout' );

$is_grid_two = ( ( $archive_post_layout === 'grid-two' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $archive_layout_meta === 'grid-two' ) );
$is_list_two = ( ( $archive_post_layout === 'list-two' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $archive_layout_meta === 'list-two' ) );
$is_block = ( ( $archive_post_layout === 'block' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $archive_layout_meta === 'block' ) );
$is_block_two = ( ( $archive_post_layout === 'block-two' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $archive_layout_meta === 'block-two' ) );
$post_format = blog_postx_get_post_format();
if( in_array( $post_format, [ 'image', 'quote' ] ) ) $custom_class .= ' post-format';

$archive_meta_reorder = $args[ 'archive_meta_reorder' ];
$archive_content_reorder = $args[ 'archive_content_reorder' ];
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $custom_class ); ?>>

<?php

    echo '<div class="blog-postx-article-inner">';

        if( ! in_array( $post_format, [ 'image', 'quote' ] ) ) :

            if( ( $is_list_two || $is_block ) ) :

                if( $is_block ) echo '<div class="top-inner-content">';

                    blog_postx_archive_title( $archive_content_reorder[ 'title' ] );

                if( $is_block ) echo '</div>';

            endif;

            if( $is_list_two ) echo '<div class="blog-inner-wrapper">';

        endif;

        if( $is_block_two ) echo '<div class="content-wrapper">';

        echo '<figure class="post-thumbnail-wrapper">';

            echo '<div class="post-thumnail-inner-wrapper">';

                blog_postx_archive_thumbnail(); 

                if( $post_format === 'audio' && ! $is_grid_two ) blog_postx_archive_audio();

            echo '</div>';

            if( ! $is_block_two ) blog_postx_archive_category();

            blog_postx_archive_post_format();

        if( ! in_array( $post_format, [ 'image', 'quote' ] ) ) echo '</figure>';

        echo '<div class="inner-content">';

            echo '<div class="content-wrap">';

                if( in_array( $post_format, [ 'image', 'quote' ] ) ) echo '<div class="blog-postx-inner-content-wrap-fi">';

                    if( $post_format === 'quote' ) blog_postx_archive_quote();
                    
                    if( $post_format !== 'quote' ) :

                        if( is_array( $archive_content_reorder ) ) :

                            foreach( $archive_content_reorder as $value => $option ) :

                                switch( $value ) :

                                    case 'title' :
                                            // Title
                                            if( ! $is_list_two && ! $is_block ) blog_postx_archive_title( $archive_content_reorder[ 'title' ] );
                                        break;
                                    case 'excerpt' :
                                            // Excerpt
                                            blog_postx_archive_excerpt( $archive_content_reorder[ 'excerpt' ] );
                                        break;
                                    case 'button' :
                                            // Button
                                            $buttonClass = 'button--wrapper' . ( $archive_content_reorder[ 'button' ] ? ' button--on' : '' );
                                            if( $is_grid_two && ( $archive_content_reorder[ 'button' ] || $archive_meta_reorder[ 'date' ] ) ) echo '<div class="', esc_attr( $buttonClass ) ,'">';

                                                if( ! $is_block_two )  blog_postx_archive_button( $archive_content_reorder[ 'button' ] );

                                                if( $is_grid_two ) blog_postx_archive_date( $archive_meta_reorder[ 'date' ] );

                                            if( $is_grid_two && ( $archive_content_reorder[ 'button' ] || $archive_meta_reorder[ 'date' ] ) ) echo '</div>';
                                        break;
                                    case 'meta' :
                                            // Meta
                                            if( $archive_content_reorder[ 'meta' ] ) :

                                                echo '<div class="post-meta">';

                                                    if( is_array( $archive_meta_reorder ) ) :

                                                        foreach( $archive_meta_reorder as $value => $option ) :

                                                            switch( $value ) :
                                                                case 'date' :
                                                                        if( ! $is_grid_two ) blog_postx_archive_date( $archive_meta_reorder[ 'date' ] );
                                                                    break;
                                                                case 'comment' :
                                                                        blog_postx_archive_comment( $archive_meta_reorder[ 'comment' ] );
                                                                    break;
                                                                case 'read_time' :
                                                                        blog_postx_archive_read_time( $archive_meta_reorder[ 'read_time' ] );
                                                                    break;
                                                                case 'author' :
                                                                        if( ! $is_block_two ) blog_postx_archive_author( $archive_meta_reorder[ 'author' ] );
                                                                    break;
                                                            endswitch;
                                                            
                                                        endforeach;

                                                    endif;

                                                echo '</div>';

                                            endif;
                                        break;

                                endswitch;

                            endforeach;

                        endif;

                        // Audio post format
                        if( $post_format === 'audio' && $is_grid_two ) blog_postx_archive_audio();

                    endif;

                if( in_array( $post_format, [ 'image', 'quote' ] ) ) echo '</div>';

            echo '</div>';

        echo '</div>';

        if( in_array( $post_format, [ 'image', 'quote' ] ) ) echo '</figure>';

    echo '</div>';

    if( $is_block_two ) :

        echo '<div class="content-foot">';

            blog_postx_archive_category();

            blog_postx_archive_author( $archive_meta_reorder[ 'author' ] );

            blog_postx_archive_button( $archive_content_reorder[ 'button' ] );
            
        echo '</div>';

        echo '</div> <!-- .blog-postx-article-inner -->';

    endif;

    if( $is_list_two && ! in_array( $post_format, [ 'image', 'quote' ] ) ) echo '</div><!-- .blog-inner-wrapper -->';

    blog_postx_entry_footer();
?>
</article>