<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;

get_header();
	$single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
    $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
    $is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
	$is_seven = ( ( $single_post_layout === 'layout-seven' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-seven' ) );
	if( $is_seven ) :
		echo '<div class="blog-postx-container breadcrumb-wrapper">';
			blog_postx_breadcrumb_html();
		echo '</div>';
	endif;

	do_action( 'blog_postx_main_content_opening' );

	$single_sidebar_layout = BPX\blog_postx_get_customizer_option( 'single_sidebar_layout' );
	$sidebar_layout = blog_postx_get_current_page_sidebar();
	$is_customizer_settings = ( $sidebar_layout === 'customizer-setting' );
	$current_sidebar_layout = $is_customizer_settings ? $single_sidebar_layout : $sidebar_layout;
	$single_meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'single_meta_reorder' ) );
	$show_right_sidebar = in_array( $current_sidebar_layout, [ 'both-sidebar', 'right-sidebar' ] );
	if( in_array( $current_sidebar_layout, [ 'both-sidebar', 'left-sidebar' ] ) ) get_sidebar( 'left' );

	?>
		<main id="primary" class="site-main">

			<div class="blog-postx-inner-content-wrap">

				<?php

					while ( have_posts() ) : the_post();

						get_template_part( 'template-parts/content', 'single' );

					endwhile;

				?>

			</div><!-- .blog-postx-inner-content-wrap -->

			<div class="post-read-time-wrap">
				<?php blog_postx_single_read_time( $single_meta_reorder[ 'read_time' ] ); ?>
			</div>

		</main><!-- #main -->

	<?php

	if( $show_right_sidebar ) get_sidebar();

	do_action( 'blog_postx_main_content_closing' );

get_footer();