<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Blog Postx Pro
 */

use BlogPostx\CustomizerDefault as BPX;

$archive_meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_meta_reorder' ) );
$archive_content_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_content_reorder' ) );
$visible_elements = count( array_keys( $archive_content_reorder, true ) );
$args[ 'archive_meta_reorder' ] = $archive_meta_reorder;
$args[ 'archive_content_reorder' ] = $archive_content_reorder;
$args[ 'archive_post_layout' ] = BPX\blog_postx_get_customizer_option( 'archive_post_layout' );
$args[ 'show_archive_category_in_mobile' ] = true;
$args[ 'show_archive_date_in_mobile' ] = true;

get_header();

	do_action( 'blog_postx_main_content_opening' );
	$elementClass = ' archive-align--' . BPX\blog_postx_get_customizer_option('archive_post_elements_alignment');
	$elementClass .= ' ' . blog_postx_convert_number_to_numeric_string( $visible_elements ) . '-items';
	?>

		<main id="primary" class="site-main">

			<?php if ( have_posts() ) : ?>

				<header class="page-header">
					<h1 class="page-title">
						<?php
							/* translators: %s: search query. */
							echo '<span class="search-page-title">', esc_html__( 'Search Results for', 'blog-postx' ), '</span>';
							echo '<span>'. get_search_query() .'</span>';
						?>
					</h1>
					<div class="blog_postx_search_page">
						<?php get_search_form(); ?>
					</div>
				</header><!-- .page-header -->

				<?php
				blog_postx_search_query_section();
				echo '<div class="blog-postx-inner-content-wrap'. esc_attr( $elementClass ) .'">'; //inner-content-wrap
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();

						/**
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */
						get_template_part( 'template-parts/archive/layout', '', $args );

					endwhile;
				echo '</div>';

				echo '<div class="pagination"><div class="ajax-load-more-wrap blog-postx-button"><h2 class="button-label">', esc_html__( 'Load More', 'blog-postx' ) ,'</h2><span class="loader"></span></div></div>';
				wp_reset_postdata();

			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>

		</main><!-- #main -->

	<?php
	get_sidebar();
	do_action( 'blog_postx_main_content_closing' );

get_footer();
