<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;

get_header();
	$frontpage_reorder_control = BPX\blog_postx_get_customizer_option( 'frontpage_reorder_control' );
	if( $frontpage_reorder_control ) :
		foreach( $frontpage_reorder_control as $section ) :
			switch( $section[ 'value' ] ) :
				case 'ticker_news' :
						/**
						 * Hook - blog_postx_ticker_news_hook
						 * 
						 * @hooked - blog_postx_ticker_html
						 */
						do_action( 'blog_postx_ticker_news_hook' );
					break;
				case 'web_stories' :
						/**
						 * Hook - blog_postx_web_stories_hook
						 * 
						 * @hooked - blog_postx_web_stories_html
						 */
						do_action( 'blog_postx_web_stories_hook' );
					break;
				case 'main_banner' :
						/**
						 * Hook - blog_postx_main_banner_hook
						 * 
						 * @hooked - blog_postx_main_banner_html
						 */
						do_action( 'blog_postx_main_banner_hook' );
					break;
				case 'carousel' :
						/**
						 * Hook - blog_postx_carousel_hook
						 * 
						 * @hooked - blog_postx_carousel_html
						 */
						do_action( 'blog_postx_carousel_hook' );
					break;
				case 'category_collection' :
						/**
						 * Hook - blog_postx_category_collection_hook
						 * 
						 * @hooked - blog_postx_category_collection_html
						 */
						do_action( 'blog_postx_category_collection_hook' );
					break;
				case 'latest_posts' :
						do_action( 'blog_postx_main_content_opening' );
						$page_sidebar_layout = BPX\blog_postx_get_customizer_option( 'page_settings_sidebar_layout' );
						$sidebar_layout = blog_postx_get_current_page_sidebar();
						$is_customizer_settings = ( $sidebar_layout === 'customizer-setting' );
						$current_sidebar_layout = $is_customizer_settings ? $page_sidebar_layout : $sidebar_layout;
						$show_left_sidebar = in_array( $current_sidebar_layout, [ 'both-sidebar', 'left-sidebar' ] );
						$show_right_sidebar = in_array( $current_sidebar_layout, [ 'both-sidebar', 'right-sidebar' ] );
						if( $show_left_sidebar ) get_sidebar( 'left' );
						?>
							<main id="primary" class="site-main">

								<?php
									while ( have_posts() ) : the_post();

										get_template_part( 'template-parts/content', 'page' );

										// If comments are open or we have at least one comment, load up the comment template.
										if ( comments_open() || get_comments_number() ) :
											comments_template();
										endif;

									endwhile; // End of the loop.
								?>

							</main><!-- #main -->

						<?php
						if( $show_right_sidebar ) get_sidebar();
						do_action( 'blog_postx_main_content_closing' );
					break;
			endswitch;
		endforeach;
	endif;

get_footer();