<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
get_header();
$frontpage_reorder_control = BPX\blog_postx_get_customizer_option( 'frontpage_reorder_control' );
if( $frontpage_reorder_control ) :
	foreach( $frontpage_reorder_control as $section ) :
		switch( $section[ 'value' ] ) :
			case 'ticker_news' :
					/**
					 * Hook - blog_postx_ticker_news_hook
					 * 
					 * @hooked - blog_postx_ticker_html
					 */
					do_action( 'blog_postx_ticker_news_hook' );
				break;
			case 'web_stories' :
					/**
					 * Hook - blog_postx_web_stories_hook
					 * 
					 * @hooked - blog_postx_web_stories_html
					 */
					do_action( 'blog_postx_web_stories_hook' );
				break;
			case 'main_banner' :
					/**
					 * Hook - blog_postx_main_banner_hook
					 * 
					 * @hooked - blog_postx_main_banner_html
					 */
					do_action( 'blog_postx_main_banner_hook' );
				break;
			case 'carousel' :
					/**
					 * Hook - blog_postx_carousel_hook
					 * 
					 * @hooked - blog_postx_carousel_html
					 */
					do_action( 'blog_postx_carousel_hook' );
				break;
			case 'category_collection' :
					/**
					 * Hook - blog_postx_category_collection_hook
					 * 
					 * @hooked - blog_postx_category_collection_html
					 */
					do_action( 'blog_postx_category_collection_hook' );
				break;
			case 'advertisement' :
					/**
					 * Hook - blog_postx_advertisement_hook
					 * 
					 * @hooked - blog_postx_advertisement_html
					 */
					if( is_home() && is_front_page() ) do_action( 'blog_postx_advertisement_hook' );
				break;
			case 'latest_posts' :
					$archive_sidebar_layout = BPX\blog_postx_get_customizer_option( 'archive_sidebar_layout' );
					$archive_meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_meta_reorder' ) );
					$archive_content_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_content_reorder' ) );
					$visible_elements = count( array_keys( $archive_content_reorder, true ) );

					$elementClass = ' archive-align--' . BPX\blog_postx_get_customizer_option('archive_post_elements_alignment');
					$elementClass .= ' ' . blog_postx_convert_number_to_numeric_string( $visible_elements ) . '-items';

					$args[ 'archive_meta_reorder' ] = $archive_meta_reorder;
					$args[ 'archive_content_reorder' ] = $archive_content_reorder;
					$args[ 'archive_post_layout' ] = BPX\blog_postx_get_customizer_option( 'archive_post_layout' );
					$args[ 'show_archive_category_in_mobile' ] = true;
					$args[ 'show_archive_date_in_mobile' ] = true;
					if( $archive_content_reorder[ 'button' ] && $archive_meta_reorder[ 'date' ] ) $elementClass .= ' align-off';
					$show_right_sidebar = in_array( $archive_sidebar_layout, ['right-sidebar','both-sidebar'] );
					do_action( 'blog_postx_main_content_opening' );

					if( in_array( $archive_sidebar_layout, ['left-sidebar','both-sidebar'] )  ) get_sidebar('left');
					?>
						<main id="primary" class="site-main">
							<?php
							if ( have_posts() ) :
								if ( is_home() && ! is_front_page() ) :
									?>
										<header class="page-header">
											<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
										</header>
									<?php
								endif;
								$ads_info = blog_postx_algorithm_to_push_ads_in_archive();
								$count = 0;
								echo '<div class="blog-postx-inner-content-wrap'. esc_attr( $elementClass ) .'">'; //inner-content-wrap
									/* Start the Loop */
									while ( have_posts() ) : the_post();
										if( ! is_null( $ads_info ) ) :
											if( in_array( $wp_query->current_post, $ads_info['random_numbers'] ) ) :
												blog_postx_random_post_archive_advertisement_part( is_array( $ads_info['ads_to_render'] ) ? $ads_info['ads_to_render'][$count] : $ads_info['ads_to_render'] );
												$count++;
											endif;
										endif;
										/*
										* Include the Post-Type-specific template for the content.
										* If you want to override this in a child theme, then include a file
										* called content-___.php (where ___ is the Post Type name) and that will be used instead.
										*/
										get_template_part( 'template-parts/archive/layout', '', $args );
									endwhile;
								echo '</div>'; //  end: blog-postx-inner-content-wrap

								/**
								 * hook - blog_postx_pagination_link_hook
								 * 
								 * hooked - blog_postx_pagination_fnc - 10
								 * 
								 * @package Blog Postx Pro
								 * @since 1.0.0
								 */
								do_action( 'blog_postx_pagination_link_hook' );
							else :
								get_template_part( 'template-parts/content', 'none' );
							endif;
							?>
						</main><!-- #main -->

					<?php
					if( $show_right_sidebar ) get_sidebar( '', [ 'sidebar' => $show_right_sidebar ] );
					do_action( 'blog_postx_main_content_closing' );
				break;
		endswitch;
	endforeach;
endif;

get_footer();