<?php
/**
 * Handle the wigets files and hooks
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function blog_postx_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'blog-postx' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// left sidebar
	register_sidebar(
		array(
			'name'          => esc_html__( 'Left Sidebar', 'blog-postx' ),
			'id'            => 'sidebar-left',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// header toggle sidebar
	register_sidebar(
		array(
			'name'          => esc_html__( 'Canvas Menu Sidebar', 'blog-postx' ),
			'id'            => 'canvas-menu-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);
	
	// footer sidebar - column 1
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Sidebar - Column 1', 'blog-postx' ),
			'id'            => 'footer-sidebar-column-one',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// footer sidebar - column 2
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Sidebar - Column 2', 'blog-postx' ),
			'id'            => 'footer-sidebar-column-two',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// footer sidebar - column 3
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Sidebar - Column 3', 'blog-postx' ),
			'id'            => 'footer-sidebar-column-three',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span class="divider"></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// footer sidebar - column 4
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Sidebar - Column 4', 'blog-postx' ),
			'id'            => 'footer-sidebar-column-four',
			'description'   => esc_html__( 'Add widgets here.', 'blog-postx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span></span><span>',
			'after_title'   => '</span></h2>',
		)
	);

	register_widget( 'Blgocast_WP_Heading_Widget' );
	register_widget( 'Blog_Postx_Author_Info_Widget' );
	register_widget( 'Blog_Postx_Category_Collection_Widget' );
	register_widget( 'Blog_Postx_Tags_Collection_Widget' );
	register_widget( 'Blog_Postx_Post_Grid_Widget' );
	register_widget( 'Blog_Postx_Post_List_Widget' );
	register_widget( 'Blog_Postx_Social_Platforms_Widget' );
	register_widget( 'Blog_Postx_Carousel_Widget' );
	register_widget( 'Blog_Postx_Posts_Grid_Two_Column_Widget' );
}
add_action( 'widgets_init', 'blog_postx_widgets_init' );

if( ! function_exists( 'blog_postx_widget_scripts' ) ) :
	/**
	 * Enqueue styles and scripts for widget
	 * 
	 * @since 1.0.0
	 * @package Blog Postx Pro
	 */
	function blog_postx_widget_scripts( $hook ) {
		if( $hook != 'widgets.php' ) return;
		wp_enqueue_style( 'blog-postx-widget', get_template_directory_uri() .'/inc/widgets/assets/widget.css', [], BLOG_POSTX_VERSION );
		wp_enqueue_style( 'blog-postx-select2', get_template_directory_uri() . '/assets/external/select2/select2.min.css', [], '4.1.0', 'all' );
		wp_enqueue_media();
		wp_enqueue_script( 'blog-postx-widget', get_template_directory_uri() .'/inc/widgets/assets/widget.js', ['jquery'], BLOG_POSTX_VERSION, [ 'strategy' => 'defer', 'in_footer' => true ] );
		wp_enqueue_script( 'blog-postx-select2', get_template_directory_uri() .'/assets/external/select2/select2.min.js', ['jquery'], BLOG_POSTX_VERSION, [ 'strategy' => 'defer', 'in_footer' => true ] );
		wp_localize_script( 'blog-postx-widget', 'widgetData', [
			'widgetAjaxUrl'	=>	admin_url( 'admin-ajax.php' ),
			'widgetNonce'	=>	wp_create_nonce( 'blog_postx_widget_nonce' )
		]
		);
	}
	add_action( 'admin_enqueue_scripts', 'blog_postx_widget_scripts' );
endif;

require get_template_directory() . '/inc/widgets/heading.php';
require get_template_directory() . '/inc/widgets/author-info.php';
require get_template_directory() . '/inc/widgets/category-collection.php';
require get_template_directory() . '/inc/widgets/tags-collection.php';
require get_template_directory() . '/inc/widgets/post-grid.php';
require get_template_directory() . '/inc/widgets/post-list.php';
require get_template_directory() . '/inc/widgets/social-platforms.php';
require get_template_directory() . '/inc/widgets/widget-fields.php';
require get_template_directory() . '/inc/widgets/carousel.php';
require get_template_directory() . '/inc/widgets/posts-grid-two-column.php';