<?php
/**
 * INcludes theme defaults and starter functions
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
namespace BlogPostx\CustomizerDefault;

if( ! function_exists( 'blog_postx_get_customizer_option' ) ) :
    /**
     * Gets customizer "theme mod" value
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_get_customizer_option( $control_id ) {
        return get_theme_mod( $control_id, blog_postx_get_customizer_default( $control_id ) );
    }
endif;

if( !function_exists( 'blog_postx_get_multiselect_tab_option' ) ) :
    /**
     * Gets customizer "multiselect combine tab" value
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_get_multiselect_tab_option( $key ) {
        $value = blog_postx_get_customizer_option( $key );
        if( !$value["desktop"] && !$value["tablet"] && !$value["mobile"] ) return apply_filters( "blog_postx_get_multiselect_tab_option", false );
        return apply_filters( "blog_postx_get_multiselect_tab_option", true );
    }
endif;

if( ! function_exists( 'blog_postx_customizer_default_array' ) ) :
    /**
     * Returns controls default values
     * 
     * @since 1.0.0
     */
    function blog_postx_customizer_default_array() {
        $array_defaults = apply_filters( 'blog_postx_get_customizer_defaults', [
            'theme_color'   => '#C69270',
            'gradient_theme_color'   => 'linear-gradient(135deg,#942cddcc 0,#38a3e2cc 100%)',
            'header_textcolor'  =>  '222',
            'site_background_color'  => blog_postx_default_color([ 'solid'=> '#f3f3f3']),
            'site_background_animation' =>  'none',
            'show_scroll_to_top_on_mobile'    => false,
            'show_main_banner_excerpt_mobile_option'  =>  false,
            'show_carousel_banner_excerpt_mobile_option'  =>  false,
            'show_archive_date_in_mobile'  =>  true,
            'show_readtime_mobile_option'  =>  true,
            'show_comment_number_mobile_option'  =>  false,
            'show_background_animation_on_mobile'  =>  false,
            'website_layout'    => 'full-width--layout',
            'site_block_title_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 18, 18, 18 ),
                'line_height' =>  blog_postx_default_responsive( 21, 21, 21 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'global_show_author_image'    => true,
            'social_icons' => json_encode([
                [
                    'icon_class'    => 'fa-brands fa-facebook-f',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    => 'fa-brands fa-instagram',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    => 'fa-brands fa-whatsapp',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ]
            ]),
            'footer_social_icons' => json_encode([
                [
                    'icon_class'    => 'fa-brands fa-facebook-f',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'icon_label'      => esc_html__( 'Facebook', 'blog-postx' ),
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    => 'fa-brands fa-instagram',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'icon_label'      => esc_html__( 'Instagram', 'blog-postx' ),
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    => 'fa-brands fa-whatsapp',
                    'icon_url'      => '',
                    'icon_count'      => '1K',
                    'icon_label'      => esc_html__( 'Twitter', 'blog-postx' ),
                    'item_option'   => 'show'
                ]
            ]),
            'global_button_typo'    => blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 14, 14, 14 ),
            ]),
            'audio_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' =>  'fa-solid fa-music' ]),
            'gallery_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-layer-group' ]),
            'image_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-image' ]),
            'quote_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-quote-left' ]),
            'standard_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' => 'fa-regular fa-file-lines' ]),
            'video_post_format_icon_picker' => blog_postx_default_icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-video' ]),
            'stt_text'  =>  esc_html__( '', 'blog-postx' ),
            'preloader_option'  => false,
            'post_title_hover_effects'  => 'eight',
            'site_image_hover_effects'  => 'five',
            'cursor_animation'  => 'none',
            'site_breadcrumb_option'    => false,
            'site_breadcrumb_type'  => 'default',
            'breadcrumb_typo'   =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 ),
            ]),
            'site_schema_ready' => true,
            'site_date_format'  => 'default',
            'site_date_to_show' => 'published',
            'disable_admin_notices'   => false,
            'site_title_hover_textcolor'=> '#222',
            'site_description_color'    => '#131315',
            'site_title_tag_for_frontpage'  =>  'h1',
            'site_title_tag_for_innerpage'  =>  'h2',
            'ticker_news_option'    => false,
            'ticker_news_posts_categories' => [],
            'ticker_news_posts_to_include' => [],
            'ticker_news_posts_order'    =>  'date-desc',
            'ticker_news_posts_to_show'   =>  3,
            'ticker_news_hide_empty'  =>  false,
            'ticker_pause_icon' =>  blog_postx_default_icon_picker([ 'value' => 'fa-solid fa-pause' ]),
            'ticker_play_icon' =>  blog_postx_default_icon_picker([ 'value' => 'fa-solid fa-play' ]),
            'ticker_news_border_radius' =>  blog_postx_default_responsive( 3, 3, 3 ),
            'ticker_news_post_title_typo'    =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 17, 17, 17 )
            ]),
            'main_banner_option'    => false,
            'main_banner_posts_categories' => [],
            'main_banner_posts_to_include' => [],
            'main_banner_trailing_posts_categories' => [],
            'main_banner_trailing_posts_to_include' => [],
            'default_typo_one'   =>  blog_postx_default_typography(),
            'default_typo_two'   =>  blog_postx_default_typography([ 
                'font_family'   => [ 'value' => 'Manrope', 'label' => 'Manrope' ],
            ]),
            'site_title_typo'   =>  blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 44, 44, 34 ),
                'line_height' =>  blog_postx_default_responsive( 45, 42, 40 )
            ]),
            'site_description_typo'   =>  blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 14, 14, 14 ),
                'line_height' =>  blog_postx_default_responsive( 22, 22, 22 )
            ]),
            'custom_button_label'  =>  'Subscribe',
            'custom_button_redirect_href_link' =>  home_url(),
            'custom_button_text_typography' =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'header_custom_button_background_color_group'   =>  [
                'initial'   => blog_postx_default_color([ 'solid' => '#000' ]),
                'hover'   => blog_postx_default_color([ 'solid' => '--blog-postx-global-preset-theme-color' ])
            ],
            'search_icon_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
            'theme_mode_dark_icon' => blog_postx_default_icon_picker([ 'value' => 'fas fa-moon' ]),
            'theme_mode_light_icon' => blog_postx_default_icon_picker([ 'value' => 'fas fa-sun' ]),
            'theme_mode_icon_size'    =>  blog_postx_default_responsive( 18, 18, 18 ),
            'header_buiilder_header_sticky'    =>  false,
            'header_first_row_header_sticky'    =>  true,
            'header_second_row_header_sticky'    =>  false,
            'header_third_row_header_sticky'    =>  false,
            'header_menu_hover_effect' =>  'none',
            'footer_menu_hover_effect' =>  'none',
            'main_menu_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 16, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 23, 23, 23 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'main_menu_sub_menu_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'archive_pagination_type'   => 'number',
            'pagination_button_background_color'    =>  [
                'initial'   => blog_postx_default_color([ 'solid' => '#fff' ]),
                'hover'   => blog_postx_default_color([ 'solid' => '#fff' ])
            ],
            'archive_post_column'    => blog_postx_default_responsive( 1, 1, 1 ),
            'archive_post_layout'   => 'block-two',
            'archive_sidebar_layout'    =>  'right-sidebar',
            'archive_post_elements_alignment'=> 'left',
            'archive_content_reorder'  =>  [
                [
                    'value' =>  'title',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'meta',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'excerpt',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'button',
                    'option'    =>  true,
                ],
            ],
            'archive_meta_reorder'  =>  [
                [
                    'value' =>  'author',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'date',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'read_time',
                    'option'    =>  true,
                ],
                [
                    'value' =>  'comment',
                    'option'    =>  true,
                ],
            ],
            'archive_image_size'  =>  'large',
            'archive_section_border_radius'   =>  3,
            'archive_title_typo'  => blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'line_height' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 ),
                'text_transform'    => 'Unset',
            ]), 
            'archive_excerpt_typo'  => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 25, 25, 25 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'archive_category_info_box_option'  => true,
            'archive_category_info_box_title_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'line_height' =>  blog_postx_default_responsive( 32, 32, 32 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'archive_category_info_box_description_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 25, 25, 25 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'archive_tag_info_box_option'  => true,
            'archive_tag_info_box_title_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'line_height' =>  blog_postx_default_responsive( 32, 32, 32 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'archive_tag_info_box_description_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 25, 25, 25 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'archive_author_info_box_option'  => true,
            'archive_author_info_box_title_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'line_height' =>  blog_postx_default_responsive( 32, 32, 32 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 ),
                'text_transform' => 'Capitalize'
            ]),
            'archive_author_info_box_description_typo'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 25, 25, 25 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'single_post_layout'   => 'layout-seven',
            'single_sidebar_layout'=> 'right-sidebar',
            'single_block_reorder' =>  [
                [ 
                    'value' =>  'category',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'title',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'meta',
                    'option'    =>  true
                ]
            ],
            'single_meta_reorder' =>  [
                [ 
                    'value' =>  'author',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'date',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'read_time',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'comments',
                    'option'    =>  true
                ]
            ],
            'single_post_content_alignment' =>  'left',
            'single_image_size'  =>  '2048x2048',
            'single_image_border_radius'   =>  3,
            'single_post_related_posts_option'  => true,
            'single_post_related_posts_title'   => esc_html__( 'Related Articles', 'blog-postx' ),
            'single_title_typo'  => blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 40, 36, 36 ),
                'line_height' =>  blog_postx_default_responsive( 52, 42, 47 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'single_content_typo'  => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.4, 0.4, 0.4 )
            ]),
            'single_page_border_radius' =>  3,
            'page_settings_sidebar_layout'  =>  'right-sidebar',
            'page_image_size'  =>  'large',
            'page_image_border_radius'   =>  16,
            'page_title_typo'  => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 32, 32, 32 ),
                'line_height' =>  blog_postx_default_responsive( 31, 31, 31 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'page_content_typo'  => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.4, 0.4, 0.4 )
            ]),
            'page_border_radius'  =>  16,
            'site_logo_width'  =>  blog_postx_default_responsive( 160, 160, 160 ),
            'header_custom_button_border_radius'  =>  blog_postx_default_responsive( 16, 16, 16 ),
            'custom_button_animation_type'  =>  'none',
            'canvas_menu_position'  =>  'left',
            'footer_social_icons_display_label' =>  true,
            'footer_social_icons_columns'   => 2,
            'footer_social_icons_display_count' =>  false,
            'main_banner_posts_to_show'   =>  5,
            'main_banner_trailing_posts_to_show'   =>  4,
            'main_banner_hide_empty'  =>  false,
            'main_banner_trailing_hide_empty'  =>  false,
            'main_banner_posts_order'    =>  'date-desc',
            'main_banner_trailing_posts_order'    =>  'date-desc',
            'main_banner_post_elements_alignment'  =>  'left',
            'main_banner_image_sizes'  =>  'large',
            'main_banner_image_border_radius'   =>  3,
            'main_banner_border_radius'   =>  blog_postx_default_responsive( 3, 3, 3 ),
            'main_banner_design_post_title_typography'  =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 21, 21, 21 ),
                'line_height' =>  blog_postx_default_responsive( 30, 30, 30 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'main_banner_sidebar_post_typography'  =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 22, 22, 22 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 ),
                'text_transform'    => 'unset',
            ]),
            'main_banner_design_post_excerpt_typography'  =>  blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 25, 25, 25 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'carousel_option'    => false,
            'carousel_posts_categories' => [],
            'carousel_posts_to_include' => [],
            'carousel_posts_to_show'   =>  5,
            'carousel_hide_empty'  =>  false,
            'carousel_posts_order'    =>  'date-desc',
            'carousel_post_elements_alignment'  =>  'center',
            'carousel_image_sizes'  =>  'large',
            'carousel_image_border_radius'  =>  [ 
                'desktop' => [ 'top' => 3, 'right' => 3, 'bottom' => 3, 'left' => 3, 'link' => true ],
                'tablet' => [ 'top' => 3, 'right' => 3, 'bottom' => 3, 'left' => 3, 'link' => true ],
                'smartphone' => [ 'top' => 3, 'right' => 3, 'bottom' => 3, 'left' => 3, 'link' => true ]
            ],
            'carousel_design_post_title_typography'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'line_height' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            'carousel_section_border_radius'   =>  3,
            // category collection
            'category_collection_option'    =>  false,
            'category_collection_show_count'    =>  true,
            'category_collection_number_of_columns'    =>  blog_postx_default_responsive( 3, 2, 1 ),
            'category_to_include' => [],
            'category_to_exclude' => [],
            'category_collection_number' => 3,
            'category_collection_orderby' => 'asc-name',
            'category_collection_image_radius'  =>  blog_postx_default_responsive( 3, 3, 3 ),
            'category_collection_image_size'  =>  'large',
            'category_collection_hover_effects'  =>  'none',
            'category_collection_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 14, 14, 14 ),
                'line_height' =>  blog_postx_default_responsive( 17, 17, 17 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            // you may have missed
            'you_may_have_missed_section_option' => true,
            'you_may_have_missed_title_option' => true,
            'you_may_have_missed_title' => esc_html__( 'You May Have Missed', 'blog-postx' ),
            'you_may_have_missed_no_of_columns'    =>  3,
            'you_may_have_missed_posts_categories' => [],
            'you_may_have_missed_posts_to_include' => [],
            'you_may_have_missed_posts_to_show'   =>  3,
            'you_may_have_missed_hide_empty'  =>  false,
            'you_may_have_missed_posts_order'    =>  'rand-desc',
            'you_may_have_missed_post_elements_alignment'  =>  'left',
            'you_may_have_missed_image_sizes'  =>  'large',
            'you_may_have_missed_design_post_title_typography'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'line_height' =>  blog_postx_default_responsive( 26, 26, 26 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'you_may_have_missed_border_radius'    =>  3,
            // theme footer
            'bottom_footer_site_info'   => esc_html__( 'Blog Postx - Blog WordPress Theme %year%.', 'blog-postx' ),
            'bottom_footer_header_or_custom'    =>  'header',
            'bottom_footer_logo_option'   =>  0,
            'bottom_footer_logo_width'  =>  blog_postx_default_responsive( 200, 200, 200 ),
            'heading_one_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 34, 34, 34 ),
                'line_height' =>  blog_postx_default_responsive( 44, 44, 44 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'heading_two_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'line_height' =>  blog_postx_default_responsive( 35, 35, 35 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'heading_three_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'line_height' =>  blog_postx_default_responsive( 31, 31, 31 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'heading_four_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 18, 18, 18 ),
                'line_height' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'heading_five_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 22, 22, 22 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'heading_six_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 14, 14, 14 ),
                'line_height' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'sidebar_border_radius'   => 3,
            'sidebar_image_border_radius'   =>  3,
            'sidebar_post_title_typography'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 21, 21, 21 ),
                'line_height' =>  blog_postx_default_responsive( 21, 21, 21 )
            ]),
            'sidebar_heading_one_typography'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'line_height' =>  blog_postx_default_responsive( 34, 34, 34 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_two_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'line_height' =>  blog_postx_default_responsive( 34, 34, 34 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_three_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 22, 22, 22 ),
                'line_height' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_four_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 20, 20, 20 ),
                'line_height' =>  blog_postx_default_responsive( 28, 28, 28 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_five_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 18, 18, 18 ),
                'line_height' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.2, 0.3 )
            ]),
            'sidebar_heading_six_typo'  =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 22, 22, 22 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_pagination_button_typo'    => blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Regular 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 13, 13, 13 ),
                'line_height' =>  blog_postx_default_responsive( 13, 13, 13 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 ),
                'text_transform'    => 'Capitalize'
            ]),
            'advertisement_repeater'   =>  json_encode([
                [
                    'item_code'    => 101,
                    'item_image'    => 0,
                    'item_url'      => home_url(),
                    'item_option'   => 'show',
                    'item_target'   =>  '_blank',
                    'item_rel_attribute'    =>  'nofollow',
                    'item_heading'  =>  esc_html__( 'Display Area', 'blog-postx' ),
                    'item_checkbox_before_post_content'  => false,
                    'item_checkbox_after_post_content'  =>  false,
                    'item_checkbox_random_post_archives'  =>    false,
                    'item_alignment'    =>  'center',
                    'item_image_option' =>  'original'
                ],
                [
                    'item_code'    => 102,
                    'item_image'    => 0,
                    'item_url'      => home_url(),
                    'item_option'   => 'show',
                    'item_target'   =>  '_blank',
                    'item_rel_attribute'    =>  'nofollow',
                    'item_heading'  =>  esc_html__( 'Display Area', 'blog-postx' ),
                    'item_checkbox_before_post_content'  => false,
                    'item_checkbox_after_post_content'  =>  false,
                    'item_checkbox_random_post_archives'  =>    false,
                    'item_alignment'    =>  'center',
                    'item_image_option' =>  'original'
                ]
            ]),
            'sortable_advertisement_number' => 101,
            'blogdescription_option'    =>  false,
            'footer_title_typography'    => blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 18, 18, 18 ),
                'line_height' =>  blog_postx_default_responsive( 34, 34, 34 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 ),
                'text_transform'    => 'Unset'
            ]),
            'footer_text_typography'    =>  blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Montserrat', 'label' => 'Montserrat' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 14, 14, 14 ),
                'line_height' =>  blog_postx_default_responsive( 23, 23, 23 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'bottom_footer_text_typography'    => blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'solid_color_preset' =>  [
                'color_palettes' => [
                    [ '#40E0D0', '#F4C430', '#FF00FF', '#007BA7', '#DC143C', '#7FFF00' ],
                    [ '#007FFF', '#FFBF00', '#50C878', '#8A2BE2', '#FF7F50' ],
                    [ '#008080', '#FFD700', '#E6E6FA', '#800000', '#808000', '#CCCCFF' ]
                ],
                'active_palette'    =>  '0'
            ],
            'gradient_color_preset' =>  [
                'color_palettes' => [
                    [ 'linear-gradient(135deg, #000000, #FFFF00)', 'linear-gradient(135deg, #191970, #FFD700)', 'linear-gradient(135deg, #4B0082, #FFA500)', 'linear-gradient(135deg, #FF8C00, #483D8B)', 'linear-gradient(135deg, #006400, #8B4513)', 'linear-gradient(135deg, #DC143C, #FFD700)' ],
                    [ 'linear-gradient(135deg, #00FFFF, #FF6347)', 'linear-gradient(135deg, #228B22, #8B4513)', 'linear-gradient(135deg, #F4A460, #DAA520)', 'linear-gradient(135deg, #FFD700, #FF6347)', 'linear-gradient(135deg, #9400D3, #87CEEB)', 'linear-gradient(135deg, #00FF00, #00FFFF)' ],
                    [ 'linear-gradient(135deg, #FFD700, #FFA500)', 'linear-gradient(135deg, #FF7F50, #FFD700)', 'linear-gradient(135deg, #483D8B, #00FFFF)', 'linear-gradient(135deg, #DC143C, #8B008B)', 'linear-gradient(135deg, #228B22, #2E8B57)', 'linear-gradient(135deg, #FF6347, #FFA500)' ],
                ],
                'active_palette'    =>  '0'
            ],
            'header_menu_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#c69270' ])
            ],
            'header_sub_menu_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#c69270' ])
            ],
            'search_icon_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#fff' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#fff' ])
            ],
            'theme_mode_dark_icon_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#fff' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#fff' ])
            ],
            'theme_mode_light_icon_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#fff' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#fff' ])
            ],
            'canvas_menu_icon_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#fff' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#fff' ])
            ],
            'stt_color_group' => [ 
                'initial'   =>  blog_postx_default_color( [ 'solid' => '#fff' ] ),
                'hover' =>  blog_postx_default_color( [ 'solid' => '#fff' ] )
            ],
            'pagination_button_text_color' => [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '#000' ])
            ],
            'typography_presets'    =>  [
                'typographies'    =>  [
                    blog_postx_default_typography([
                        'font_family'   => [ 'value' => 'Jost', 'label' => 'Jost' ],
                        'font_size'   => [
                            'desktop' => 16,
                            'tablet' => 16,
                            'smartphone' => 16
                        ],
                        'line_height'   => array(
                            'desktop' => 20,
                            'tablet' => 20,
                            'smartphone' => 20
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0.3,
                            'tablet' => 0.3,
                            'smartphone' => 0.3
                        )
                    ]),
                    blog_postx_default_typography([
                        'font_family'   => [ 'value' => 'Outfit', 'label' => 'Outfit' ],
                        'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                        'font_size'   => [
                            'desktop' => 13,
                            'tablet' => 13,
                            'smartphone' => 13
                        ],
                        'line_height'   => array(
                            'desktop' => 23,
                            'tablet' => 23,
                            'smartphone' => 23
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0.3,
                            'tablet' => 0.3,
                            'smartphone' => 0.3
                        ),
                        'text_transform'    => 'uppercase'
                    ]),
                    blog_postx_default_typography([
                        'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                        'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                        'font_size'   => [
                            'desktop' => 14,
                            'tablet' => 14,
                            'smartphone' => 14
                        ],
                        'line_height'   => array(
                            'desktop' => 25,
                            'tablet' => 25,
                            'smartphone' => 25
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0,
                            'tablet' => 0,
                            'smartphone' => 0
                        )
                    ])
                ],
                'labels'    =>  [ esc_html__( 'Typography 1', 'blog-postx' ), esc_html__( 'Typography 2', 'blog-postx' ), esc_html__( 'Typography 3', 'blog-postx' ) ]
            ],
            'header_builder'    =>  [
                '00'    =>  [ 'social-icons' ],
                '01'    =>  [ 'site-logo' ],
                '02'    =>  [  'search' ],
                '03'    =>  [],
                '10'    =>  [  'menu' ],
                '11'    =>  [],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  [],
            ],
            /* Date / Time */
            'time_option'    => true,
            'date_option'    => true,
            'date_time_typography'   =>  blog_postx_default_typography([
                'font_family'   => [ 'value' => 'Jost', 'label' => 'Jost' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 15, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 36, 36, 36 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0, 0, 0 )
            ]),
            'date_time_separator_color'   =>  blog_postx_default_color([ 'solid' => '' ]),
            'date_color'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
            'time_color'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
            /* Header builder */
            'header_builder_section_width'   =>  'boxed--layout',
            'header_builder_background'   =>  blog_postx_default_color(),
            /* First row */
            'header_first_row_column'  =>  3,
            'header_first_row_column_layout'  =>  blog_postx_default_responsive( 'one', 'two', 'two' ),
            'header_first_row_padding'   =>  [
                'desktop' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ]
            ],
            'header_first_row_column_one'   =>  blog_postx_default_responsive( 'left', 'left', 'left' ),
            'header_first_row_column_two'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'header_first_row_column_three'   =>  blog_postx_default_responsive( 'right', 'right', 'right' ),
            /* Second row */
            'header_second_row_column'  =>  1,
            'header_second_row_column_layout'  =>  blog_postx_default_responsive( 'two', 'two', 'four' ),
            'header_second_row_padding'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'header_second_row_column_one'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'header_second_row_column_two'   =>  blog_postx_default_responsive( 'right', 'right', 'right' ),
            'header_second_row_column_three'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            /* Third row */
            'header_third_row_column'  =>  2,
            'header_third_row_column_layout'  =>  blog_postx_default_responsive( 'one', 'two', 'three' ),
            'header_third_row_padding'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'header_third_row_column_one'   =>  blog_postx_default_responsive( 'left', 'left', 'left' ),
            'header_third_row_column_two'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'header_third_row_column_three'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            /* Footer Builder */
            'footer_builder'    =>  [
                '00'    =>  [ 'logo' ],
                '01'    =>  [],
                '02'    =>  [],
                '03'    =>  [],
                '10'    =>  [ 'social-icons' ],
                '11'    =>  [],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [ 'copyright','scroll-to-top' ],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  [],
            ],
            /* Footer builder */
            'footer_builder_section_width'   =>  'boxed--layout',
            /* Footer First row */
            'footer_first_row_column'  =>  1,
            'footer_first_row_column_layout'  =>  blog_postx_default_responsive( 'one', 'two', 'three' ),
            'footer_first_row_padding'   =>  [
                'desktop' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'footer_first_row_column_one'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_first_row_column_two'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_first_row_column_three'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_first_row_column_four'   =>  blog_postx_default_responsive( 'right', 'right', 'right' ),
            /* Footer Second row */
            'footer_second_row_column'  =>  1,
            'footer_second_row_column_layout'  =>  blog_postx_default_responsive( 'one', 'two', 'three' ),
            'footer_second_row_padding'   =>  [
                'desktop' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ]
            ],
            'footer_second_row_column_one'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_two'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_three'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_four'   =>  blog_postx_default_responsive( 'right', 'right', 'right' ),
            /* Footer Third row */
            'footer_third_row_column'  =>  1,
            'footer_third_row_column_layout'  =>  blog_postx_default_responsive( 'one', 'two', 'three' ),
            'footer_third_row_padding'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ]
            ],
            'footer_third_row_column_one'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_two'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_three'   =>  blog_postx_default_responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_four'   =>  blog_postx_default_responsive( 'right', 'right', 'right' ),
            /* Responsive header builder */
            'responsive_header_builder' =>  [
                '00'    =>  [ 'site-logo' ],
                '01'    =>  [],
                '02'    =>  [ 'toggle-button' ],
                '03'    =>  [],
                '10'    =>  [],
                '11'    =>  [],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  [],
                'responsive-canvas' =>  [ 'menu' ]
            ],
            'mobile_canvas_alignment'   =>  'left',
            'mobile_canvas_icon_color'  =>  [
                'initial'   =>  blog_postx_default_color([ 'solid' => '--blog-postx-global-preset-theme-color' ]),
                'hover'   =>  blog_postx_default_color([ 'solid' => '--blog-postx-global-preset-theme-color' ])
            ],
            'footer_menu_typography'    =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 23, 23, 23 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'footer_menu_color' =>  [ 
                'initial'   =>  blog_postx_default_color([ 'solid' => '#000' ]),
                'hover' =>  blog_postx_default_color([ 'solid' => '--blog-postx-global-preset-theme-color' ])
            ],
            'global_author_typography'  =>  blog_postx_default_typography(),
            'global_date_typography'  =>  blog_postx_default_typography(),
            'global_comments_typography'  =>  blog_postx_default_typography(),
            'global_read_time_typography'  =>  blog_postx_default_typography(),
            'global_category_typography'  =>  blog_postx_default_typography(),
            // MARK: Sticky Posts
            'sticky_posts_option' =>  true,
            'sticky_posts_position' =>  'left',
            'sticky_posts_posts_to_append' =>  5,
            'sticky_posts_categories' =>  [],
            'sticky_posts_to_include' =>  [],
            'sticky_posts_order' =>  'date-desc',
            'sticky_posts_to_show' =>  8,
            'sticky_hide_empty' =>  true,
            'sticky_posts_label_typography' =>  blog_postx_default_typography(),
            'sticky_posts_title_typography' =>  blog_postx_default_typography(),
            // MARK: REORDER SECTION
            'frontpage_reorder_control' =>  [
                [ 
                    'value' =>  'ticker_news',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'web_stories',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'main_banner',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'carousel',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'category_collection',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'latest_posts',
                    'option'    =>  true
                ],
                [ 
                    'value' =>  'advertisement',
                    'option'    =>  true
                ]
            ],
            // MARK: WEB STORIES
            'web_stories_option'    =>  true,
            'web_stories_categories_to_include' =>  [],
            'web_stories_orderby'   =>  'asc-name',
            'web_stories_no_of_cats_to_show'    =>  5,
            'web_stories_max_no_of_inner_stories'   =>  10,
            'web_stories_image_sizes'   =>  'large',
            'web_stories_image_radius'  =>  3,
            'web_stories_preview_count_typo'    =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 12, 12, 12 ),
                'line_height' =>  blog_postx_default_responsive( 18, 18, 18 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'web_stories_preview_title_typo'    =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 16, 16, 16 ),
                'line_height' =>  blog_postx_default_responsive( 24, 24, 24 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'web_stories_title_typo'    =>  blog_postx_default_typography([
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  blog_postx_default_responsive( 22, 22, 22 ),
                'line_height' =>  blog_postx_default_responsive( 32, 32, 32 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            // MARK: Secondary Menu
            'header_secondary_menu_hover_effect' =>  'none',
            'header_secondary_menu_typo'    =>  blog_postx_default_typography([
                'font_size' =>  blog_postx_default_responsive( 16, 15, 15 ),
                'line_height' =>  blog_postx_default_responsive( 23, 23, 23 ),
                'letter_spacing' =>  blog_postx_default_responsive( 0.3, 0.3, 0.3 )
            ]),
            'header_secondary_menu_color'   =>  blog_postx_default_color()
        ]);
        return $array_defaults;
    }
endif;

if( ! function_exists( 'blog_postx_get_customizer_default' ) ) :
    /**
     * Gets customizer "theme_mods" value
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_get_customizer_default( $key ) { 
        $array_defaults = blog_postx_customizer_default_array();
        $totalCats = get_categories([ 'fields' => 'ids', 'hide_empty' => false ]);
        if( $totalCats ) :
            foreach( $totalCats as $index => $cat_id ) :
                $array_defaults[ 'category_colors' ][ $cat_id ][ 'color' ] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                    'hover'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                ];
                $array_defaults[ 'category_colors' ][ $cat_id ][ 'background' ] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' => blog_postx_random_category_colors( $index )
                    ],
                    'hover' =>  [
                        'type'  =>  'solid',
                        'solid' => blog_postx_random_category_colors( $index )
                    ]
                ];
            endforeach;
        else:
            $array_defaults[ 'category_colors' ] = [];
        endif;
        $totalTags = get_tags([ 'fields' => 'ids', 'hide_empty' => false ]);
        if( $totalTags ) :
            foreach( $totalTags as $tag_id ) :
                $array_defaults[ 'tag_colors' ][ $tag_id ][ 'color' ] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                    'hover'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ]
                ];
                $array_defaults[ 'tag_colors' ][ $tag_id ][ 'background' ] = [
                    'initial'    => [
                        'type'  =>  'solid',
                        'solid' => '--blog-postx-global-preset-theme-color' 
                    ],
                    'hover'    => [
                        'type'  =>  'solid',
                        'solid' => '--blog-postx-global-preset-theme-color'
                    ]
                ];
            endforeach;
        else:
            $array_defaults[ 'tag_colors' ] = [];
        endif;
        return $array_defaults[$key];
    }
endif;

if( ! function_exists( 'blog_postx_default_box_shadow' ) ) :
    /**
     * Box Shadow Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_box_shadow( $append = [] ) {
        $default = [
            'option'    => true,
            'hoffset'   => 0,
            'voffset'   => 0,
            'blur'  => 20,
            'spread'    => 0,
            'type'  => 'outset',
            'color' => 'rgb(0 0 0 / 3%)'
        ];
        if( ! empty( $append ) && is_array( $append ) ) return array_merge( $default, $append );
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_default_responsive' ) ) :
    /**
     * Responsive Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_responsive( $desktop = 0, $tablet = 0, $smartphone = 0 ) {
        $default = [
            'desktop'   =>  $desktop,
            'tablet'    =>  $tablet,
            'smartphone'    =>  $smartphone
        ];
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_default_typography' ) ) :
    /**
     * Typography Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_typography( $append = [] ) {
        $default = [
            'font_family'   => [ 'value' => 'Jost', 'label' => 'Jost' ],
            'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
            'font_size'   => [
                'desktop'   =>  13,
                'tablet'   =>  13,
                'smartphone'   =>  13
            ],
            'line_height'   => [
                'desktop'   =>  21,
                'tablet'   =>  21,
                'smartphone'   =>  21
            ],
            'letter_spacing'   => [
                'desktop'   =>  0,
                'tablet'   =>  0,
                'smartphone'   =>  0
            ],
            'text_transform'    => 'unset',
            'text_decoration'    => 'none',
            'preset'    =>  '-1'
        ];
        if( ! empty( $append ) && is_array( $append ) ) return array_merge( $default, $append );
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_default_border' ) ) :
    /**
     * Border Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_border( $append = [] ) {
        $default = [
            "type"  =>  "none", 
            "width"   =>    [ 'top' => 1, 'right' => 1, 'bottom' => 1, 'left' => 1, 'link' => true ],
            "color"   =>    "#000"
        ];
        if( ! empty( $append ) && is_array( $append ) ) return array_merge( $default, $append );
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_default_color' ) ) :
    /**
     * Color Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_color( $append = [] ) {
        $default = [ 
            'type'  =>  'solid',
            'solid' =>  '#fff'
        ];
        if( ! empty( $append ) && is_array( $append ) ):
            $append_keys = array_keys( $append );
            $default['type'] = $append_keys[0];
            return array_merge( $default, $append );
        endif;
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_default_icon_picker' ) ) :
    /**
     * Icon Picker Default
     * 
     * @since 1.0.0
     */
    function blog_postx_default_icon_picker( $append = [] ) {
        $default = [
            'type'  => 'icon',
            'value' => 'fa-solid fa-arrow-right'
        ];
        if( ! empty( $append ) && is_array( $append ) ) return array_merge( $default, $append );
        return $default;
    }
endif;

if( ! function_exists( 'blog_postx_random_category_colors' ) ) :
    /**
     * Random Category Colors
     */
    function blog_postx_random_category_colors( $index = 0 ) {
        $colors = [ 
            "#00695C", "#512DA8", "#E65100", "#1565C0", "#C62828", "#1E88E5", "#4A148C", "#2E7D32", "#283593", "#6A1B9A", "#311B92", "#1B5E20", "#B71C1C", "#0D47A1", "#BF360C", "#00897B", "#1976D2", "#D32F2F", "#7B1FA2", "#F57C00" 
        ];
        return isset( $colors[ $index ] ) ? $colors[ $index ] : $colors[0];
    }
endif;