<?php
/**
 * Includes the inline css
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

// Value change single
if( ! function_exists( 'blog_postx_value_change' ) ) :
   /**
   * Generate css code for variable change with responsive
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_value_change ( $selector, $control, $property ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      echo $selector, "{ ", esc_html( $property ), " : ", esc_html($decoded_control), "px; }";
   }
endif;

// Value change with responsive
if( ! function_exists( 'blog_postx_value_change_responsive' ) ) :
   /**
   * Generate css code for variable change with responsive
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_value_change_responsive ( $selector, $control, $property, $unit = 'px' ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( isset( $decoded_control['desktop'] ) ) :
         $desktop = $decoded_control['desktop'];
            echo $selector, "{ ", esc_html( $property ), ": ", esc_html( $desktop ), esc_html( $unit ), "; }";
         endif;
         if( isset( $decoded_control['tablet'] ) ) :
            $tablet = $decoded_control['tablet'];
            echo "@media(max-width: 940px) { ", $selector, "{ ", esc_html( $property ), ": ", esc_html( $tablet ), esc_html( $unit ), "; } }\n";
         endif;
         if( isset( $decoded_control['smartphone'] ) ) :
            $smartphone = $decoded_control['smartphone'];
            echo "@media(max-width: 610px) { ", $selector, "{ ", esc_html( $property ), ": ", esc_html( $smartphone  ), esc_html( $unit ), "; } }\n";
      endif;
   }
endif;

if( ! function_exists( 'blog_postx_typography_control' ) ) :
   /**
   * Generate css code for typography control.
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_typography_control( $selector, $control, $is_variable = false ) {
      $property = $selector;
      if( $is_variable ) $selector = 'body.blog-postx-variables';
      if( ! empty( $control ) && is_array( $control ) ) :
         $value = $control;
      else:
         $value = BPX\blog_postx_get_customizer_option( $control );
         if( $value === BPX\blog_postx_get_customizer_default( $control ) ) return;
      endif;
      if( ! $value ) return;
      $is_preset = false;
      if( array_key_exists( 'preset', $value ) && $value['preset'] !== '-1' ) :
         $variable = '--blog-postx-global-preset-typography-'. absint( (int) $value['preset'] + 1 ) .'-font';
         $is_preset = true;
      endif;
      echo $selector, "{\n";
      if( isset( $value['font_family'] ) ) echo ( $is_variable ? $property . '-family' : 'font-family' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-family)' ) : esc_html( $value['font_family']['value'] ) ), ";\n";
      if( isset( $value['font_weight'] ) ) echo ( $is_variable ? $property . '-weight': 'font-weight' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-weight)' ) : esc_html( $value['font_weight']['value'] ) ), ";\n", ( $is_variable ? $property . '-style' : 'font-style' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-style)' ) : esc_html( $value['font_weight']['variant'] ) ), ";\n";
      if( isset( $value['text_transform'] ) ) echo ( $is_variable ? $property . '-texttransform' : 'text-transform' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-texttransform)' ) : esc_html( $value['text_transform'] ) ), ";\n";
      if( isset( $value['text_decoration'] ) ) echo ( $is_variable ? $property . '-textdecoration' : 'text-decoration' ), " : ", ( $is_preset ? ( 'var(' . $variable . '-textdecoration)' ) : esc_html( $value['text_decoration'] ) ), ";\n";
      if( isset( $value['font_size'] ) && isset( $value['font_size']['desktop'] ) ) echo ( $is_variable ? $property . '-size' : 'font-size' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-size)' ) : esc_html( $value['font_size']['desktop'] ) . 'px' ), ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['desktop'] ) ) echo ( $is_variable ? $property . '-lineheight' : 'line-height' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-lineheight)' ) : esc_html( $value['line_height']['desktop'] ) . 'px' ), ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['desktop'] ) ) echo ( $is_variable ? $property . '-letterspacing' : 'letter-spacing' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-letterspacing)' ) : esc_html( $value['letter_spacing']['desktop'] ) . 'px' ), ";\n";
      if( ! $is_variable ) echo "}\n";
   
      // tablet responsive
      if( ! $is_variable ) echo "@media(max-width: 940px) {", $selector, "{\n"; 
      if( isset( $value['font_size'] ) && isset( $value['font_size']['tablet'] ) ) echo ( $is_variable ? $property . '-size-tab' : 'font-size' ) ,": ", ( $is_preset ? ( 'var(' . $variable . '-size-tab)' ) : esc_html( $value['font_size']['tablet'] ) . 'px' ), ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['tablet'] ) ) echo ( $is_variable ? $property . '-lineheight-tab' : 'line-height' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-lineheight-tab)' ) : esc_html( $value['line_height']['tablet'] ) . 'px' ), ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['tablet'] ) ) echo ( $is_variable ? $property . '-letterspacing-tab' : 'letter-spacing' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-letterspacing-tab)' ) : esc_html( $value['letter_spacing']['tablet'] ) . 'px' ), ";\n";
      if( ! $is_variable ) echo "}}\n"; 
      // mobile responsive
      if( ! $is_variable ) echo "@media(max-width: 610px) {", $selector, "{\n"; 
      if( isset( $value['font_size'] ) && isset( $value['font_size']['smartphone'] ) ) echo ( $is_variable ? $property . '-size-mobile' : 'font-size' ) ,": ", ( $is_preset ? ( 'var(' . $variable . '-size-mobile)' ) : esc_html( $value['font_size']['smartphone'] ) . 'px' ), ";\n";
      if( isset( $value['line_height'] ) && isset( $value['line_height']['smartphone'] ) ) echo ( $is_variable ? $property . '-lineheight-mobile' : 'line-height' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-lineheight-mobile)' ) : esc_html( $value['line_height']['smartphone'] ) . 'px' ), ";\n";
      if( isset( $value['letter_spacing'] ) && isset( $value['letter_spacing']['smartphone'] ) ) echo ( $is_variable ? $property . '-letterspacing-mobile' : 'letter-spacing' ), ": ", ( $is_preset ? ( 'var(' . $variable . '-letterspacing-mobile)' ) : esc_html( $value['letter_spacing']['smartphone'] ) . 'px' ), ";\n";
      if( ! $is_variable ) echo "}}\n";
      if( $is_variable ) echo "}\n";
   }
endif;

// Assign Variable
if( ! function_exists( 'blog_postx_assign_var' ) ) :
   /**
   * Generate css code for top header color options
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_assign_var( $selector, $control) {
      $decoded_control =  BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      echo " body { ", esc_html( $selector ), ": ", esc_html( $decoded_control ), ";}\n";
   }
endif;

// Text Color ( Variable Change Single )
if( ! function_exists( 'blog_postx_variable_color_single' ) ) :
   /**
   * Generate css code for top header color options
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_variable_color_single( $selector, $control) {
      $decoded_control =  BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      $type = $decoded_control['type'];
      echo "body  { ", $selector, ": ", blog_postx_get_color_format( $decoded_control[ $type ]), ";}";
   }
endif;

// Text Color ( Variable Change )
if( ! function_exists( 'blog_postx_variable_color' ) ) :
   /**
   * Generate css code for top header color options
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_variable_color( $selector, $control) {
      $decoded_control =  BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( isset( $decoded_control['initial'] ) ) :
         $initial = $decoded_control['initial'];
         echo "body.blog-postx-variables  { ", $selector, ": ", blog_postx_get_color_format( $initial[ $initial['type'] ] ), ";}";
      endif;
      if( isset( $decoded_control['hover'] ) ) :
         $hover = $decoded_control['hover'];
         echo "body.blog-postx-variables  { ", $selector, "-hover : ", blog_postx_get_color_format( $hover[ $hover['type'] ] ), "; }";
      endif;
   }
endif;

// Color Group ( Variable Change )
if( ! function_exists( 'blog_postx_variable_bk_color' ) ) :
   /**
   * Generate css code for top header color options
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_variable_bk_color( $selector, $control, $var = '' ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if(isset($decoded_control['initial'] )):
         if( isset( $decoded_control['initial']['type'] ) ) :
            $type = $decoded_control['initial']['type'];
            if( isset( $decoded_control['initial'][$type] ) ) echo "body.blog-postx-variables { ", $selector, ": ", blog_postx_get_color_format( $decoded_control['initial'][$type] ), "}\n";
         endif;
      endif;

      if(isset($decoded_control['hover'])):
         if( isset( $decoded_control['hover']['type'] ) ) :
            $type = $decoded_control['hover']['type'];
            if( isset( $decoded_control['hover'][$type] ) ) echo "body.blog-postx-variables { ", $selector, "-hover: ", blog_postx_get_color_format( $decoded_control['hover'][$type] ), "}\n";
         endif;
      endif;
   }
endif;

// Category colors
if( ! function_exists( 'blog_postx_category_bk_colors_styles' ) ) :
   /**
    * Generates css code for font size
   *
   * @package Blog Postx Pro
   * @since 1.0.0
   */
   function blog_postx_category_bk_colors_styles() {
      $category_colors = BPX\blog_postx_get_customizer_option( 'category_colors' );
      $default_category_colors = BPX\blog_postx_get_customizer_default( 'category_colors' );
      $is_category_archive = is_category();
      if( $category_colors ) :
         foreach( $category_colors as $term_id => $cat_value ) :
            // if( $default_category_colors[ $term_id ] === $cat_value ) continue;
            extract( $cat_value );
            $initial_selector = 'body .post-categories .cat-item.cat-' . $term_id . ' a, .widget_blog_postx_category_collection_widget .categories-wrap .category-item.cat-' . $term_id . ' .category-name, .blog-postx-web-stories .stories-wrap .story[data-id="'. $term_id .'"] .preview .story-count, .admin-bar .blog-postx-web-stories .inner-stories-wrap.open.cat-' . $term_id . ', .blog-postx-category-collection-section .category-wrap .category-count.cat-' . $term_id . ' {';
            $hover_selector = 'body .post-categories .cat-item.cat-' . $term_id . ' a:hover, .widget_blog_postx_category_collection_widget .categories-wrap .category-item.cat-' . $term_id . ' .category-name:hover, .blog-postx-web-stories .stories-wrap .story[data-id="'. $term_id .'"] .preview .story-count:hover, .blog-postx-category-collection-section .category-wrap .category-name a:hover .category-count.cat-' . $term_id . ' {';
            $archive_selector = "body.archive.category.category-" . $term_id;

            if( isset( $color['initial'] ) ):
               if( isset( $color['initial']['type'] ) ) :
                  $type = $color['initial']['type'];
                  if( isset( $color['initial'][$type] ) ) {
                     $initial_selector .= " color : " . blog_postx_get_color_format( $color['initial'][$type] ) . ";\n";
                     if( $is_category_archive ) echo $archive_selector, " { color : ", blog_postx_get_color_format( $color['initial'][$type] ), "} \n";
                  }
               endif;
            endif;

            if(isset($color['hover'] )):
               if( isset( $color['hover']['type'] ) ) :
                  $type = $color['hover']['type'];
                  if( isset( $color['hover'][$type] ) ) {
                     $hover_selector .= "color : " . blog_postx_get_color_format( $color['hover'][$type] ) . ";\n";
                     if( $is_category_archive ) echo $archive_selector, ":hover { color : ", blog_postx_get_color_format( $color['hover'][$type] ), "} \n";
                  }
               endif;
            endif;

            if(isset($background['initial'] )):
               if( isset( $background['initial']['type'] ) ) :
                  $type = $background['initial']['type'];
                  if( isset( $background['initial'][$type] ) ) {
                     $initial_selector .= "background : " . blog_postx_get_color_format( $background['initial'][$type] ) . ";\n";
                     if( $is_category_archive ) echo $archive_selector, " .archive-title i { color : ", blog_postx_get_color_format( $background['initial'][$type] ), "}\n";
                  }
               endif;
            endif;

            if(isset($background['hover'] )) :
               if( isset( $background['hover']['type'] ) ) :
                  $type = $background['hover']['type'];
                  if( isset( $background['hover'][$type] ) ) $hover_selector .= "background : " . blog_postx_get_color_format( $background['hover'][$type] ) . ";\n";
               endif;
            endif;
            $initial_selector .=  "}\n";
            $hover_selector .=  "}\n";
            echo $initial_selector, $hover_selector;
         endforeach;
      endif;
   }
endif;

// tags colors
if( ! function_exists( 'blog_postx_tags_bk_colors_styles' ) ) :
   /**
    * Generates css code for font size
   *
   * @package Blog Postx Pro
   * @since 1.0.0
   */
   function blog_postx_tags_bk_colors_styles() {
      $tag_colors = BPX\blog_postx_get_customizer_option( 'tag_colors' );
      $default_tag_colors = BPX\blog_postx_get_customizer_default( 'tag_colors' );
      if( $tag_colors ) :
         foreach( $tag_colors as $term_id => $tag_value ) :
            if( $default_tag_colors[ $term_id ] === $tag_value ) return;
            extract( $tag_value );
            $selector = "body .tags-wrap .tags-item.tag-" . $term_id;

            if(isset($color['initial'] )):
               if( isset( $color['initial']['type'] ) ) :
                  $type = $color['initial']['type'];
                  if( isset( $color['initial'][$type] ) ) echo $selector, " span { color : ", blog_postx_get_color_format( $color['initial'][$type] ), "} \n";
               endif;
            endif;

            if(isset($color['hover'] )):
               if( isset( $color['hover']['type'] ) ) :
                  $type = $color['hover']['type'];
                  if( isset( $color['hover'][$type] ) ) echo $selector, ":hover span { color : ", blog_postx_get_color_format( $color['hover'][$type] ), "} \n";
               endif;
            endif;

            if(isset($background['initial'] )) :
               if( isset( $background['initial']['type'] ) ) :
                  $type = $background['initial']['type'];
                  if( isset( $background['initial'][$type] ) ) echo $selector, "{ background : ", blog_postx_get_color_format( $background['initial'][$type] ), "} \n";
               endif;
            endif;

            if(isset($background['hover'] )) :
               if( isset( $background['hover']['type'] ) ) :
                  $type = $background['hover']['type'];
                  if( isset( $background['hover'][$type] ) ) echo $selector, ":hover { background : ", blog_postx_get_color_format( $background['hover'][$type] ), "} \n";
               endif;
            endif;
         endforeach;
      endif;
   }
endif;

// Border Options
if( ! function_exists( 'blog_postx_border_option' ) ) :
   /**
   * Generate css code for Top header Text Color
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_border_option( $selector, $control ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( isset( $decoded_control['type'] ) || isset( $decoded_control['width'] ) || isset( $decoded_control['color'] ) ) :
         $width = $decoded_control['width'];
         echo $selector, '{ border-color: ', blog_postx_get_color_format($decoded_control['color']), '; border-style: ', esc_html( $decoded_control['type'] ), '; border-width: ', $width['top'], 'px ', $width['right'], 'px ', $width['bottom'], 'px ', $width['left'], 'px;', '}';
      endif;
   }
endif;

// Box Shadow
if( ! function_exists( 'blog_postx_box_shadow_styles' ) ) :
   /**
    * Generates css code for block box shadow size
    *
    * @package Blog Postx Pro
    * @since 1.0.0
    */
   function blog_postx_box_shadow_styles( $selector, $value ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $value );
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $value ) ) return;
      if( $decoded_control['option'] == '' ) :
         echo $selector, "{ box-shadow: 0px 0px 0px 0px; }\n";
      else:
         if( $decoded_control['type'] == 'outset') $decoded_control['type'] = '';
         echo $selector, '{ box-shadow : ', esc_html( $decoded_control['type'] ), ' ',esc_html( $decoded_control['hoffset'] ), 'px ', esc_html( $decoded_control['voffset'] ), 'px ', esc_html( $decoded_control['blur'] ), 'px ', esc_html( $decoded_control['spread'] ), 'px ', blog_postx_get_color_format( $decoded_control['color'] ), ";}\n";
      endif;
   }
endif;

// Image ratio change
if( ! function_exists( 'blog_postx_image_ratio' ) ) :
   /**
   * Generate css code image ration controls
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_image_ratio( $selector, $control, $is_variable = false ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      $value = '100%';
      if( $is_variable ) echo "body.blog-postx-variables {\n";
      // if( isset( $decoded_control['desktop'] ) ) :
         if( $is_variable ) {
            echo $selector, " : ", esc_html( $decoded_control['desktop'] ), ";\n";
         } else {
            echo $selector, "{ padding-bottom : calc(", esc_html( $decoded_control['desktop'] ), " * ", esc_html( $value ), "); }";
         }
      // endif;
      // if( isset( $decoded_control['tablet'] ) ) :
         if( $is_variable ) {
            echo $selector, "-tab : ", esc_html( $decoded_control['tablet'] ), ";\n";
         } else {
            echo "@media(max-width: 940px) { ", $selector, "{ padding-bottom : calc(", esc_html( $decoded_control['tablet'] ), "* ", esc_html( $value ), "); } }\n";
         }
      // endif;
      // if( isset( $decoded_control['smartphone'] ) ) :
         if( $is_variable ) {
            echo $selector, "-mobile : ", esc_html( $decoded_control['smartphone'] ), ";\n";
         } else {
            echo "@media(max-width: 610px) { ", $selector, "{ padding-bottom : calc(", esc_html( $decoded_control['smartphone'] ), " * ", esc_html( $value ), "); } }\n";
         }
      // endif;
      if( $is_variable ) echo '}';
   }
endif;

// Background Color (Initial Variable)
if( ! function_exists( 'blog_postx_initial_bk_color_variable' ) ) :
   /**
   * Generate css code for top header color options
   *
   * @package Blog Postx Pro
   * @since 1.0.0 
   */
   function blog_postx_initial_bk_color_variable( $selector, $control ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( array_key_exists( 'type', $decoded_control ) && isset( $decoded_control[ $decoded_control['type'] ] ) )  echo "body { ", $selector, " : ", blog_postx_get_color_format( $decoded_control[ $decoded_control['type'] ] ), "}\n";
   }
endif;

// Site Background Color
if( ! function_exists( 'blog_postx_background_control' ) ) :
   /**
    * Generate css code for background control.
    *
    * @package Blog Postx Pro
    * @since 1.0.0 
    */
   function blog_postx_background_control( $selector, $control, $property = 'background' ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( isset( $decoded_control['type'] ) ) :
         $type = $decoded_control['type'];
         switch( $type ) {
            case 'image' : 
                  echo $selector, " { \n";
                  if( isset( $decoded_control[$type]['url'] ) ) echo "background-image: url(", esc_url( $decoded_control[$type]['url'] ), ");\n";
                  if( isset( $decoded_control['repeat'] ) ) echo "background-repeat: ", esc_html( $decoded_control['repeat'] ), ";\n";
                  if( isset( $decoded_control['position'] ) ) echo "background-position:", esc_html( $decoded_control['position'] ), ";\n";
                  if( isset( $decoded_control['attachment'] ) ) echo "background-attachment: ", esc_html( $decoded_control['attachment'] ), ";\n";
                  if( isset( $decoded_control['size'] ) ) echo "background-size: ", esc_html( $decoded_control['size'] ), ";\n";
                  echo '}';
               break;
            default: if( isset( $decoded_control[$type] ) ) echo $selector . "{ ". $property .": " .blog_postx_get_color_format( $decoded_control[$type] ). "}";
         }
      endif;
   }
endif;

// spacing control
if( ! function_exists( 'blog_postx_spacing_control' ) ) :
   /**
    * Generate css code for variable change with responsive for spacing controls
    *
    * @package Blog Postx Pro
    * @since 1.0.0
    */
    function blog_postx_spacing_control( $selector, $control, $property ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( ! $decoded_control ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( isset( $decoded_control['desktop'] ) ) :
         $desktop = $decoded_control['desktop'];
         echo $selector, '{ ', esc_html( $property ), ' : ', esc_html( $desktop['top'] ), 'px ', esc_html( $desktop['right'] ), 'px ', esc_html( $desktop['bottom'] ),'px ', esc_html( $desktop['left'] ),'px; }';
      endif;
      if( isset( $decoded_control['tablet'] ) ) :
         $tablet = $decoded_control['tablet'];
         echo '@media(max-width: 940px) {', $selector, '{ ', esc_html( $property ), ' : ', esc_html( $tablet['top'] ), 'px ', esc_html( $tablet['right'] ), 'px ', esc_html( $tablet['bottom'] ), 'px ', esc_html( $tablet['left'] ), 'px ;} }';
      endif;
      if( isset( $decoded_control['smartphone'] ) ) :
         $smartphone = $decoded_control['smartphone'];
         echo '@media(max-width: 610px) { ', $selector, '{ ', esc_html( $property ), ' : ', esc_html( $smartphone['top'] ), 'px ', esc_html( $smartphone['right'] ), 'px ', esc_html( $smartphone['bottom'] ), 'px ', esc_html( $smartphone['left'] ), 'px; } }';
      endif;
    }
endif;
if( ! function_exists( 'blog_postx_preset_color_control' ) ) :
   /**
    * Generate css variable
    * 
    * @since 1.0.0
    */
    function blog_postx_preset_color_control( $control, $variable ) {
      $decoded_control = BPX\blog_postx_get_customizer_option( $control );
      if( empty( $decoded_control ) || ! is_array( $decoded_control ) ) return;
      if( $decoded_control === BPX\blog_postx_get_customizer_default( $control ) ) return;
      if( array_key_exists( 'color_palettes', $decoded_control ) && array_key_exists( 'active_palette', $decoded_control ) ) :
         extract( $decoded_control );
         $colors = $color_palettes[ $active_palette ];
         if( ! empty( $colors ) && is_array( $colors ) ) :
            echo "body {\n";
            foreach( $colors as $index => $color ) :
               $count = $index + 1;
               echo $variable, $count, ": ", esc_html( $color ), ";\n";
            endforeach;
            echo "}\n";
         endif;
      endif;
    }
endif;
if( ! function_exists( 'blog_postx_typography_preset' ) ) :
   /**
    * Generate css variable
    * 
    * @since 1.0.0
    */
    function blog_postx_typography_preset() {
      $decoded_control = BPX\blog_postx_get_customizer_option( 'typography_presets' );
      // if( $decoded_control === BPX\blog_postx_get_customizer_default( 'typography_presets' ) ) return;
      if( count( $decoded_control ) > 0 ) :
         $typographies = $decoded_control['typographies'];
         $labels = $decoded_control['labels'];
         if( count( $typographies ) > 0 ) :
            foreach( $typographies as $index => $typography ) :
               $variable = '--blog-postx-global-preset-typography-';
               $count = $index + 1;
               $variable .= $count . '-font';
               blog_postx_typography_control( $variable, $typography, true );
            endforeach;
         endif;
      endif;
    }
endif;