<?php
/**
 * Top Header hooks and functions
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

if( ! function_exists( 'blog_postx_date_time_part' ) ) :
    /**
     * Top header menu element
     * 
    * @since 1.0.0
    */
    function blog_postx_date_time_part() {
        $time_option = BPX\blog_postx_get_customizer_option( 'time_option' );
        $date_option = BPX\blog_postx_get_customizer_option( 'date_option' );
        ?>
            <div class="top-date-time">
                <span class="top-date-time-inner">
                    <?php
                        if( $time_option ) echo '<span class="time">', date( 'H:i:s A' ) ,'</span>';
                        if( $time_option && $date_option ) echo '<span class="separator">', blog_postx_get_icon_control_html([ 'value' => 'fa-solid fa-ellipsis-vertical', 'type' => 'icon' ]) ,'</span>';
                        if( $date_option ) echo '<span class="date">', date_i18n( 'l, ' . get_option( 'date_format' ), current_time( 'timestamp' )) ,'</span>';
                    ?>
                </span>
            </div>
        <?php
    }
    add_action( 'blog_postx_date_time_hook', 'blog_postx_date_time_part', 10 );
endif;

if( ! function_exists( 'blog_postx_social_part' ) ) :
    /**
     * Top header social element
     * 
     * @since 1.0.0
     */
    function blog_postx_social_part() {
        ?>
            <div class="social-icons-wrap">
                <?php blog_postx_customizer_social_icons( '', 4 ); ?>
            </div>
        <?php
    }
    add_action( 'blog_postx_social_icons_hook', 'blog_postx_social_part', 10 );
endif;