<?php
/**
 * Single Hooks
 * 
 * @since 1.0.0
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;

if( ! function_exists( 'blog_postx_single_layout_seven' ) ) :
    /**
     * Renders the opening div to wrap main content
     */
    function blog_postx_single_layout_seven() {
        $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        $is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
        $is_seven = ( ( $single_post_layout === 'layout-seven' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-seven' ) );
        if( $is_seven ) blog_postx_single_header_html();
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_single_layout_seven', 10 );
endif;

if( ! function_exists( 'blog_postx_single_title' ) ) :
    /**
     * Title
     */
    function blog_postx_single_title( $title_option = true ) {
        if( $title_option ) :
            the_title( '<div class="title-wrapper"><h2 class="entry-title" ' .blog_postx_schema_article_name_attributes(). '>', '</h2></div>' );
        endif;
    }
endif;

if( ! function_exists( 'blog_postx_single_excerpt' ) ) :
    /**
     * Excerpt
     */
    function blog_postx_single_excerpt() {

    }
endif;

if( ! function_exists( 'blog_postx_single_comments' ) ) :
    /**
     * Related Posts
     */
    function blog_postx_single_comments( $comments_option ) {
        if( $comments_option ) :
            $comments_num = '<span class="comments-context">' .get_comments_number( get_the_ID() ). '</span>';
            $global_comments_icon_picker = $global_comments_icon_picker = [
                'type'  => 'icon',
                'value' => 'fa-solid fa-comment'
            ];
            if( $global_comments_icon_picker ) {
                $icon_html = blog_postx_get_icon_control_html($global_comments_icon_picker);
                if( $icon_html ) $comments_num = $icon_html . $comments_num ;
            }
            echo '<a class="post-comments-num" href="'. esc_url(get_the_permalink()) .'#commentform">' .$comments_num. '</a>';
        endif;
    }
endif;

if( ! function_exists( 'blog_postx_single_read_time' ) ) :
    /**
     * Read Time
     */
    function blog_postx_single_read_time( $read_time_option ) {
        if( $read_time_option ) :
            $read_time_option = metadata_exists( 'post', get_the_ID(), 'read_time_option' ) ? get_post_meta( get_the_ID(), 'read_time_option', true ) : 'customizer';
            $read_time_meta = metadata_exists( 'post', get_the_ID(), 'read_time' ) ? get_post_meta( get_the_ID(), 'read_time', true ) : '1 Mins';
            $read_time = '<span class="time-context">' .( ( $read_time_option == 'customizer' ) ? blog_postx_post_read_time( get_the_content() ) : $read_time_meta ) . '</span>';
            $global_read_time_icon_picker = [
                'type'  => 'icon',
                'value' => 'fa-solid fa-book-open-reader'
            ];
            if( $global_read_time_icon_picker ) {
                $icon_html = blog_postx_get_icon_control_html($global_read_time_icon_picker);
                if( $icon_html ) $read_time = $icon_html . $read_time;
            }
            echo '<span class="post-read-time">' .$read_time. '</span>';
        endif;
    }
endif;

if( ! function_exists( 'blog_postx_single_post_navigation' ) ) :
    /**
     * Table of content
     */
    function blog_postx_single_post_navigation() {
        $previous = get_previous_post();
        $next = get_next_post();
        $prev_post_date = $prev_post_thumbnail = $prev_post_navigation_sub_title = '';
        $next_post_date = $next_post_thumbnail = $next_post_navigation_sub_title = '';
        
        // date
        $prev_post_date = ! empty( $previous ) ? '<span class="nav-post-date">' . blog_postx_posted_on( $previous->ID, [ 'return' => true ] ) . '</span>' : '';
        $next_post_date = ! empty( $next ) ? '<span class="nav-post-date">' . blog_postx_posted_on( $next->ID, [ 'return' => true ] ) . '</span>' : '';

        // thumbnail
        $prev_post_thumbnail = ( ! empty( $previous ) ) ? get_the_post_thumbnail_url( $previous->ID ) : '';
        $next_post_thumbnail = ( ! empty( $next ) ) ? get_the_post_thumbnail_url( $next->ID  ) : '';

        // sub-title
        $prev_post_navigation_sub_title = '<span class="nav-subtitle"><i class="fa-solid fa-arrow-left"></i></span>';
        $next_post_navigation_sub_title = '<span class="nav-subtitle"><i class="fa-solid fa-arrow-right"></i></span>';

        // title
        $post_navigation_title = '<span class="nav-title">%title</span>';
        
        the_post_navigation(
            [
                'prev_text' => '<div class="button-thumbnail">'. $prev_post_navigation_sub_title .'<figure class="nav-thumb" style="background-image:url('. $prev_post_thumbnail .')"></figure></div><div class="nav-post-elements">'. $prev_post_date . '<div class="nav-title-wrap">' . $post_navigation_title. '</div></div>',
                'next_text' => '<div class="nav-post-elements">'. $next_post_date . '<div class="nav-title-wrap">' . $post_navigation_title .'</div></div><div class="button-thumbnail"><figure class="nav-thumb" style="background-image:url('. $next_post_thumbnail .')"></figure>'. $next_post_navigation_sub_title .'</div>'
            ]
        );
    }
endif;

if( ! function_exists( 'blog_postx_single_author_box' ) ) :
    /**
     * Author Box
     */
    function blog_postx_single_author_box() {
        ?>
            <div class="post-card author-wrap">
                <div class="bmm-author-thumb-wrap">
                    <?php
                        echo '<figure class="post-thumb">', get_avatar( get_the_author_meta( 'ID' ) ), '</figure>';

                        echo '<div class="author-elements">';

                            echo '<h2 class="author-name"><a href="', esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), '">', get_the_author(), '</a></h2>';

                            if( ! empty( get_the_author_meta( 'description' ) ) ) echo '<div class="author-desc">', get_the_author_meta( 'description' ), '</div>';

                        echo '</div>';
                    ?>
                </div>
            </div>
        <?php 
    }
endif;

if( ! function_exists( 'blog_postx_get_layout_three_part' ) ) :
    /**
     * Renders contents of single post only for layout three 
     * 
     * @since 1.0.0
     */
    function blog_postx_get_layout_three_part() {
        if( ! is_single() ) return;
        $single_image_size = BPX\blog_postx_get_customizer_option( 'single_image_size' );
        $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        if( ( in_array( $single_post_layout, [ 'layout-three' ] ) && $single_layout_post_meta == 'customizer-layout' ) || in_array( $single_layout_post_meta, [ 'layout-three' ] ) ) :
            echo '<div class="blog-postx-container-fluid">';
                blog_postx_post_thumbnail( $single_image_size );
                
                $single_custom_class = '';
                if( ! has_post_thumbnail() ) $single_custom_class = ' no-single-featured-image';
                ?>
                    <header class="entry-header<?php echo esc_attr($single_custom_class); ?>" >
                        <?php get_template_part( 'template-parts/single/partial', 'meta' ); ?>
                    </header><!-- .entry-header -->
                <?php
                blog_postx_breadcrumb_html();
            echo '</div>';
        endif;
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_layout_three_part', 30 );
endif;

if( ! function_exists( 'blog_postx_get_layout_six_part' ) ) :
    /**
     * Renders contents of single post only for layout three 
     * 
     * @since 1.0.0
     */
    function blog_postx_get_layout_six_part() {
        if( ! is_single() ) return;
        $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        if( ( in_array( $single_post_layout, [ 'layout-six' ] ) && $single_layout_post_meta == 'customizer-layout' ) || in_array( $single_layout_post_meta, [ 'layout-six' ] ) ) :
            $single_custom_class = 'entry-header';
            ?>
                <div class="blog-postx-container">
                    <div class="row">
                        <?php blog_postx_breadcrumb_html(); ?>
                        <header class="<?php echo esc_attr( $single_custom_class ); ?>" >
                            <?php get_template_part( 'template-parts/single/partial', 'meta' ); ?>
                        </header><!-- .entry-header -->
                    </div>
                </div>
            <?php
        endif;
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_layout_six_part', 30 );
endif;

if( ! function_exists( 'blog_postx_single_header_html' ) ) :
    /**
     * Theme single post header html
     *
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_single_header_html() {
        /* For single layout 2, 4 */
        $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
        $single_image_size = BPX\blog_postx_get_customizer_option( 'single_image_size' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        $is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
        $is_seven = ( ( $single_post_layout === 'layout-seven' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-seven' ) );
        if( ( in_array( $single_post_layout, [ 'layout-one', 'layout-three', 'layout-six', 'layout-five' ] ) && $single_layout_post_meta == 'customizer-layout' ) || in_array( $single_layout_post_meta, [ 'layout-one', 'layout-three', 'layout-six', 'layout-five' ] ) ) return;
        if ( ! is_single() ) return;
        if( $single_layout_post_meta == 'layout-three' ) return;
        $single_thumbnail_option = true;
        $headerClass = 'entry-header';
        if( ! $single_thumbnail_option ) $headerClass .= ' no-single-featured-image';
        ?>
            <div class="row blog-postx-single-header">
                <header class="<?php echo esc_attr( $headerClass ); ?>" >
                    <?php 
                        if( $single_thumbnail_option ) :
                            echo '<div class="post-thumb-wrap">';

                                blog_postx_post_thumbnail( $single_image_size );

                                if( $is_seven ) echo get_template_part( 'template-parts/single/partial', 'meta' );
                            echo '</div>';
                        endif;

                        if( ! $is_seven ) echo get_template_part( 'template-parts/single/partial', 'meta' );
                    ?>
                </header><!-- .entry-header -->
            </div><!-- .row -->
        <?php
    }
    add_action( 'blog_postx_before_main_content', 'blog_postx_single_header_html', 20 );
endif;

if( ! function_exists( 'blog_postx_single_related_posts' ) ) :
    /**
     * Single related posts
     * 
     * @package Blog Postx Pro
     */
    function blog_postx_single_related_posts() {
        if( get_post_type() != 'post' ) return;
        $single_post_related_posts_option = BPX\blog_postx_get_customizer_option( 'single_post_related_posts_option' );
        if( ! $single_post_related_posts_option ) return;
        $related_posts_title = BPX\blog_postx_get_customizer_option( 'single_post_related_posts_title' );
        $related_posts_args = array(
            'posts_per_page'   => 4,
            'post__not_in'  => array( get_the_ID() ),
            'ignore_sticky_posts'    => true,
            'fields'    =>  'ids',
            'no_found_rows' =>  true
        );
        $post_categories = wp_get_post_categories( get_the_ID() );
        $related_posts_args['category__in'] = $post_categories;
        $related_posts = new WP_Query( apply_filters( 'blog_postx_query_args_filter', $related_posts_args ) );
        if( ! $related_posts->have_posts() ) return;
        $elementClass = 'single-related-posts-section-wrap layout--list layout--one column--three';
        $meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'single_meta_reorder' ) );
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <div class="single-related-posts-section">
                    <?php
                        if( $related_posts_title ) echo '<h2 class="blog-postx-block-title"><span class="divider"></span><span>' .esc_html( $related_posts_title ). '</span></h2>';
                        echo '<div class="single-related-posts-wrap">';
                            while( $related_posts->have_posts() ) : $related_posts->the_post(); ?>
                                <article post-id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                    <figure class="post-thumb-wrap <?php if(!has_post_thumbnail()){ echo esc_attr('no-feat-img');} ?>">
                                        <?php blog_postx_post_thumbnail( 'medium' ); ?>
                                        <div class="post-element">
                                            <h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                            <div class="post-meta">
                                                <?php
                                                    if( $meta_reorder ) :
                                                        foreach( $meta_reorder as $meta => $option ) :
                                                            switch( $meta ) :
                                                                case 'author' :
                                                                        if( $option ) blog_postx_posted_by();
                                                                    break;
                                                                case 'date' :
                                                                        if( $option ) blog_postx_posted_on();
                                                                    break;
                                                                case 'comments' :
                                                                        blog_postx_single_comments( $option );
                                                                    break;
                                                            endswitch;
                                                        endforeach;
                                                    endif;
                                                ?>
                                            </div>
                                        </div>
                                    </figure>
                                </article>
                            <?php endwhile;
                            wp_reset_postdata();
                        echo '</div>';
                    ?>
                </div>
            </div>
        <?php
    }
    add_action( 'blog_postx_single_post_append_hook', 'blog_postx_single_related_posts' );
endif;