<?php
/**
 * Theme hooks and functions
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

if( ! function_exists( 'blog_postx_archive_header_html' ) ) :
    /**
     * Archive info box hook
     * 
     * @since 1.0.0
     */
    function blog_postx_archive_header_html() {
        if( ! is_archive() ) return;
        if( is_category() && ! BPX\blog_postx_get_customizer_option( 'archive_category_info_box_option' ) ) return;
        if( is_tag() && ! BPX\blog_postx_get_customizer_option( 'archive_tag_info_box_option' ) ) return;
        if( is_author() && ! BPX\blog_postx_get_customizer_option( 'archive_author_info_box_option' ) ) return;
        echo '<header class="page-header">';
            echo '<div class="blog-postx-container">';
                echo '<div class="row">';
                    blog_postx_breadcrumb_html();
                    echo '<div class="archive-header">';
                        $object_id = get_queried_object_id();
                        if( is_category() ) {
                            $cat_args = get_category( $object_id );
                            $archive_category_info_box_icon = [ 'value' => 'fas fa-layer-group', 'type' => 'icon' ];
                            $icon_html = blog_postx_get_icon_control_html( $archive_category_info_box_icon );
                            echo '<div class="archive-title">';
                                echo '<div class="title-wrapper">';
                                    if( $icon_html ) echo $icon_html;
                                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                                echo '</div>';
                                echo '<span class="archive-count">', esc_html( $cat_args->count . ' posts' ) ,'</span>';
                            echo '</div>';
                            the_archive_description( '<div class="archive-description">', '</div>' );
                        } else if( is_tag() ) {
                            $tag_args = get_tag( $object_id );
                            $archive_tag_info_box_icon = [ 'value' => 'fas fa-tag', 'type' => 'icon' ];
                            $icon_html = blog_postx_get_icon_control_html($archive_tag_info_box_icon);
                            echo '<div class="archive-title">';
                                echo '<div class="title-wrapper">';
                                    if( $icon_html ) echo $icon_html;
                                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                                echo '</div>';
                                echo '<span class="archive-count">', esc_html( $tag_args->count . ' posts' ) ,'</span>';
                            echo '</div>';
                            the_archive_description( '<div class="archive-description">', '</div>' );
                        } else if( is_author() ) {
                            echo '<div class="archive-title">';
                                echo '<div class="title-wrapper">';
                                    $author_image = get_avatar( $object_id, 90 );
                                    if( $author_image ) echo $author_image;
                                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                                echo '</div>';
                                echo '<span class="archive-count">', esc_html( count_user_posts( $object_id ) . ' posts' ) ,'</span>';
                            echo '</div>';
                            the_archive_description( '<div class="archive-description">', '</div>' );
                        } else {
                            the_archive_title( '<h1 class="page-title">', '</h1>' );
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</header><!-- .page-header -->';
    }
    add_action( 'blog_postx_page_header_hook', 'blog_postx_archive_header_html' );
endif;

if( ! function_exists( 'blog_postx_shooting_star_animation_html' ) ) :
    /**
     * Background animation one
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_shooting_star_animation_html() {
        if( BPX\blog_postx_get_customizer_option( 'site_background_animation' ) === 'none' ) return;
        $show_background_animation_on_mobile = BPX\blog_postx_get_customizer_option( 'show_background_animation_on_mobile' ); 
        $elementClass = 'blog-postx-background-animation';
        if( ! $show_background_animation_on_mobile ) $elementClass .= ' hide-on-mobile';
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <?php
                    $data = array_map( fn( $num ) => '<span class="item"></span>', range( 0, 12 ));
                    echo implode( '', $data );
                ?>
            </div>
        <?php
    }
endif;

if( ! function_exists( 'blog_postx_get_opening_div_main_wrap' ) ) :
    /**
     * Renders the opening div to wrap main content
     */
    function blog_postx_get_opening_div_main_wrap() {
        echo '<div id="blog-postx-main-wrap" class="blog-postx-main-wrap">';
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_opening_div_main_wrap', 10 );
endif;

if( ! function_exists( 'blog_postx_get_page_header_hook' ) ) :
    function blog_postx_get_page_header_hook() {
        /**
         * Hook - blog_postx_page_header_hook
         * 
         * Hooked - blog_postx_archive_header_html - 10
         */
        do_action( 'blog_postx_page_header_hook' );
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_page_header_hook', 20 );
endif;

if( ! function_exists( 'blog_postx_get_opening_div_container' ) ) :
    /**
     * Renders the opening div for .blog-postx-container class
     * 
     * @since 1.0.0
     */
    function blog_postx_get_opening_div_container() {
        echo '<div class="blog-postx-container">';
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_opening_div_container', 40 );
endif;

if( ! function_exists( 'blog_postx_get_single_content_exclude_layout_three' ) ) :
    /**
     * Renders contents of single post excluding layout three
     * 
     * @since 1.0.0
     */
    function blog_postx_get_single_content_exclude_layout_three() {
        /**
         * hook - blog_postx_before_main_content
         * 
         * hooked - blog_postx_breadcrumb_html - 10
         * hooked - blog_postx_single_header_html - 20
         */
        $single_post_layout = BPX\blog_postx_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        $is_customizer_layout = ( $single_layout_post_meta == 'customizer-layout' );
        $is_seven = ( ( $single_post_layout === 'layout-seven' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $single_layout_post_meta === 'layout-seven' ) );

        if( ! $is_seven ) {
            if( $single_layout_post_meta !== 'customizer-layout' && is_single() ) {
                if( ! in_array( $single_layout_post_meta, [ 'layout-three', 'layout-six' ] ) ) do_action( 'blog_postx_before_main_content' );
            } else {
                if( ! in_array( $single_post_layout, [ 'layout-three', 'layout-six' ] ) && is_single() ) do_action( 'blog_postx_before_main_content' );
            }
        }
        if( ! is_single() && ! is_archive() ) do_action( 'blog_postx_before_main_content' );
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_single_content_exclude_layout_three', 50 );
endif;

if( ! function_exists( 'blog_postx_get_opening_div_row' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blog_postx_get_opening_div_row() {
        echo '<div class="row">';
    }
    add_action( 'blog_postx_main_content_opening', 'blog_postx_get_opening_div_row', 60 );
endif;

if( ! function_exists( 'blog_postx_get_closing_div_row' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blog_postx_get_closing_div_row() {
        echo '</div><!-- .row -->';
    }
    add_action( 'blog_postx_main_content_closing', 'blog_postx_get_closing_div_row', 10 );
endif;

if( ! function_exists( 'blog_postx_get_closing_div_container' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blog_postx_get_closing_div_container() {
        echo '</div><!-- .row -->';
    }
    add_action( 'blog_postx_main_content_closing', 'blog_postx_get_closing_div_container', 20 );
endif;

if( ! function_exists( 'blog_postx_get_closing_div_main_wrap' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blog_postx_get_closing_div_main_wrap() {
        echo '</div><!-- .blog-postx-main-wrap -->';
    }
    add_action( 'blog_postx_main_content_closing', 'blog_postx_get_closing_div_main_wrap', 30);
endif;

