<?php
/**
 * Header hooks and functions
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

if( ! function_exists( 'blog_postx_header_site_branding_part' ) ) :
    /**
     * Header site branding element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_site_branding_part() {
        ?>
            <div class="site-branding">
                <?php
                    $site_title_tag_for_frontpage = BPX\blog_postx_get_customizer_option( 'site_title_tag_for_frontpage' );
                    $site_title_tag_for_innerpage = BPX\blog_postx_get_customizer_option( 'site_title_tag_for_innerpage' );
                    $site_description_show_hide = BPX\blog_postx_get_customizer_option( 'blogdescription_option' );

                    the_custom_logo();

                    if ( is_front_page() ) :
                        echo '<'. esc_html( $site_title_tag_for_frontpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_frontpage ) .'>';
                    else :
                        echo '<'. esc_html( $site_title_tag_for_innerpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_innerpage ) .'>';
                    endif;
                    $blog_postx_description = get_bloginfo( 'description', 'display' );
                    if( $site_description_show_hide ) :
                        if ( $blog_postx_description ) echo '<p class="site-description">'. $blog_postx_description .'</p>';
                    endif;
                ?>
            </div><!-- .site-branding -->
        <?php
    }
    add_action( 'blog_postx_header__site_branding_section_hook', 'blog_postx_header_site_branding_part', 10 );
endif;

if( ! function_exists( 'blog_postx_header_menu_part' ) ) :
    /**
     * Header menu element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_menu_part() {
        $nav_classes = 'hover-effect--' . BPX\blog_postx_get_customizer_option( 'header_menu_hover_effect' );
      ?>
        <div class="site-navigation-wrapper primary-menu">
            <nav id="site-navigation" class="main-navigation <?php echo esc_attr( $nav_classes ); ?>">
                <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                    <div id="blog-postx-menu-burger">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                    <span class="menu-txt"><?php esc_html_e( 'Menu', 'blog-postx' ); ?></span>
                </button>
                <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'menu-1',
                            'menu_class' =>    'blog-postx-primary-menu-container menu'
                        )
                    );
                ?>
            </nav><!-- #site-navigation -->
        </div>
      <?php
    }
    add_action( 'blog_postx_header__menu_section_hook', 'blog_postx_header_menu_part', 10 );
 endif;

if( ! function_exists( 'blog_postx_header_secondary_menu' ) ) :
    /**
     * Header menu element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_secondary_menu() {
        $nav_classes = 'hover-effect--' . BPX\blog_postx_get_customizer_option( 'header_secondary_menu_hover_effect' );
      ?>
        <div class="site-navigation-wrapper secondary-menu">
            <nav id="site-navigation-secondary" class="main-navigation <?php echo esc_attr( $nav_classes ); ?>">
                <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'menu-2',
                            'container_class' =>    'blog-postx-secondary-menu-container'
                        )
                    );
                ?>
            </nav><!-- #site-navigation -->
        </div>
      <?php
    }
    add_action( 'blog_postx_header__secondary_menu_section_hook', 'blog_postx_header_secondary_menu', 10 );
 endif;

 if( ! function_exists( 'blog_postx_header_custom_button_part' ) ) :
    /**
     * Header custom button element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_custom_button_part() {
        $custom_button_redirect_link = BPX\blog_postx_get_customizer_option( 'custom_button_redirect_href_link' );
        $custom_button_label = BPX\blog_postx_get_customizer_option( 'custom_button_label' );
        $custom_button_animation_type = BPX\blog_postx_get_customizer_option( 'custom_button_animation_type' );
        
        $elementClass = 'header-custom-button blog-postx-button';
        $elementClass .= ' animation-type--'. $custom_button_animation_type;
        ?>
            <div class="header-custom-button-wrapper">
                <a class="<?php echo esc_attr( $elementClass ); ?>" href="<?php echo esc_url( $custom_button_redirect_link ); ?>" target="_self">
                    <span class="custom-button-icon"><i class="fas fa-bell"></i></span>
                    <?php if( $custom_button_label ) echo '<span class="custom-button-label">', esc_html( $custom_button_label ), '</span>'; ?>
                </a>
            </div>
        <?php
    }
    add_action( 'blog_postx_header__custom_button_section_hook', 'blog_postx_header_custom_button_part', 10 );
 endif;

 if( ! function_exists( 'blog_postx_header_search_part' ) ) :
    /**
     * Header live search element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_search_part() {
        $classes = 'search-wrap search-type--default';
        ?>
            <div class="<?php echo esc_attr( $classes ); ?>">
                <button class="search-trigger"><i class="fas fa-search"></i></button>
                <div class="search-form-wrap">
                    <div class="form-wrapper">
                        <?php echo get_search_form(); ?>
                        <button class="search-form-close"><i class="fas fa-times"></i></button>
                    </div>
                </div>
            </div>
        <?php
    }
    add_action( 'blog_postx_header_search_hook', 'blog_postx_header_search_part', 10 );
 endif;

 if( ! function_exists( 'blog_postx_header_theme_mode_part' ) ) :
    /**
     * Header theme mode element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_theme_mode_part() {
        $light_mode_icon_args = BPX\blog_postx_get_customizer_option( 'theme_mode_light_icon' );
        $dark_mode_icon_args = BPX\blog_postx_get_customizer_option( 'theme_mode_dark_icon' );
        $light_mode_icon_class = ( array_key_exists( 'value', $light_mode_icon_args ) && is_array( $light_mode_icon_args ) ) ? $light_mode_icon_args['value'] : '';
        $dark_mode_icon_class = ( array_key_exists( 'value', $dark_mode_icon_args ) && is_array( $dark_mode_icon_args ) ) ? $dark_mode_icon_args['value'] : '';
        ?>
            <div class="mode-toggle-wrap">
                <span class="mode-toggle">
                    <?php 
                        blog_postx_theme_mode_switch( $light_mode_icon_args, 'light' );
                        blog_postx_theme_mode_switch( $dark_mode_icon_args, 'dark' );
                    ?>
                </span>
            </div>
        <?php
    }
    add_action( 'blog_postx_header_theme_mode_hook', 'blog_postx_header_theme_mode_part', 10 );
 endif;

 if( ! function_exists( 'blog_postx_header_canvas_menu_part' ) ) :
    /**
     * Header canvas menu element
     * 
     * @since 1.0.0
     */
    function blog_postx_header_canvas_menu_part() {
        $elementClass = 'blog-postx-canvas-menu';
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <button class="canvas-menu-icon">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <div class="canvas-menu-sidebar">
                    <div class="canvas-menu-inner">
                        <?php if( is_active_sidebar( 'canvas-menu-sidebar' ) ) dynamic_sidebar( 'canvas-menu-sidebar' ); ?>
                    </div>
                </div>
            </div>
        <?php
    }
    add_action( 'blog_postx_header_off_canvas_hook', 'blog_postx_header_canvas_menu_part', 10 );
 endif;

 if( ! function_exists( 'blog_postx_before_content_advertisement_part' ) ) :
    /**
     * Blog Postx main banner element
     * 
     * @since 1.0.0
     */
    function blog_postx_before_content_advertisement_part() {
        $advertisement_repeater = BPX\blog_postx_get_customizer_option( 'advertisement_repeater' );
        $advertisement_repeater_decoded = json_decode( $advertisement_repeater );
        $before_content_advertisement = array_values(array_filter( $advertisement_repeater_decoded, function( $element ) {
            if( property_exists( $element, 'item_checkbox_before_post_content' ) ) return ( $element->item_checkbox_before_post_content == true && $element->item_option == 'show' ) ? $element : ''; 
        }));
        if( empty( $before_content_advertisement ) ) return;
        $image_option = array_column( $before_content_advertisement, 'item_image_option' );
        $alignment = array_column( $before_content_advertisement, 'item_alignment' );
        $elementClass = 'alignment--' . $alignment[0];
        $elementClass .= ' image-option--' . ( ( $image_option[0] == 'full_width' ) ? 'full-width' : 'original' );
        ?>
            <section class="blog-postx-advertisement-section-before-content blog-postx-advertisement <?php echo esc_html( $elementClass ); ?>">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="advertisement-wrap">
                            <?php
                                if( ! empty( $advertisement_repeater_decoded ) ) :
                                    foreach( $before_content_advertisement as $field ) :
                                        ?>
                                        <div class="advertisement">
                                            <a href="<?php echo esc_url( $field->item_url ); ?>" target="<?php echo esc_attr( $field->item_target ); ?>" rel="<?php echo esc_attr( $field->item_rel_attribute ); ?>">
                                                <img src="<?php echo esc_url( wp_get_attachment_image_url( $field->item_image, 'full' ) ); ?>" loading="lazy">
                                            </a>
                                        </div>
                                        <?php
                                    endforeach;
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_before_single_content_hook', 'blog_postx_before_content_advertisement_part' );
 endif;

 if( ! function_exists( 'blog_postx_after_content_advertisement_part' ) ) :
    /**
     * Blog Postx main banner element
     * 
     * @since 1.0.0
     */
    function blog_postx_after_content_advertisement_part() {
        $advertisement_repeater = BPX\blog_postx_get_customizer_option( 'advertisement_repeater' );
        $advertisement_repeater_decoded = json_decode( $advertisement_repeater );
        $after_content_advertisement = array_values(array_filter( $advertisement_repeater_decoded, function( $element ) {
            if( property_exists( $element, 'item_checkbox_after_post_content' ) ) return ( $element->item_checkbox_after_post_content == true && $element->item_option == 'show' ) ? $element : ''; 
        }));
        if( empty( $after_content_advertisement ) ) return;
        $image_option = array_column( $after_content_advertisement, 'item_image_option' );
        $alignment = array_column( $after_content_advertisement, 'item_alignment' );
        $elementClass = 'alignment--' . $alignment[0];
        $elementClass .= ' image-option--' . ( ( $image_option[0] == 'full_width' ) ? 'full-width' : 'original' );
        ?>
            <section class="blog-postx-advertisement-section-after-content blog-postx-advertisement <?php echo esc_html( $elementClass ); ?>">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="advertisement-wrap">
                            <?php
                                if( ! empty( $advertisement_repeater_decoded ) ) :
                                    foreach( $after_content_advertisement as $field ) :
                                        ?>
                                        <div class="advertisement">
                                            <a href="<?php echo esc_url( $field->item_url ); ?>" target="<?php echo esc_attr( $field->item_target ); ?>" rel="<?php echo esc_attr( $field->item_rel_attribute ); ?>">
                                                <img src="<?php echo esc_url( wp_get_attachment_image_url( $field->item_image, 'full' ) ); ?>" loading="lazy">
                                            </a>
                                        </div>
                                        <?php
                                    endforeach;
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_after_single_content_hook', 'blog_postx_after_content_advertisement_part' );
 endif;

 if( ! function_exists( 'blog_postx_get_background_and_cursor_animation' ) ) :
    /**
     * Renders html for cursor and background animation
     * 
     * @since 1.0.0
     */
    function blog_postx_get_background_and_cursor_animation() {
        $site_background_animation = BPX\blog_postx_get_customizer_option( 'site_background_animation' );
        if( $site_background_animation ) blog_postx_shooting_star_animation_html();
        $cursor_animation = BPX\blog_postx_get_customizer_option( 'cursor_animation' );
        $cursorclass = 'blog-postx-cursor';
        if( $cursor_animation != 'none' ) $cursorclass .= ' type--' . $cursor_animation;
        if( in_array( $cursor_animation, [ 'one', 'two' ] ) ) echo '<div class="'. esc_attr( $cursorclass ) .'"></div>';
    }
    add_action( 'blog_postx_animation_hook', 'blog_postx_get_background_and_cursor_animation' );
 endif;

 if( ! function_exists( 'blog_postx_get_toggle_button_html' ) ) :
    /**
     * Toggle Button Widget html
     * 
     * @since 1.0.0
     */
    function blog_postx_get_toggle_button_html() {
        ?>
            <div class="toggle-button-wrapper">
                <button class="canvas-menu-icon">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
            </div>
        <?php
    }
  endif;

  if( ! function_exists( 'blog_postx_customizer_social_icons' ) ) :
	/**
	 * Function to get social icons from customizer
	 * 
	 * @since 1.0.0
	 * @package Blog Postx Pro
	 */
	function blog_postx_customizer_social_icons( $type = '', $limit = '', $inherit = false ) {
        $placement = ( $type !== '' ) ? $type . '_' : '';
		$social_icons = BPX\blog_postx_get_customizer_option( $placement . 'social_icons' );
		$decoded_social_icons = json_decode( $social_icons, true );

        if( $type === 'footer' ) :
            $display_label = BPX\blog_postx_get_customizer_option( 'footer_social_icons_display_label' );
            $columns = BPX\blog_postx_get_customizer_option( 'footer_social_icons_columns' );
            $display_count = BPX\blog_postx_get_customizer_option( 'footer_social_icons_display_count' );
        else :
            $display_label = $display_count = false;
            $columns = 2;
        endif;

        $socialIconClasses[] = 'blog-postx-social-icon official-color--enabled';
        $socialIconClasses[] = 'column--' . blog_postx_convert_number_to_numeric_string( $columns );
		if( $display_label ) $socialIconClasses[] = 'is-title';

        echo '<div class="', implode( ' ', $socialIconClasses ), '">';
			foreach( $decoded_social_icons as $index => $icon ) :
				if( $limit !== '' && $index >= $limit ) break;
				if( $icon[ 'item_option' ] === 'show' ) :
					$label = blog_postx_get_brand_name( $icon[ 'icon_class' ] );
					$iconClass = 'social-icon ' . strtolower( $label );
					?>
						<a class="<?php echo esc_attr( $iconClass ); ?>" href="<?php echo esc_url( $icon[ 'icon_url' ] ); ?>" target="_blank">
							<i class="<?php echo esc_attr( $icon[ 'icon_class' ] ); ?>"></i>
							<?php if( $display_label && $label ) echo '<span class="icon-label">', esc_html( $label ), '</span>'; ?>
							<?php if( $display_count ) echo '<span class="icon-count">', esc_html( $icon[ 'icon_count' ] ), '</span>'; ?>
						</a>
					<?php
				endif;
			endforeach;
		echo '</div>';
	}
endif;