<?php
/**
 * Frontpage section hooks and function for the theme
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;
 
 if( ! function_exists( 'blog_postx_article_masonry' ) ) :
    /**
     * Masonry articles element
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_article_masonry() {
        $query_args = [
            'post_type' =>  'post',
            'post_status'   =>  'publish'
        ];
        $post_query = new \WP_Query( apply_filters( 'blog_postx_query_args_filter', $query_args ) );
        if( $post_query->have_posts() ) :
            while( $post_query->have_posts() ) :
                $post_query->the_post();
            endwhile;
        endif;
    }
    add_action( 'blog_postx_masonry_articles_hook', 'blog_postx_article_masonry' );
 endif;


 if( ! function_exists( 'blog_postx_ticker_html' ) ) :
    /**
     * Ticker News
     * 
     * @package Blog Postx Pro
     * @since 1.0.0
     */
    function blog_postx_ticker_html() {
        if( ! BPX\blog_postx_get_customizer_option( 'ticker_news_option' ) || is_paged() || ! is_home() || ! is_front_page() ) return;
        // post query variables
        $ticker_args = blog_postx_get_query_args( 'ticker_news' );
        ?>
            <div class="blog-postx-ticker-news">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="ticker-title-wrapper">
                            <span class="ticker-icon"></span>
                            <h2 class="ticker-title"><?php esc_html_e( 'Headlines', 'blog-postx' ); ?></h2>
                        </div>
                        <div class="ticker-news-wrap">
                            <ul class="ticker-item-wrap">
                                <?php
                                    $ticker_query = new WP_Query( $ticker_args );
                                    if( $ticker_query->have_posts() ) :
                                        while( $ticker_query->have_posts() ) : 
                                            $ticker_query->the_post();
                                            $figureClass = 'post-thumb';
                                            if( ! has_post_thumbnail() ) $figureClass .= ' no-feat-image';
                                            ?>
                                                <li class="ticker-item">
                                                    <figure class="<?php echo esc_attr( $figureClass ); ?>">
                                                        <?php
                                                            if( has_post_thumbnail() ) : ?>
                                                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                                                    <?php
                                                                        the_post_thumbnail( 'post-thumbnail', [
                                                                            'title' => the_title_attribute([
                                                                                'echo'  => false
                                                                            ]),
                                                                            'loading'   => 'lazy'
                                                                        ]);
                                                                    ?>
                                                                </a>
                                                        <?php 
                                                            endif;
                                                        ?>
                                                    </figure>
                                                    <div class="title-wrap">
                                                        <h2 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                                                        <?php blog_postx_posted_on( get_the_ID() ); ?>
                                                    </div>
                                                </li>
                                            <?php
                                        endwhile;
                                        wp_reset_postdata();
                                    endif;
                                ?>
                            </ul>
                        </div>
                        <div class="controller-wrapper playing">
                            <button class="controller-icon">
                                <i class="fa-solid fa-pause"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
    add_action( 'blog_postx_ticker_news_hook', 'blog_postx_ticker_html' );
endif;

if( ! function_exists( 'blog_postx_main_banner_html' ) ) :
    /**
     * Main banner html
     * 
     * @since 1.0.0
     */
    function blog_postx_main_banner_html() {
        if( ! BPX\blog_postx_get_customizer_option( 'main_banner_option' ) || is_paged() || ! is_home() || ! is_front_page() ) return;

        // post elements
        $show_title = $show_categories = $show_date = $show_author = true;
        // image settings and slider settings
        $main_banner_layouts = 'five';
        $main_banner_image_sizes = BPX\blog_postx_get_customizer_option( 'main_banner_image_sizes' );
        $main_banner_aligment = BPX\blog_postx_get_customizer_option( 'main_banner_post_elements_alignment' );
        
        $banner_class = 'blog-postx-main-banner-section layout--' . $main_banner_layouts . ' banner-align--' . $main_banner_aligment;
        $banner_class .= ' arrow-on-hover--on main-banner-arrow-show';

        $main_banner_excerpt_on_mobile = BPX\blog_postx_get_customizer_option( 'show_main_banner_excerpt_mobile_option' );
        $hide_on_mobile = ( ! $main_banner_excerpt_on_mobile ) ? ' hide-on-mobile' : '';

        // Query
        $thumbnails = [];
        $post_query_args = blog_postx_get_query_args( 'main_banner' );
        $post_query = new \WP_Query( apply_filters( 'blog_postx_query_args_filter', $post_query_args ) ); 
        if( ! $post_query->have_posts() ) return;

        if( in_array( $main_banner_layouts, [ 'three', 'four', 'five' ] ) ) :
            $trailing_post_query_args = blog_postx_get_query_args( 'main_banner_trailing' );
            $trailing_post_query = new \WP_Query( apply_filters( 'blog_postx_query_args_filter', $trailing_post_query_args ) ); 
        endif;
        ?>
            <section class="<?php echo esc_attr( $banner_class )?>" id="blog-postx-main-banner-section">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="main-banner-slider">
                            <div class="main-banner-wrap">
                                <?php
                                    while( $post_query->have_posts() ) :
                                        $post_query->the_post();
                                        $thumbnails[] = get_the_post_thumbnail_url();
                                        ?>
                                            <article class="post-item">
                                                <?php if( $main_banner_layouts !== 'three' ) : ?>
                                                    <figure class="post-thumb">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php if( has_post_thumbnail() ) the_post_thumbnail( $main_banner_image_sizes, [ 'loading'   => 'lazy' ] ); ?>
                                                        </a>
                                                    </figure>
                                                <?php endif; ?>
                                                <div class="post-elements">
                                                    <?php 
                                                        if( $show_categories ) blog_postx_get_post_categories( get_the_ID(), 2 );
                                                        if( $show_title ) the_title( '<h2 class="post-title"><a href="'. esc_url( get_the_permalink() ) .'">', '</a></h2>' );
                                                        echo '<div class="author-date-wrap">';
                                                            if( $show_author ) blog_postx_posted_by( 'banner' );
                                                            if( $show_date ) blog_postx_posted_on( get_the_ID() );
                                                        echo '</div>';
                                                    ?>
                                                </div>
                                            </article>
                                        <?php
                                    endwhile;
                                    wp_reset_postdata();
                                ?>
                            </div>

                        </div><!-- .main-banner-slider -->
                        <?php if( in_array( $main_banner_layouts, [ 'three', 'four', 'five' ] ) ) : ?>
                            <?php $show_trailing_post_title = $main_banner_trailing_post_elements_show_date = $show_trailing_post_categories = true; ?>
                            <div class="main-banner-sidebar">
                                <div class="scrollable-posts-wrapper">
                                    <?php
                                        if( $trailing_post_query->have_posts() ) :
                                            $total_posts = $trailing_post_query->post_count;
                                            $count = 1;
                                            while( $trailing_post_query->have_posts() ) :
                                                $trailing_post_query->the_post();
                                                if( $main_banner_layouts === 'five' && $count === 1 ) echo '<div class="grid-wrap">';
                                                if( $main_banner_layouts === 'five' && $count === 3 ) echo '<div class="list-wrap">';
                                                ?>
                                                    <div class="scrollable-post">
                                                        <div class="count-image-wrapper">
                                                            <figure class="post-thumb">
                                                                <?php if( has_post_thumbnail() ) : ?>
                                                                    <a href="<?php the_permalink(); ?>">
                                                                        <?php the_post_thumbnail( 'medium', [ 'loading'   => 'lazy' ] ); ?>
                                                                    </a>
                                                                <?php endif; ?>
                                                            </figure>
                                                        </div>
                                                        <div class="title-date-wrapper">
                                                            <?php
                                                                if( $show_trailing_post_title ) the_title( '<h2 class="post-title"><a href="'. esc_url( get_the_permalink() ) .'">', '</a></h2>' );
                                                                if( $main_banner_trailing_post_elements_show_date ) blog_postx_posted_on( get_the_ID() );
                                                            ?>
                                                        </div>
                                                    </div>
                                                <?php
                                                if( $main_banner_layouts === 'five' && $count === 2 ) echo '</div>';
                                                if( $main_banner_layouts === 'five' && $count === $total_posts ) echo '</div>';
                                                $count++;
                                            endwhile;
                                        endif;
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_main_banner_hook', 'blog_postx_main_banner_html' );
endif;

if( ! function_exists( 'blog_postx_category_collection_html' ) ) :
    /**
     * Category Collection html part
     * 
     * @since 1.0.0
     * @package Blog Postx Pro
     */
    function blog_postx_category_collection_html() {
        $category_collection_option = BPX\blog_postx_get_customizer_option( 'category_collection_option' );
        if( ! $category_collection_option || is_paged() || ! is_home() || ! is_front_page() ) return;
        $category_collection_layout = 'one';
        $category_collection_show_count = BPX\blog_postx_get_customizer_option( 'category_collection_show_count' );
        $category_collection_number_of_columns = BPX\blog_postx_get_customizer_option( 'category_collection_number_of_columns' );    
        $category_to_include = BPX\blog_postx_get_customizer_option( 'category_to_include' );
        $category_to_exclude = BPX\blog_postx_get_customizer_option( 'category_to_exclude' );
        $category_collection_number = BPX\blog_postx_get_customizer_option( 'category_collection_number' );
        $category_collection_orderby = BPX\blog_postx_get_customizer_option( 'category_collection_orderby' );
        $category_collection_sort = explode( '-', $category_collection_orderby );
        $category_collection_image_size = BPX\blog_postx_get_customizer_option( 'category_collection_image_size' );
        $category_collection_hover_effects = BPX\blog_postx_get_customizer_option( 'category_collection_hover_effects' );       
        $sectionClass = 'blog-postx-category-collection-section';
        $sectionClass .= ' layout--' . $category_collection_layout;
        $sectionClass .= ' hover-effect--' . $category_collection_hover_effects;
        $sectionClass .= ' column--' . blog_postx_convert_number_to_numeric_string( absint( $category_collection_number_of_columns['desktop'] ) );
        $sectionClass .= ' tab-column--' . blog_postx_convert_number_to_numeric_string( absint( $category_collection_number_of_columns['tablet'] ) );
        $sectionClass .= ' mobile-column--' . blog_postx_convert_number_to_numeric_string( absint( $category_collection_number_of_columns['smartphone'] ) );
        if( $category_collection_show_count ) $sectionClass .= ' category-count--enabled';
        $category_args = [
                'number'    =>  absint( $category_collection_number ),
                'exclude'   =>  ( ! empty( $category_to_exclude ) ) ? array_column( $category_to_exclude, 'value' ) : [],
                'include'   =>  ( ! empty( $category_to_include ) ) ? array_column( $category_to_include, 'value' ) : [],
                'orderby'   =>  $category_collection_sort[1],
                'order' =>  $category_collection_sort[0]
        ];
        $get_all_categories = get_categories( $category_args );
        $is_layout_three = ( $category_collection_layout === 'three' );
        ?>
            <section class="<?php echo esc_attr( $sectionClass ); ?>" id="blog-postx-category-collection-section">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="category-collection-wrap">
                            <?php
                                if( ! is_null( $get_all_categories ) && is_array( $get_all_categories ) ) :
                                    foreach( $get_all_categories as $cat_key => $cat_value ) :
                                        if( ! $is_layout_three ) :
                                            $category_query_args = [
                                                'cat'   =>  absint( $cat_value->term_id ),
                                                'meta_query'    =>  [
                                                    [
                                                        'key'   =>  '_thumbnail_id',
                                                        'compare'   =>  'EXISTS'
                                                    ]
                                                ],
                                                'ignore_stick_posts'    =>  true
                                            ];
                                            $category_query = new WP_Query( apply_filters( 'blog_postx_query_args_filter', $category_query_args ) );
                                            if( $category_query->have_posts() ) :
                                                $thumbnail_id = ( $category_query->posts[0]->ID != null ) ? $category_query->posts[0]->ID : '';
                                            else:
                                                $thumbnail_id = '';
                                            endif;
                                        endif;

                                        $catCountClass = 'category-count cat-' . esc_attr( $cat_value->term_id );

                                        ?>
                                            <div class="category-wrap">
                                                    <?php if( ! $is_layout_three ) : ?>
                                                        <figure class="category-thumb">
                                                            <a href="<?php echo get_term_link( $cat_value->term_id, 'category' ); ?>">
                                                                <?php if( $thumbnail_id ) echo wp_kses_post( get_the_post_thumbnail( $thumbnail_id, $category_collection_image_size, [ 'loading'   => 'lazy' ] ) ); ?>
                                                            </a>
                                                        </figure>
                                                    <?php endif; ?>
                                                    <div class="category-item cat-meta">
                                                        <div class="category-item-inner">
                                                            <div class="category-name">
                                                            <a href="<?php echo get_term_link( $cat_value->term_id, 'category' ); ?>">
                                                                <span class="category-label"><?php echo esc_html( $cat_value->name );?></span>
                                                                <?php if( $category_collection_show_count ) echo '<span class="', esc_attr( $catCountClass ) ,'">'. esc_html( $cat_value->count ) .'</span>';?>
                                                            </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                        <?php
                                    endforeach;
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_category_collection_hook', 'blog_postx_category_collection_html' );
endif;

if( ! function_exists( 'blog_postx_carousel_html' ) ) :
    /**
     * Carousel html
     * 
     * @since 1.0.0
     */
    function blog_postx_carousel_html() {
        if( ! BPX\blog_postx_get_customizer_option( 'carousel_option' ) || is_paged() || ! is_home() || ! is_front_page() ) return;
        // post elements
        $show_title = $show_categories = $show_featured_image = true;

        // image settings and slider settings
        $carousel_image_sizes = BPX\blog_postx_get_customizer_option( 'carousel_image_sizes' );

        // element class
        $elementClass = 'blog-postx-carousel-section carousel-layout--three carousel-banner-arrow-show arrow-on-hover--on';
        $carousel_aligment = BPX\blog_postx_get_customizer_option( 'carousel_post_elements_alignment' );
        $elementClass .= ' carousel-align--'.$carousel_aligment;
        if( ! $show_featured_image ) $elementClass .= ' hide-featured-image';

        $carousel_banner_excerpt_on_mobile = BPX\blog_postx_get_customizer_option( 'show_carousel_banner_excerpt_mobile_option' );
        $hide_on_mobile = ( ! $carousel_banner_excerpt_on_mobile ) ? ' hide-on-mobile' : '';

        $post_query_args = blog_postx_get_query_args( 'carousel' );
        $post_query = new \WP_Query( apply_filters( 'blog_postx_query_args_filter', $post_query_args ) );
        if( ! $post_query->have_posts() ) return;
        ?>
            <section class="<?php echo esc_attr( $elementClass ); ?>" id="blog-postx-carousel-section">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="carousel-wrap">
                            <?php
                                if( $post_query->have_posts() ) :
                                    while( $post_query->have_posts() ) :
                                        $post_query->the_post();
                                        $has_post_thumb = has_post_thumbnail();
                                        ?>
                                            <article class="post-item">
                                                <figure class="post-thumb<?php if( ! $has_post_thumb ) echo ' no-thumb'; ?>">
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php if( $has_post_thumb ) the_post_thumbnail( $carousel_image_sizes, [ 'loading'   => 'lazy' ] ); ?>
                                                    </a>
                                                </figure>
                                                <?php if( $show_categories || $show_title ) : ?>
                                                    <div class="post-elements">
                                                        <?php
                                                            if( $show_categories ) blog_postx_get_post_categories( get_the_ID(), 2 );
                                                            if( $show_title ) the_title( '<h2 class="post-title"><a href="'. esc_url( get_the_permalink() ) .'">', '</a></h2>' );
                                                        ?>
                                                    </div>
                                                <?php endif; ?>
                                            </article>
                                        <?php
                                    endwhile;
                                    wp_reset_postdata();
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_carousel_hook', 'blog_postx_carousel_html' );
endif;

if( ! function_exists( 'blog_postx_web_stories_html' ) ) :
    /**
     * Web stories hook
     * 
     * @since 1.0.0
     * @package Blog Postx Pro
     */
    function blog_postx_web_stories_html() {
        if( ! BPX\blog_postx_get_customizer_option( 'web_stories_option' ) || is_paged() || ! is_home() || ! is_front_page() ) return;
        $categories_to_include = BPX\blog_postx_get_customizer_option( 'web_stories_categories_to_include' );
        $orderby = BPX\blog_postx_get_customizer_option( 'web_stories_orderby' );
        $exploded_orderby = explode( '-', $orderby );
        $no_of_cats_to_show = BPX\blog_postx_get_customizer_option( 'web_stories_no_of_cats_to_show' );
        $max_no_of_inner_stories = BPX\blog_postx_get_customizer_option( 'web_stories_max_no_of_inner_stories' );
        $show_preview_count = true;
        $show_preview_title = true;
        $image_size = BPX\blog_postx_get_customizer_option( 'web_stories_image_sizes' );
        $image_hover = BPX\blog_postx_get_customizer_option( 'site_image_hover_effects' );
        $categories = get_categories([
            'number'    =>  absint( $no_of_cats_to_show ),
            'include'   =>  ( ! empty( $categories_to_include ) ) ? array_column( $categories_to_include, 'value' ) : [],
            'orderby'   =>  $exploded_orderby[1],
            'order' =>  $exploded_orderby[0]
        ]);
        $sectionClass[] = 'blog-postx-web-stories';
        if( $no_of_cats_to_show ) $sectionClass[] = 'column--' . blog_postx_convert_number_to_numeric_string( $no_of_cats_to_show );
        $sectionClass[] = 'hover--' . $image_hover;

        $page = get_pages([
            'meta_key'  =>  '_wp_page_template',
            'meta_value'    =>  'web-stories.php',
            'number'    =>  1
        ]);
        $archive_link = '#';
        if( ! empty( $page ) ) $archive_link = get_permalink( $page[ 0 ]->ID );
        ?>
            <section class="<?php echo esc_attr( implode( ' ', $sectionClass ) ); ?>">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="section-head">
                            <h2 class="section-title">
                                <span class="divider"></span>
                                <span class="title"><?php esc_html_e( 'Today\'s Stories', 'blog-postx' ); ?></span>
                            </h2>
                            <a href="<?php echo esc_url( $archive_link ); ?>" class="web-stories-view-all">
                                <span class="label"><?php esc_html_e( 'View all', 'blog-postx' ); ?></span>
                                <span class="icon"><i class="fa-solid fa-chevron-right"></i></span>
                            </a>
                        </div>
                        <div class="stories-wrap">
                            <?php
                                if( ! is_null( $categories ) && is_array( $categories ) ) :
                                    foreach( $categories as $cat_key => $cat_value ) :
                                        $category_query_args = [
                                            'cat'   =>  absint( $cat_value->term_id ),
                                            'meta_query'    =>  [
                                                [
                                                    'key'   =>  '_thumbnail_id',
                                                    'compare'   =>  'EXISTS'
                                                ]
                                            ],
                                            'ignore_stick_posts'    =>  true,
                                            'fields'    =>  'ids',
                                            'no_found_rows' =>  true
                                        ];
                                        $category_query = new WP_Query( apply_filters( 'blog_postx_query_args_filter', $category_query_args ) );
                                        $preview_title = '';
                                        if( $category_query->have_posts() ) :
                                            $first_post = $category_query->posts[0];
                                            $thumbnail_id = ( $first_post != null ) ? $first_post : '';
                                            $preview_title = get_the_title( $first_post );
                                        else:
                                            $thumbnail_id = '';
                                        endif;
                                        $category_count = $cat_value->count;

                                        ?>
                                            <div class="story" data-id="<?php echo esc_attr( $cat_value->term_id ); ?>" data-count="<?php echo esc_attr( $category_count ); ?>">
                                                <div class="preview">
                                                    <figure class="preview-thumb">
                                                        <?php if( $thumbnail_id ) echo wp_kses_post( get_the_post_thumbnail( $thumbnail_id, $image_size, [ 'loading'   => 'lazy' ] ) ); ?>
                                                    </figure>
                                                    <?php if( $show_preview_count ) echo '<a href="', esc_url( get_category_link( $cat_value->term_id ) ) ,'" class="story-count"><span class="label">', esc_html( $category_count ), '</span><span class="text">', esc_html__( ' Stories', 'blog-postx' ), '</span></a>'; ?>
                                                    <?php if( $preview_title && $show_preview_title ) echo '<div class="story-title-wrap"><h2 class="story-title"><span class="title-text">', esc_html( $preview_title ) ,'</span></h2></div>'; ?>
                                                    <div class="indicators">
                                                        <?php
                                                            if( $category_count ) :
                                                                for( $i = 0; $i < $category_count; $i++ ) :
                                                                    echo '<span class="indicator"></span>';
                                                                endfor;
                                                            endif;
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                    endforeach;
                                endif;
                            ?>
                        </div>
                        <div class="inner-stories-wrap">
                            <div class="inner-stories"></div>
                            <div class="action-buttons">
                                <button class="action-btn close"><i class="fa-solid fa-xmark"></i></button>
                                <button class="action-btn pause"><i class="fa-solid fa-pause"></i></button>
                            </div>
                            <div class="story-arrows"></div>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_web_stories_hook', 'blog_postx_web_stories_html' );
endif;

if( ! function_exists( 'blog_postx_advertisement_html' ) ) :
    /**
     * Frontpage advertisement html part
     * 
     * @since 1.0.0
     */
    function blog_postx_advertisement_html(){
        $serial_number = BPX\blog_postx_get_customizer_option( 'sortable_advertisement_number' );
        if( $serial_number ) :
            $advertisement_repeater = json_decode( BPX\blog_postx_get_customizer_option( 'advertisement_repeater' ), true );
            $sortable_ad_index = array_search( $serial_number, array_column( $advertisement_repeater, 'item_code' ) );
            if( is_int( $sortable_ad_index ) ) :
                $sortable_ad = $advertisement_repeater[ $sortable_ad_index ];
                $image = wp_get_attachment_image_url( $sortable_ad[ 'item_image' ], 'full' );
                if( ( $sortable_ad[ 'item_option' ] !== 'show' ) || ( ! $image ) ) return;
                $elementClass = 'alignment--' . $sortable_ad[ 'item_alignment' ];
                $elementClass .= ' image-option--' . ( ( $sortable_ad[ 'item_image_option' ] == 'full_width' ) ? 'full-width' : 'original' );
                ?>
                    <div class="blog-postx-advertisement-section">
                        <div class="blog-postx-container">
                            <div class="row">
                                <div class="blog-postx-advertisement-block <?php echo esc_html( $elementClass ); ?>">
                                    <a href="<?php echo esc_url( $sortable_ad[ 'item_url' ] ); ?>" target="<?php echo esc_attr( $sortable_ad[ 'item_target' ] ); ?>" rel="<?php echo esc_attr( $sortable_ad[ 'item_rel_attribute' ] ); ?>">
                                        <img src="<?php echo esc_url( $image ); ?>" loading="lazy">
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
            endif;
        endif;
    }
    add_action( 'blog_postx_advertisement_hook', 'blog_postx_advertisement_html' );
endif;