<?php
/**
 * Footer hooks and functions
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

if( ! function_exists( 'blog_postx_footer_logo_part' ) ) :
    /**
     * Bottom Footer logo element
     * 
     * @since 1.0.0
     */
    function blog_postx_footer_logo_part() {
        $logo_from = BPX\blog_postx_get_customizer_option( 'bottom_footer_header_or_custom' );
        $show_site_title = false;
        if( $logo_from == 'header' ) {
            $footer_logo = get_theme_mod( 'custom_logo' );
            if( ! $footer_logo ) $show_site_title = true;
        } else {
            $footer_logo = BPX\blog_postx_get_customizer_option( 'bottom_footer_logo_option' );
        };
        ?>
            <div class="footer-logo">
                <?php
                    if( $logo_from !== 'header' ) {
                        if( wp_get_attachment_image( $footer_logo, 'full' ) ) echo '<a href="'. home_url() .'" class="footer-site-logo">'. wp_get_attachment_image( $footer_logo, 'full' ) .'</a>';
                    } else {
                        $site_title_tag_for_frontpage = BPX\blog_postx_get_customizer_option( 'site_title_tag_for_frontpage' );
                        $site_title_tag_for_innerpage = BPX\blog_postx_get_customizer_option( 'site_title_tag_for_innerpage' );

                        the_custom_logo();

                        if ( is_front_page() && ! get_custom_logo() ) :
                            echo '<'. esc_html( $site_title_tag_for_frontpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_frontpage ) .'>';
                        else :
                            echo '<'. esc_html( $site_title_tag_for_innerpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_innerpage ) .'>';
                        endif;
                    }
                ?>
            </div>
        <?php
    }
    add_action( 'blog_postx_footer_logo_hook', 'blog_postx_footer_logo_part', 10 );
endif;

if( ! function_exists( 'blog_postx_footer_social_icons' ) ) :
   /**
    * Bottom Footer copyright element
    * 
    * @since 1.0.0
    */
    function blog_postx_footer_social_icons() {
        require get_template_directory() . '/inc/hooks/top-header-hooks.php'; // footer hooks.
        ?>
            <div class="social-icons-wrap footer">
                <?php blog_postx_customizer_social_icons( 'footer' ); ?>
            </div>
        <?php
    }
    add_action( 'blog_postx_footer_social_hook', 'blog_postx_footer_social_icons', 10 );
endif;

if( ! function_exists( 'blog_postx_footer_copyright_part' ) ) :
   /**
    * Bottom Footer copyright element
    * 
    * @since 1.0.0
    */
    function blog_postx_footer_copyright_part() {
      $bottom_footer_site_info = BPX\blog_postx_get_customizer_option( 'bottom_footer_site_info' );
      if( ! $bottom_footer_site_info ) return;
     ?>
        <div class="site-info">
            <?php echo wp_kses_post( str_replace( '%year%', date('Y'), $bottom_footer_site_info ) ); ?>
        </div>
     <?php
    }
    add_action( 'blog_postx_footer_copyright_hook', 'blog_postx_footer_copyright_part', 10 );
endif;

if( ! function_exists( 'blog_postx_you_may_have_missed_html' ) ) :
    /**
     * You May Have Missed Section html
     * 
     * @since 1.0.0
     */
    function blog_postx_you_may_have_missed_html() {
        if( ! BPX\blog_postx_get_customizer_option( 'you_may_have_missed_section_option' ) || is_paged() ) return;
        // post elements
        $show_title = $show_categories = true;
        // image settings and slider settings
        $you_may_have_missed_image_sizes = BPX\blog_postx_get_customizer_option( 'you_may_have_missed_image_sizes' );
        $you_may_have_missed_no_of_columns = absint( BPX\blog_postx_get_customizer_option( 'you_may_have_missed_no_of_columns' ) );

        // element class
        $elementClass = 'blog-postx-you-may-have-missed-section section--grid';
        $elementClass .= ( $you_may_have_missed_no_of_columns ) ? ' no-of-columns--'. blog_postx_convert_number_to_numeric_string( $you_may_have_missed_no_of_columns ) : '';

        $you_may_have_missed_aligment = BPX\blog_postx_get_customizer_option( 'you_may_have_missed_post_elements_alignment' );
        $elementClass .= ' you-may-have-missed-align--'. $you_may_have_missed_aligment;
        ?>
            <section class="<?php echo esc_attr( $elementClass ); ?>" id="blog-postx-you-may-have-missed-section">
                <div class="blog-postx-container">
                    <div class="row">
                        <div class="blog-postx-you-may-missed-inner-wrap">
                            <?php
                                $you_may_have_missed_title_option = BPX\blog_postx_get_customizer_option( 'you_may_have_missed_title_option' );
                                if( $you_may_have_missed_title_option ) :
                                    $you_may_have_missed_title = BPX\blog_postx_get_customizer_option( 'you_may_have_missed_title' );
                                    if( $you_may_have_missed_title ) :
                                        ?>
                                            <div class="section-title">
                                                <span class="divider"></span>
                                                <span class="title"><?php echo esc_html( $you_may_have_missed_title ); ?></span>
                                            </div>
                                        <?php
                                    endif;
                                endif;
                            ?>
                            <div class="you-may-have-missed-wrap">
                                <?php
                                    $post_query_args = blog_postx_get_query_args( 'you_may_have_missed' );
                                    $post_query = new \WP_Query( $post_query_args );
                                    if( $post_query->have_posts() ) :
                                        while( $post_query->have_posts() ) :
                                            $post_query->the_post();
                                            ?>
                                                <article class="post-item">
                                                    <figure class="post-thumbnail-wrapper">
                                                        <div class="post-thumnail-inner-wrapper">
                                                            <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                                                                <?php if( has_post_thumbnail() ) the_post_thumbnail( $you_may_have_missed_image_sizes ); ?>
                                                            </a>
                                                        </div>
                                                        <?php if( $show_categories || $show_title ) : ?>
                                                            <div class="inner-content">
                                                                <div class="content-wrap">
                                                                    <div class="blog-postx-inner-content-wrap-fi">
                                                                        <?php 
                                                                            if( $show_categories ) blog_postx_get_post_categories( get_the_ID(), 2 );
                                                                            if( $show_title ) the_title( '<h2 class="entry-title"><a href="'. esc_url( get_the_permalink() ) .'">', '</a></h2>' );
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    </figure>
                                                </article>
                                            <?php
                                        endwhile;
                                    endif;
                                    wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blog_postx_you_may_have_missed_hook', 'blog_postx_you_may_have_missed_html', 10 );
endif;

if( ! function_exists( 'blog_postx_footer_menu' ) ) :
    /**
     * Footer menu
     * 
     * @since 1.0.0
     */
    function blog_postx_footer_menu() {
        $footer_menu_hover_effect = BPX\blog_postx_get_customizer_option( 'footer_menu_hover_effect' );
        $menuClass = 'menu';
        $menuClass .= ' hover-effect--' . $footer_menu_hover_effect;
        wp_nav_menu(
            array(
                'theme_location'    =>  'menu-3',
                'menu_class'    =>  esc_attr( $menuClass ),
                'container' =>  'ul'
            )
        );
    }
    add_action( 'blog_postx_footer__menu_section_hook', 'blog_postx_footer_menu' );
endif;