<?php
/**
 * Handles the functionality required for the theme
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;

if ( ! function_exists( 'blog_postx_post_format_string' ) ) :
	/**
	 * Adds two typography parameter
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_post_format_string( $post_format ) {
        return $post_format ? $post_format: 'standard';
	}
	add_filter( 'blog_postx_post_format_string_filter', 'blog_postx_post_format_string' );
endif;

if ( ! function_exists( 'blog_postx_get_title_tags_array' ) ) :
	/**
	 * Generates possible array option for title tags
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_get_title_tags_array( $post_format ) {
        return [
			'h1'  =>  esc_html__( 'H1', 'blog-postx' ),
			'h2'  =>  esc_html__( 'H2', 'blog-postx' ),
			'h3'  =>  esc_html__( 'H3', 'blog-postx' ),
			'h4'  =>  esc_html__( 'H4', 'blog-postx' ),
			'h5'  =>  esc_html__( 'H5', 'blog-postx' ),
			'h6'  =>  esc_html__( 'H6', 'blog-postx' )
		];
	}
	add_filter( 'blog_postx_get_title_tags_array_filter', 'blog_postx_get_title_tags_array' );
endif;

if ( ! function_exists( 'blog_postx_schema_body_attributes' ) ) :
	/**
	 * Adds schema tags to the body tag.
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_schema_body_attributes() {
		$site_schema_ready = BPX\blog_postx_get_customizer_option( 'site_schema_ready' );
		if( ! $site_schema_ready ) return;
		$is_blog = ( is_home() || is_archive() || is_attachment() || is_tax() || is_single() );
		$itemtype = 'WebPage'; // default itemtype
		$itemtype = ( $is_blog ) ? 'Blog' : $itemtype; // itemtype for blog page
		$itemtype = ( is_search() ) ? 'SearchResultsPage' : $itemtype; // itemtype for earch results page
		$itemtype_final = apply_filters( 'blog_postx_schema_body_attributes_itemtype', $itemtype ); // itemtype
		echo apply_filters( 'blog_postx_schema_body_attributes', "itemtype='https://schema.org/" . esc_attr( $itemtype_final ) . "' itemscope='itemscope'" ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
endif;

if ( ! function_exists( 'blog_postx_schema_article_attributes' ) ) :
	/**
	 * Adds schema tags to the article tag.
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_schema_article_attributes() {
		$site_schema_ready = BPX\blog_postx_get_customizer_option( 'site_schema_ready' );
		if( ! $site_schema_ready ) return;
		$itemtype = 'Article'; // default itemtype.
		$itemtype_final = apply_filters( 'blog_postx_schema_article_attributes_itemtype', $itemtype ); // itemtype
		echo apply_filters( 'blog_postx_schema_article_attributes', "itemtype='https://schema.org/" . esc_attr( $itemtype_final ) . "' itemscope='itemscope'" ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
endif;

if ( ! function_exists( 'blog_postx_schema_article_name_attributes' ) ) :
	/**
	 * Adds schema tags to the article name tag.
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_schema_article_name_attributes() {
		$site_schema_ready = BPX\blog_postx_get_customizer_option( 'site_schema_ready' );
		if( ! $site_schema_ready ) return;
		$itemprop = 'name'; // default itemprop.
		$itemprop_final = apply_filters( 'blog_postx_schema_article_name_attributes_itemprop', $itemprop ); // itemprop
		return apply_filters( 'blog_postx_schema_article_name_attributes', "itemprop='" . esc_attr( $itemprop_final ) . "'" ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
endif;

if ( ! function_exists( 'blog_postx_schema_article_body_attributes' ) ) :
	/**
	 * Adds schema tags to the article body tag.
	 *
	 * 
	 * @echo html markup attributes
	 */
	function blog_postx_schema_article_body_attributes() {
		$site_schema_ready = BPX\blog_postx_get_customizer_option( 'site_schema_ready' );
		if( ! $site_schema_ready ) return;
		$itemprop = 'articleBody'; // default itemprop.
		$itemprop_final = apply_filters( 'blog_postx_schema_article_body_attributes_itemprop', $itemprop ); // itemprop
		echo apply_filters( 'blog_postx_schema_article_body_attributes', "itemprop='" . esc_attr( $itemprop_final ) . "'" ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
endif;

if ( ! function_exists( 'blog_postx_typography_value' ) ) :
	/**
	 * Adds two typography parameter
	 *
	 * @echo html markup attributes
	 */
	function blog_postx_typography_value( $id, $value = [] ) {
		if( empty( $value ) ) :
			$typo = BPX\blog_postx_get_customizer_option( $id );
		else:
			$typo = $value;
		endif;
		$font_family = $typo['font_family']['value'];
		$font_weight = $typo['font_weight']['value'];
		$variant = ( $typo['font_weight']['variant'] === 'italic' ) ? 'ital' : 'wght';
		$typo_value = [
			'font_family'	=> $font_family,
			'font_weight'	=> $font_weight,
			'variant'	=> $typo['font_weight']['variant']
		];
		return apply_filters( 'blog_postx_combined_typo', $typo_value ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
	add_filter( 'blog_postx_typo_combine_filter', 'blog_postx_typography_value', 10, 2 );
endif;

if( ! function_exists( 'blog_postx_compare_wand' ) ) :
	/**
	 * Compares parameter valaues
	 * 
	 * @package Blog Postx Pro
	 * @since 1.0.0
	 */
	function blog_postx_compare_wand( $params ) {
		$returnval = true;
		foreach( $params as $val ) :
			if( ! $val ) :
				$returnval = false;
				break;
			endif;
		endforeach;
		return $returnval;
	}
endif;

if( ! function_exists( 'blog_postx_function_exists' ) ) :
	/**
	 * Checks exists
	 * 
	 * @package Blog Postx Pro
	 * @since 1.0.0
	 */
	function blog_postx_function_exists( $function ) {
		if( function_exists( $function ) ) return true;
		return;
	}
endif;