<?php
/**
 * Includes functions for selective refresh
 * 
 * @package Blog Postx Pro
 * @since 1.0.0
 */
use BlogPostx\CustomizerDefault as BPX;
if( ! function_exists( 'blog_postx_customize_selective_refresh' ) ) :
    /**
     * Adds partial refresh for the customizer preview
     */
    function blog_postx_customize_selective_refresh( $wp_customize ) {
        if ( ! isset( $wp_customize->selective_refresh ) ) return;

        // theme mode light icon
        $wp_customize->selective_refresh->add_partial( 'theme_mode_dark_icon', [
            'selector'        => 'body .mode-toggle-wrap .mode-toggle',
            'render_callback' => 'blog_postx_theme_mode_callback'
        ]);

        // theme mode light icon
        $wp_customize->selective_refresh->add_partial( 'theme_mode_light_icon', [
            'selector'        => 'body .mode-toggle-wrap .mode-toggle',
            'render_callback' => 'blog_postx_theme_mode_callback'
        ]);

        // Header Builder Edit button
        $wp_customize->selective_refresh->add_partial( 'header_builder_section_tab', [
            'selector'        => 'header.site-header'
        ]);

        // Footer Builder Edit button
        $wp_customize->selective_refresh->add_partial( 'footer_section_tab', [
            'selector'        => 'footer.site-footer'
        ]);

        // Category Page icon
        $wp_customize->selective_refresh->add_partial( 'archive_category_info_box_option', [
            'selector'  =>  'body.archive.category  #blog-postx-main-wrap .archive-header',
            'render_callback'   =>  'blog_postx_category_page_icon'
        ]);

        // Tags Page icon
        $wp_customize->selective_refresh->add_partial( 'archive_tag_info_box_option', [
            'selector'  =>  'body.archive.tag #blog-postx-main-wrap .archive-header',
            'render_callback'   =>  'blog_postx_tags_page_icon',
            'settings'  =>  [ 'archive_tag_info_box_option' ]
        ]);

        // Authors Page icon
        $wp_customize->selective_refresh->add_partial( 'archive_author_info_box_option', [
            'selector'  =>  'body.archive.author #blog-postx-main-wrap .archive-header',
            'render_callback'   =>  'blog_postx_authors_page_icon',
            'settings'  =>  [ 'archive_author_info_box_option' ]
        ]);

        // Authors Page icon
        $wp_customize->selective_refresh->add_partial( 'archive_pagination_type', [
            'selector'  =>  'body.archive #blog-postx-main-wrap .pagination, body.search #blog-postx-main-wrap .pagination, body.home #blog-postx-main-wrap .pagination, body.blog #blog-postx-main-wrap #primary .pagination',
            'render_callback'   =>  'blog_postx_archive_pagination'
        ]);

        $post_format_partial_args = [ 'audio', 'gallery', 'image', 'standard', 'video', 'quote' ];
        if( ! empty( $post_format_partial_args ) && is_array( $post_format_partial_args ) ) :
            foreach( $post_format_partial_args as $format ):
                $wp_customize->selective_refresh->add_partial( $format . '_post_format_icon_picker', [
                    'selector'        => 'article.format-'. $format .' .post-format-ss-wrap .post-format-icon',
                    'render_callback' => 'blog_postx_'. $format .'_post_format_icon',
                ]);
            endforeach;
        endif;
    }
    add_action( 'customize_register', 'blog_postx_customize_selective_refresh' );
endif;

// theme mode callback
function blog_postx_theme_mode_callback() {
    $theme_mode_light_icon = BPX\blog_postx_get_customizer_option( 'theme_mode_light_icon' );
    $theme_mode_dark_icon = BPX\blog_postx_get_customizer_option( 'theme_mode_dark_icon' );
    blog_postx_theme_mode_switch( $theme_mode_light_icon, 'light' );
    blog_postx_theme_mode_switch( $theme_mode_dark_icon, 'dark' );
}

// audio post format icon
function blog_postx_audio_post_format_icon() {
    $audio_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'audio_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $audio_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// gallery post format icon
function blog_postx_gallery_post_format_icon() {
    $gallery_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'gallery_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $gallery_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// image post format icon
function blog_postx_image_post_format_icon() {
    $image_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'image_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $image_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// standard post format icon
function blog_postx_standard_post_format_icon() {
    $standard_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'standard_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $standard_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// video post format icon
function blog_postx_video_post_format_icon() {
    $video_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'video_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $video_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// quote post format icon
function blog_postx_quote_post_format_icon() {
    $quote_post_format_icon_picker = BPX\blog_postx_get_customizer_option( 'quote_post_format_icon_picker' );
	$icon_html = blog_postx_get_icon_control_html( $quote_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// category page icon
function blog_postx_category_page_icon() {
    if( is_category() && ! BPX\blog_postx_get_customizer_option( 'archive_category_info_box_option' ) ) return;
    $archive_category_info_box_icon = [ 'value' => 'fas fa-layer-group', 'type' => 'icon' ];
    $icon_html = blog_postx_get_icon_control_html( $archive_category_info_box_icon );
    $object_id = get_queried_object_id();
    $cat_args = get_category( $object_id );
    echo '<div class="archive-title">';
        echo '<div class="title-wrapper">';
            if( $icon_html ) echo $icon_html;
            the_archive_title( '<h2 class="page-title">', '</h2>' );
        echo '</div>';
        echo '<span class="archive-count">', esc_html( $cat_args->count . ' posts' ) ,'</span>';
    echo '</div>';
    the_archive_description( '<div class="archive-description">', '</div>' );
	return;
}

// tags page icon
function blog_postx_tags_page_icon() {
    if( is_tag() && ! BPX\blog_postx_get_customizer_option( 'archive_tag_info_box_option' ) ) return;
    $archive_tag_info_box_icon = [ 'value' => 'fas fa-tag', 'type' => 'icon' ];
    $icon_html = blog_postx_get_icon_control_html($archive_tag_info_box_icon);
    $object_id = get_queried_object_id();
    $tag_args = get_tag( $object_id );
    echo '<div class="archive-title">';
        echo '<div class="title-wrapper">';
            if( $icon_html ) echo $icon_html;
            the_archive_title( '<h2 class="page-title">', '</h2>' );
        echo '</div>';
        echo '<span class="archive-count">', esc_html( $tag_args->count . ' posts' ) ,'</span>';
    echo '</div>';
    the_archive_description( '<div class="archive-description">', '</div>' );
	return;
}

// Authors page icon
function blog_postx_authors_page_icon() {
    if( is_author() && ! BPX\blog_postx_get_customizer_option( 'archive_author_info_box_option' ) ) return;
    $object_id = get_queried_object_id();
    echo '<div class="archive-title">';
        echo '<div class="title-wrapper">';
            $author_image = get_avatar( $object_id, 90 );
            if( $author_image ) echo $author_image;
            the_archive_title( '<h2 class="page-title">', '</h2>' );
        echo '</div>';
        echo '<span class="archive-count">', esc_html( count_user_posts( $object_id ) . ' posts' ) ,'</span>';
    echo '</div>';
    the_archive_description( '<div class="archive-description">', '</div>' );
	return;
}

// archive pagination
function blog_postx_archive_pagination() {
    /**
     * hook - blog_postx_pagination_link_hook
     * 
     * hooked - blog_postx_pagination_fnc - 10
     * @since 1.0.0
     */
    if( has_action( 'blog_postx_pagination_link_hook' ) ) do_action( 'blog_postx_pagination_link_hook' );
}