<?php
use BlogPostx\CustomizerDefault as BPX;
/**
 * Includes panel, section and controls ids and parameters
 * 
 * @since 1.0.0
 * @package Blog Postx Pro
 */

 if( ! class_exists( 'Blog_Postx_Customizer_List' ) ) :
    class Blog_Postx_Customizer_List {
        /**
         * Returns panels array
         * 
         * @since 1.0.0
         */
        public function get_panels( $id = '' ) {
            $panels_array = [
                'global_panel'    =>  [
                    'title' =>  __( 'Global', 'blog-postx' ),
                    'priority'  => 6
                ],
                'colors_panel'    =>  [
                    'title' =>  __( 'Colors', 'blog-postx' ),
                    'priority'  => 20
                ],
                'frontpage_panel'    =>  [
                    'title' =>  __( 'Frontpage Sections', 'blog-postx' ),
                    'priority'  =>  80
                ],
                'archive_panel'    =>  [
                    'title' =>  __( 'Blog / Archives', 'blog-postx' ),
                    'priority'  =>  80
                ],
                'single_section_panel'    =>  [
                    'title' =>  __( 'Single Post', 'blog-postx' ),
                    'priority'  =>  80
                ]
            ];
            return ( $id ? $panels_array[ $id ] : $panels_array );
        }

        /**
         * Returns sections array
         * 
         * @since 1.0.0
         */
        public function get_sections( $id = '' ) {
            $sections_array =  [
                'about_section' => [
                    'title' => esc_html__( 'About Theme', 'blog-postx' ),
                    'priority'  => 1
                ],
                'header_builder_section' => [
                    'title' => esc_html__( 'Header Builder', 'blog-postx' ),
                    'active_callback'   =>  function(){ return false; }
                ],
                'footer_builder_section' => [
                    'title' => esc_html__( 'Footer Builder', 'blog-postx' ),
                    'active_callback'   =>  function(){ return false; }
                ],
                'header_builder_section_settings' => [
                    'title' => esc_html__( 'Header Builder', 'blog-postx' ),
                    'priority'  => 70
                ],
                'footer_builder_section_settings' => [
                    'title' => esc_html__( 'Footer Builder', 'blog-postx' ),
                    'priority'  => 80
                ],
                'seo_misc_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'SEO / Misc', 'blog-postx' ),
                ],
                'preloader_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Preloader', 'blog-postx' ),
                ],
                'website_layout_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Website Layout', 'blog-postx' ),
                ],
                'animation_section' => [
                    'title' => esc_html__( 'Animation / Hover Effects', 'blog-postx' ),
                    'panel' => 'global_panel'
                ],
                'social_icons_section' => [
                    'title' => esc_html__( 'Social Icons', 'blog-postx' ),
                ],
                'footer_social_icons_section' => [
                    'title' => esc_html__( 'Social Icons', 'blog-postx' ),
                ],
                'buttons_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Buttons', 'blog-postx' ),
                ],
                'global_icon_pickers' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Icon Pickers', 'blog-postx' ),
                ],
                'breadcrumb_options_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Breadcrumb Options', 'blog-postx' ),
                ],
                'stt_options_section' => [
                    'title' => esc_html__( 'Scroll To Top', 'blog-postx' ),
                ],
                'global_icon_pickers' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Icon Pickers', 'blog-postx' ),
                ],
                'advertisement_section' => [
                    'title' =>  esc_html__( 'Advertisement', 'blog-postx' ),
                    'priority'  =>  29
                ],
                'typography_section' => [
                    'title' => esc_html__( 'Typography', 'blog-postx' ),
                    'priority'  => 30
                ],
                'widget_styles_section' => [
                    'title' => esc_html__( 'Sidebar / Widget Styles', 'blog-postx' ),
                    'priority'  => 30
                ],
                'mobile_options_section' => [
                    'title' => esc_html__( 'Mobile Options', 'blog-postx' ),
                    'priority'  => 30
                ],
                'theme_presets_section' => [
                    'panel' =>  'colors_panel',
                    'title' =>  esc_html__( 'Theme Colors / Presets', 'blog-postx' ),
                ],
                'category_colors_section' => [
                    'panel' => 'colors_panel',
                    'title' => esc_html__( 'Category Colors', 'blog-postx' ),
                ],
                'tag_colors_section' => [
                    'title' => esc_html__( 'Tag Colors', 'blog-postx' ),
                    'panel' => 'colors_panel',
                ],
                'date_time_section' => [
                    'title' =>  esc_html__( 'Date / Time', 'blog-postx' )
                ],
                'header_menu_options_section' => [
                    'title' =>  esc_html__( 'Menu Options', 'blog-postx' )
                ],
                'footer_menu_options_section' => [
                    'title' =>  esc_html__( 'Menu Options', 'blog-postx' )
                ],
                'header_live_search_section' => [
                    'title' =>  esc_html__( 'Search', 'blog-postx' )
                ],
                'custom_button_section' => [
                    'title' =>  esc_html__( 'Custom Button', 'blog-postx' )
                ],
                'theme_mode_section' => [
                    'title' =>  esc_html__( 'Theme Mode', 'blog-postx' )
                ],
                'canvas_menu_section' => [
                    'title' =>  esc_html__( 'Off canvas', 'blog-postx' )
                ],
                'sticky_posts_section' => [
                    'title' =>  esc_html__( 'Sticky Posts', 'blog-postx' ),
                    'priority'  => 30
                ],
                'ticker_news_section' => [
                    'title' =>  esc_html__( 'Ticker News', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'web_stories_section' => [
                    'title' =>  esc_html__( 'Web Stories', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'main_banner_section' => [
                    'title' =>  esc_html__( 'Main Banner', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'carousel_section' => [
                    'title' =>  esc_html__( 'Carousel', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'category_collection_section' => [
                    'title' =>  esc_html__( 'Category collection', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'frontpage_reorder_section' => [
                    'title' =>  esc_html__( 'Re-order Section', 'blog-postx' ),
                    'panel' =>  'frontpage_panel'
                ],
                'archive_general_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'General Settings', 'blog-postx' ),
                ],
                'category_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Category Page', 'blog-postx' ),
                ],
                'tag_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Tag Page', 'blog-postx' ),
                ],
                'author_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Author Page', 'blog-postx' ),
                ],
                'pagination_settings_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Pagination Settings', 'blog-postx' ),
                ],
                'blog_single_general_settings' => [
                    'panel' =>  'single_section_panel',
                    'title' =>  esc_html__( 'General Settings', 'blog-postx' ),
                ],
                'blog_single_elements_settings_section' => [
                    'title' =>  esc_html__( 'Elements Settings', 'blog-postx' ),
                    'panel' =>  'single_section_panel'
                ],
                'blog_single_related_posts_section' => [
                    'panel' =>  'single_section_panel',
                    'title' =>  esc_html__( 'Related Posts', 'blog-postx' )
                ],
                'page_settings_section' => [
                    'title' =>  esc_html__( 'Page Settings', 'blog-postx' ),
                    'priority'  =>  80
                ],
                'you_may_have_missed_section' => [
                    'title' => esc_html__( 'You May Have Missed', 'blog-postx' ),
                    'priority'  => 80
                ],
                /* Header builder row settings section */
                'header_first_row' => [
                    'title' => esc_html__( 'Header First Row', 'blog-postx' )
                ],
                'header_second_row' => [
                    'title' => esc_html__( 'Header Second Row', 'blog-postx' )
                ],
                'header_third_row' => [
                    'title' => esc_html__( 'Header Third Row', 'blog-postx' )
                ],
                /* Footer builder row settings section */
                'footer_first_row' => [
                    'title' => esc_html__( 'Footer First Row', 'blog-postx' )
                ],
                'footer_second_row' => [
                    'title' => esc_html__( 'Footer Second Row', 'blog-postx' )
                ],
                'footer_third_row' => [
                    'title' => esc_html__( 'Footer Third Row', 'blog-postx' )
                ],
                'footer_logo' => [
                    'title' => esc_html__( 'Footer Logo Settings', 'blog-postx' )
                ],
                'footer_copyright' => [
                    'title' => esc_html__( 'Footer Copyright', 'blog-postx' )
                ],
                'mobile_canvas_section' => [
                    'title' => esc_html__( 'Mobile Canvas', 'blog-postx' )
                ],
                'header_secondary_menu_options' => [
                    'title' => esc_html__( 'Menu Options', 'blog-postx' )
                ]
            ];
            return ( $id ? $sections_array[ $id ] : $sections_array );
        }

        /**
         * Returns typography array
         * 
         * @since 1.0.0
         */
        public function get_typography( $id = '' ) {
            $default = [
                'fields'    =>  [ 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration' ],
                'transport' =>  'postMessage'
            ];
            $control_array = [
                'site_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Title Typography', 'blog-postx' ),
                ]),
                'site_description_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Description Typography', 'blog-postx' ),
                    'bottom_separator'  =>  true
                ]),
                'site_block_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Block Title Typo', 'blog-postx' ),
                ]),
                'date_time_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blog-postx' ),
                ]),
                'main_menu_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Main Menu Typography', 'blog-postx' ),
                ]),
                'main_menu_sub_menu_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Sub Menu Typography', 'blog-postx' )
                ]),
                'custom_button_text_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typography', 'blog-postx' )
                ]),
                'main_banner_design_post_title_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blog-postx' ),
                ]),
                'main_banner_design_post_excerpt_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Excerpt Typo', 'blog-postx' )
                ]),
                'main_banner_sidebar_post_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blog-postx' ),
                ]),
                'carousel_design_post_title_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blog-postx' ),
                ]),
                'category_collection_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blog-postx' ),
                ]),
                'global_button_typo'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blog-postx' ),
                    'bottom_separator'  =>  true
                ]),
                'breadcrumb_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blog-postx' ),
                ]),
                'archive_title_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title', 'blog-postx' ),
                ]),
                'archive_excerpt_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Excerpt Typo', 'blog-postx' ),
                ]),
                'archive_category_info_box_title_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Title', 'blog-postx' ),
                ]),
                'archive_category_info_box_description_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Description Typo', 'blog-postx' ),
                ]),
                'archive_tag_info_box_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Tag Title', 'blog-postx' ),
                ]),
                'archive_tag_info_box_description_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Tag Description Typo', 'blog-postx' ),
                ]),
                'archive_author_info_box_title_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Name', 'blog-postx' ),
                ]),
                'archive_author_info_box_description_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Description Typo', 'blog-postx' ),
                ]),
                'single_title_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blog-postx' ),
                ]),
                'single_content_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Content Typo', 'blog-postx' ),
                ]),
                'page_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Page Title Typo', 'blog-postx' ),
                ]),
                'page_content_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Page Content Typo', 'blog-postx' ),
                ]),
                'you_may_have_missed_design_post_title_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blog-postx' ),
                ]),
                'footer_title_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Block Title Typo', 'blog-postx' ),
                ]),
                'footer_text_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typo', 'blog-postx' )
                ]),
                'bottom_footer_text_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typo', 'blog-postx' ),
                ]),
                'heading_one_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 1', 'blog-postx' ),
                ]),
                'heading_two_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 2', 'blog-postx' ),
                ]),
                'heading_three_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 3', 'blog-postx' ),
                ]),
                'heading_four_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 4', 'blog-postx' ),
                ]),
                'heading_five_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 5', 'blog-postx' ),
                ]),
                'heading_six_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 6', 'blog-postx' ),
                ]),
                'sidebar_post_title_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title', 'blog-postx' ),
                ]),
                'sidebar_pagination_button_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Pagination typo', 'blog-postx' ),
                ]),
                'sidebar_heading_one_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 1', 'blog-postx' ),
                ]),
                'sidebar_heading_two_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 2', 'blog-postx' ),
                ]),
                'sidebar_heading_three_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 3', 'blog-postx' ),
                ]),
                'sidebar_heading_four_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 4', 'blog-postx' ),
                ]),
                'sidebar_heading_five_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 5', 'blog-postx' ),
                ]),
                'sidebar_heading_six_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 6', 'blog-postx' ),
                ]),
                'footer_menu_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blog-postx' ),
                ]),
                'ticker_news_post_title_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title Typo', 'blog-postx' ),
                ]),
                'global_author_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blog-postx' ),
                ]),
                'global_date_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blog-postx' ),
                ]),
                'global_comments_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Comments Typo', 'blog-postx' ),
                ]),
                'global_read_time_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Read Time Typo', 'blog-postx' ),
                ]),
                'global_category_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blog-postx' ),
                ]),
                'sticky_posts_label_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Label', 'blog-postx' ),
                ]),
                'sticky_posts_title_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title', 'blog-postx' ),
                ]),
                'web_stories_preview_count_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Preview count', 'blog-postx' ),
                ]),
                'web_stories_preview_title_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Preview title', 'blog-postx' ),
                ]),
                'web_stories_title_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title', 'blog-postx' ),
                ]),
                'header_secondary_menu_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blog-postx' ),
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_typography()

        /**
         * Returns checkbox array
         * 
         * @since 1.0.0
         */
        public function get_checkbox( $id = '' ) {
            $default = [
                'type'  =>  'checkbox',
                'transport' =>  'postMessage'
            ];
            $control_array = [
                'blogdescription_option'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Display site description', 'blog-postx' ),
                    'priority'  =>  40
                ]),
                'show_main_banner_excerpt_mobile_option'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show main banner excerpt on mobile', 'blog-postx' ) 
                ]),
                'show_carousel_banner_excerpt_mobile_option'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show carousel banner excerpt on mobile', 'blog-postx' )
                ]),
                'show_readtime_mobile_option'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show readtime on mobile', 'blog-postx' ) 
                ]),
                'show_comment_number_mobile_option' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show comment number on mobile', 'blog-postx' )
                ]),
                'show_background_animation_on_mobile'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show background animation on mobile', 'blog-postx' ) 
                ]),
                'show_scroll_to_top_on_mobile'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show scroll to top on mobile', 'blog-postx' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns toggle array
         * 
         * @since 1.0.0
         */
        public function get_toggle( $id = '' ) {
            $default = [
            ];
            $control_array = [
                'sticky_posts_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show Sticky Posts', 'blog-postx' ),
                ]),
                'ticker_news_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show Ticker News', 'blog-postx' ),
                ]),
                'web_stories_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show Web Stories', 'blog-postx' ),
                ]),
                'main_banner_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show main banner', 'blog-postx' ),
                ]),
                'carousel_option'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show carousel', 'blog-postx' ),
                ]),
                'category_collection_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable category collection', 'blog-postx' ),
                ]),
                'site_schema_ready' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Make website schema ready', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'disable_admin_notices'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Disabled the theme admin notices', 'blog-postx' ),
                    'description'	      => esc_html__( 'This will hide all the notices or any message shown by the theme like review notices, change log notices', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'preloader_option'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable site preloader', 'blog-postx' )
                ]),
                'archive_category_info_box_option'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show category info box', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'archive_tag_info_box_option'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show tag info box', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'archive_author_info_box_option'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show author info box', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'single_post_related_posts_option'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show related articles', 'blog-postx' ),
                ]),
                'you_may_have_missed_section_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable you may have missed section', 'blog-postx' ),
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns simple toggle array
         * 
         * @since 1.0.0
         */
        public function get_simple_toggle( $id = '' ) {
            $default = [
            ];
            $control_array = [
                'header_buiilder_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Section Sticky', 'blog-postx' )
                ]),
                'header_first_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 1st row', 'blog-postx' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage'
                ]),
                'header_second_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 2nd row', 'blog-postx' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage'
                ]),
                'header_third_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 3rd row', 'blog-postx' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage',
                    'bottom_separator'  =>  true
                ]),
                'ticker_news_hide_empty' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'main_banner_hide_empty' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'main_banner_trailing_hide_empty' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'carousel_hide_empty' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'category_collection_show_count' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show category count', 'blog-postx' ),
                ]),
                'site_breadcrumb_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show breadcrumb trails', 'blog-postx' ),
                ]),
                'you_may_have_missed_title_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show section title', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_hide_empty' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'global_show_author_image' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show author image', 'blog-postx' )
                ]),
                'sticky_hide_empty' => $this->get_params( $default, [
                    'label' => esc_html__( 'Hide posts with no featured image', 'blog-postx' )
                ]),
                'footer_social_icons_display_label' => $this->get_params( $default, [
                    'label' => esc_html__( 'Display Label', 'blog-postx' )
                ]),
                'footer_social_icons_display_count' => $this->get_params( $default, [
                    'label' => esc_html__( 'Display Count', 'blog-postx' )
                ]),
                'time_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Time', 'blog-postx' ),
                ]),
                'date_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Date', 'blog-postx' ),
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_simple_toggle() Method

        /**
         * Get all section tab control
         * 
         * @since 1.0.0
         */
        public function get_section_tab( $id = '' ) {
            $default = [
                'choices'   =>  [
                    [
                        'name'  =>  'general',
                        'title' =>  esc_html__( 'General', 'blog-postx' )
                    ],
                    [
                        'name'  =>  'design',
                        'title' =>  esc_html__( 'Design', 'blog-postx' )
                    ]
                ],
                'priority'  =>  1
            ];
            $control_array = [
                'category_colors_section_tab'    =>  $this->get_params( $default, []),
                'date_time_section_tab'    =>  $this->get_params( $default, []),
                'header_secondary_menu_options_section_tab'    =>  $this->get_params( $default, []),
                'header_builder_section_tab'    =>  $this->get_params( $default, []),
                'site_title_section_tab'    =>  $this->get_params( $default, []),
                'menu_options_section_tab' =>  $this->get_params( $default, []),
                'search_section_tab'    =>  $this->get_params( $default, []),
                'custom_button_section_tab'  =>  $this->get_params( $default, []),
                'theme_mode_section_tab' =>  $this->get_params( $default, []),
                'canvas_menu_setting'   =>  $this->get_params( $default, []),
                'category_collection_section_heading'   =>  $this->get_params( $default, []),
                'breadcrumb_section_tab'    =>  $this->get_params( $default, []),
                'stt_section_tab'   =>  $this->get_params( $default, []),
                'archive_section_heading'   =>  $this->get_params( $default, []),
                'category_archive_section_heading'  =>  $this->get_params( $default, []),
                'tag_archive_section_heading'   =>  $this->get_params( $default, []),
                'author_archive_section_heading'    =>  $this->get_params( $default, []),
                'single_section_heading'    => $this->get_params( $default, []),
                'page_settings_section_tab' =>  $this->get_params( $default, []),
                'you_may_have_missed_section_tab'   =>  $this->get_params( $default, []),
                'footer_section_tab'    =>  $this->get_params( $default, []),
                'bottom_footer_section_tab' =>  $this->get_params( $default, []),
                'ticker_news_section_heading'  =>  $this->get_params( $default, []),
                'web_stories_section_tab'  =>  $this->get_params( $default, []),
                'main_banner_section_heading'  =>  $this->get_params( $default, []),
                'carousel_section_heading' =>  $this->get_params( $default, []),
                'global_icon_pickers_section_tab'   =>  $this->get_params( $default, []),
                'sticky_posts_section_heading'   =>  $this->get_params( $default, []),
                /* Header builder row controls */
                'header_first_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                'header_second_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                'header_third_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                /* Footer builder row controls */
                'footer_first_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                'footer_second_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                'footer_third_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blog-postx' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blog-postx' )
                        ]
                    ],
                ]),
                'mobile_canvas_section_tab'   =>  $this->get_params( $default, [] ),
                'footer_menu_section_tab'   =>  $this->get_params( $default, [] )
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_tab() Method

        /**
         * Get all spacing controls
         * 
         * @since 1.0.0
         */
        public function get_spacing( $id = '' ) {
            $default = [
                'label' =>  esc_html__( 'Padding ( px )', 'blog-postx' ),
                'input_attrs' => $this->get_input_attrs([
                    'max'   => 50
                ]),
                'transport' =>  'postMessage'
            ];

            $control_array = [
                'carousel_image_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius ( Px )', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                ]),
                /* Header row paddings */
                'header_first_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'header_second_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'header_third_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                /* Footer row paddings */
                'footer_first_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'footer_second_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'footer_third_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_spacing() Method

        /**
         * Get all radio tab controls
         * 
         * @since 1.0.0
         */
        public function get_radio_tab( $id = '' ) {
            $default = [
                'label' => esc_html__( 'Elements Alignment', 'blog-postx' ),
                'choices' => [
                    [
                        'value' => 'left',
                        'icon'  =>  'editor-alignleft',
                        'label' =>  esc_html__( 'Left', 'blog-postx' )
                    ],
                    [
                        'value' => 'center',
                        'icon'  =>  'editor-aligncenter',
                        'label' =>  esc_html__( 'Center', 'blog-postx' )
                    ],
                    [
                        'value' => 'right',
                        'icon'  =>  'editor-alignright',
                        'label' =>  esc_html__( 'Right', 'blog-postx' )
                    ]
                ],
                'transport' =>  'postMessage'
            ];
            $control_array = [
                'main_banner_post_elements_alignment'  =>  $this->get_params( $default, []),
                'carousel_post_elements_alignment' =>  $this->get_params( $default, []),
                'site_date_to_show'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Date to display', 'blog-postx' ),
                    'description' => esc_html__( 'Whether to show date published or modified date.', 'blog-postx' ),
                    'choices' => [
                        [
                            'value' => 'published',
                            'label' => esc_html__('Published date', 'blog-postx' )
                        ],
                        [
                            'value' => 'modified',
                            'label' => esc_html__('Modified date', 'blog-postx' )
                        ]
                    ],
                    'double_line'   =>  true,
                    'transport' =>  'refresh'
                ]),
                'archive_post_elements_alignment'  =>  $this->get_params( $default, []),
                'single_post_content_alignment'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post content alignment', 'blog-postx' ),
                    'bottom_separator'  =>  true
                ]),
                'you_may_have_missed_post_elements_alignment'  =>  $this->get_params( $default, []),

                'canvas_menu_position'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Canvas Position', 'blog-postx' ),
                    'choices'   =>  [
                        [
                            'value' => 'left',
                            'icon'  =>  'editor-alignleft'
                        ],
                        [
                            'value' => 'right',
                            'icon'  =>  'editor-alignright'
                        ]
                    ],
                ]),
                'mobile_canvas_alignment'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Alignment', 'blog-postx' ),
                ]),
                'sticky_posts_position'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Position', 'blog-postx' ),
                    'choices' => [
                        [
                            'value' => 'left',
                            'icon'  =>  'editor-alignleft',
                            'label' =>  esc_html__( 'Left', 'blog-postx' )
                        ],
                        [
                            'value' => 'right',
                            'icon'  =>  'editor-alignright',
                            'label' =>  esc_html__( 'Right', 'blog-postx' )
                        ]
                    ],
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_radio_tab() Method

        /**
         * Get all info box control
         * 
         * @since 1.0.0
         */
        public function get_info_box( $id = '' ) {
            $control_array = [
                'site_documentation_info' =>  [
                    'label' => esc_html__( 'Theme Documentation', 'blog-postx' ),
                    'description' => esc_html__( 'We have well prepared documentation which includes overall instructions and recommendations that are required in this theme.', 'blog-postx' ),
                    'choices' => [
                        [
                            'label' => esc_html__( 'View Documentation', 'blog-postx' ),
                            'url'   => esc_url( '//doc.blazethemes.com/blog-postx' )
                        ]
                    ]
                ],
                'site_support_info'   =>  [
                    'label' => esc_html__( 'Theme Support', 'blog-postx' ),
                    'description' => esc_html__( 'We provide 24/7 support regarding any theme issue. Our support team will help you to solve any kind of issue. Feel free to contact us.', 'blog-postx' ),
                    'choices' => [
                        [
                            'label' => esc_html__( 'Support Form', 'blog-postx' ),
                            'url'   => esc_url( '//blazethemes.com/support' )
                        ]
                    ]
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_info_box() Method

        /**
         * Get all section heading toggle controls
         * 
         * @since 1.0.0
         */
        public function get_section_heading_toggle( $id = '' ) {
            $default = [];
            $control_array = [
                'ticker_news_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blog-postx' )
                ]),
                'main_banner_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blog-postx' ),
                ]),
                'main_banner_trailing_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Trailing Post Query', 'blog-postx' ),
                ]),
                'main_banner_post_elements_settings_heading'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blog-postx' ),
                ]),
                'main_banner_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blog-postx' )
                ]),
                'main_banner_design_typography'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blog-postx' ),
                ]),
                'main_banner_design_sidebar_typography'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Sidebar Typography', 'blog-postx' ),
                ]),
                'carousel_post_query_settings_heading'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blog-postx' ),
                ]),
                'carousel_post_elements_settings_heading'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blog-postx' )
                ]),
                'carousel_image_setting_heading'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
                'category_collection_query_section_heading_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Query Settings', 'blog-postx' ),
                ]),
                'category_collection_image_heading_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
                'archive_layouts_settings_header' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Layouts Settings', 'blog-postx' ),
                ]),
                'archive_elements_settings_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Elements Settings', 'blog-postx' ),
                ]),
                'archive_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
                'single_image_settings_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
                'page_image_setting_heading'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blog-postx' )
                ]),
                'page_table_of_content_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Table of content', 'blog-postx' ),
                ]),
                'you_may_have_missed_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blog-postx' ),
                ]),
                'you_may_have_missed_post_elements_settings_heading'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blog-postx' ),
                ]),
                'you_may_have_missed_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
                'widget_styles_general_settings_header'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'General Settings', 'blog-postx' )
                ]),
                'widget_styles_sidebar_settings_header'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Sidebar Typography', 'blog-postx' )
                ]),
                'widget_styles_headings_settings_header'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Heading Typography', 'blog-postx' )
                ]),
                'logo_and_icon_section_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Logo & Site Icon', 'blog-postx' ),
                    'priority'  =>  5
                ]),
                'site_title_section_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Site Title & Tagline', 'blog-postx' ),
                    'priority'  =>  20
                ]),
                'sticky_posts_posts_query_section_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Query Settings', 'blog-postx' )
                ]),
                'web_stories_query_settings_heading_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Query Settings', 'blog-postx' ),
                ]),
                'web_stories_image_settings'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Settings', 'blog-postx' ),
                ]),
            ];
            $totalCats = get_categories();
            if( $totalCats ) :
                foreach( $totalCats as $singleCat ) :
                    $cat_id = 'category_' . absint( $singleCat->term_id ) . '_color_heading';
                    $control_array[ $cat_id ] = [
                        'label' => esc_html( $singleCat->name ),
                        'bottom_separator'  =>  true
                    ];
                endforeach;
            endif;

            $totalTags = get_tags();
            $tag_priority = 10;
            if( $totalTags ) :
                foreach( $totalTags as $singleTag ) :
                    $tag_id = 'tag_' . absint( $singleTag->term_id ) . '_color_heading';
                    $control_array += [ $tag_id =>  [
                        'label' => esc_html( $singleTag->name ),
                        'bottom_separator'  =>  true
                    ]];
                    $tag_priority += 10;
                endforeach;
            endif;
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_heading_toggle() Method

        /**
         * Get all item sortable control
         * 
         * @since 1.0.0
         */
        public function get_item_sortable( $id = '' ) {
            $control_array = [
                'frontpage_reorder_control' =>  [
                    'label' =>  esc_html__( 'Reorder Sections', 'blog-postx' ),
                    'description' =>  esc_html__( 'Drag to re-order the sections.', 'blog-postx' ),
                    'fields'    =>  [
                        'ticker_news'   =>  [
                            'label' => esc_html__( 'Ticker News', 'blog-postx' ),
                            'focusable_control'  =>  'ticker_news_option'
                        ],
                        'web_stories'   =>  [
                            'label' => esc_html__( 'Web Stories', 'blog-postx' ),
                            'focusable_control'  =>  'web_stories_option'
                        ],
                        'main_banner'   =>  [
                            'label' => esc_html__( 'Main Banner', 'blog-postx' ),
                            'focusable_control'  =>  'main_banner_option'
                        ],
                        'category_collection'   =>  [
                            'label' => esc_html__( 'Category Collection', 'blog-postx' ),
                            'focusable_control'  =>  'category_collection_option'
                        ],
                        'carousel'   =>  [
                            'label' => esc_html__( 'Carousel', 'blog-postx' ),
                            'focusable_control'  =>  'carousel_option'
                        ],
                        'latest_posts'   =>  [
                            'label' => esc_html__( 'Latest Posts', 'blog-postx' ),
                            'focusable_control'  =>  'archive_post_layout'
                        ],
                        'advertisement'   =>  [
                            'label' => esc_html__( 'Advertisement', 'blog-postx' ),
                            'focusable_control'  =>  'advertisement_repeater'
                        ]
                    ] 
                ],
                'archive_meta_reorder'  =>  [
                    'label' =>  esc_html__( 'Meta Re-order', 'blog-postx' ),
                    'fields'    =>  [
                        'author'    =>  [
                            'label' => esc_html__( 'Author', 'blog-postx' )
                        ],
                        'date'  =>  [
                            'label' => esc_html__( 'Date', 'blog-postx' )
                        ],
                        'read_time'  =>  [
                            'label' => esc_html__( 'Read Time', 'blog-postx' )
                        ],
                        'comment'    =>  [
                            'label' => esc_html__( 'Comments', 'blog-postx' )
                        ]
                    ],
                    'visibility'    =>  true
                ],
                'archive_content_reorder'  =>  [
                    'label' =>  esc_html__( 'Content Re-order', 'blog-postx' ),
                    'fields'    =>  [
                        'title'    =>  [
                            'label' => esc_html__( 'Title', 'blog-postx' )
                        ],
                        'meta'  =>  [
                            'label' => esc_html__( 'Meta', 'blog-postx' )
                        ],
                        'excerpt'  =>  [
                            'label' => esc_html__( 'Excerpt', 'blog-postx' )
                        ],
                        'button'    =>  [
                            'label' => esc_html__( 'Button', 'blog-postx' )
                        ]
                    ],
                    'visibility'    =>  true
                ],
                'single_meta_reorder'  =>  [
                    'label' =>  esc_html__( 'Meta Re-order', 'blog-postx' ),
                    'fields'    =>  [
                        'author'    =>  [
                            'label' => esc_html__( 'Author', 'blog-postx' )
                        ],
                        'date'  =>  [
                            'label' => esc_html__( 'Date', 'blog-postx' )
                        ],
                        'read_time'  =>  [
                            'label' => esc_html__( 'Read Time', 'blog-postx' )
                        ],
                        'comments'    =>  [
                            'label' => esc_html__( 'Comments', 'blog-postx' )
                        ]
                    ],
                    'visibility'    =>  true
                ],
                'single_block_reorder'  =>  [
                    'label' =>  esc_html__( 'Block Re-order', 'blog-postx' ),
                    'description'   =>  esc_html__( 'Reordering category in layout 1 will have reflect no changes.', 'blog-postx' ),
                    'fields'    =>  [
                        'title'    =>  [
                            'label' => esc_html__( 'Title', 'blog-postx' )
                        ],
                        'category'  =>  [
                            'label' => esc_html__( 'Category', 'blog-postx' )
                        ],
                        'meta'  =>  [
                            'label' => esc_html__( 'Meta', 'blog-postx' )
                        ]
                    ],
                    'visibility'    =>  true
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_item_sortable() Method


        /**
         * Get all number controls
         * 
         * @since 1.0.0
         */
        public function get_number( $id = '' ) {
            $default = [
                'unit'  =>  'px',
                'input_attrs'   =>  $this->get_input_attrs(),
                'responsive'    =>  true,
                'transport' =>  'postMessage'
            ];
            $control_array = [
                'site_logo_width'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo Width (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  400,
                        'min'   =>  100
                    ])
                ]),
                'search_icon_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Icon Size (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([])
                ]),
                'header_custom_button_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([]),
                ]),
                'theme_mode_icon_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Icon Size', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([])
                ]),
                'main_banner_border_radius'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                ]),
                'carousel_section_border_radius'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'responsive'    =>  false
                ]),
                'category_collection_number_of_columns' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'No. of columns', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  5,
                        'min'   =>  1
                    ])
                ]),
                'archive_post_column'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'No. of columns', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 4,
                        'min'   => 1
                    ])
                ]),
                'archive_section_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'responsive'    =>  false,
                ]),
                'single_page_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'responsive'    =>  false,
                ]),
                'page_border_radius'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'responsive'    =>  false,
                ]),
                'bottom_footer_logo_width'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo Width (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  400
                    ])
                ]),
                'category_collection_image_radius'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Border radius', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([]),
                    'responsive'    =>  true
                ]),
                /* Header Builder row controls */
                'header_first_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'header_second_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'header_third_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                /* Footer Builder row controls */
                'footer_first_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'footer_second_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'footer_third_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'ticker_news_border_radius'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_number() Method

        /**
         * Get all section heading controls
         * 
         * @since 1.0.0
         */
        public function get_section_heading( $id = '' ) {
            $default = [
                'bottom_separator'  =>  true
            ];
            $control_array = [
                'header_sub_menu_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Sub Menu', 'blog-postx' ),
                ]),
                'header_main_menu_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Main Menu', 'blog-postx' ),
                ]),
                'typography_preset_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography Preset', 'blog-postx' )
                ]),
                'heading_typographies'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Headings', 'blog-postx' )
                ]),
                'disable_admin_notices_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Admin Settings', 'blog-postx' )
                ]),
                'website_layout_header' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Website Layout', 'blog-postx' )
                ]),
                'block_title_section_heading'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Block Title', 'blog-postx' )
                ]),
                'site_background_animation_settings_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Animation Settings', 'blog-postx' ),
                ]),
                'theme_colors_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Theme Colors', 'blog-postx' )
                ]),
                'theme_presets_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Presets', 'blog-postx' )
                ]),
                'post_format_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Formats', 'blog-postx' )
                ]),
                'post_meta_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Meta', 'blog-postx' )
                ]),
                'footer_social_icons_design_options_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Style Options', 'blog-postx' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_heading() Method

        /**
         * Get all redirect controls
         * 
         * @since 1.0.0
         */
        public function get_redirect_control( $id = '' ) {

            $control_array = [
                'canvas_menu_redirects' =>  [
                    'label' => esc_html__( 'Widgets', 'blog-postx' ),
                    'choices'     => [
                        'canvas-menu-sidebar' => [
                            'type'  => 'section',
                            'id'    => 'sidebar-widgets-canvas-menu-sidebar',
                            'label' => esc_html__( 'Manage canvas menu widget', 'blog-postx' )
                        ]
                    ]
                ],
                'global_button_redirect'    =>  [
                    'choices'     => [
                        'canvas-menu-sidebar' => [
                            'type'  => 'control',
                            'id'    => 'archive_post_layout',
                            'label' => esc_html__( 'Head to Archive', 'blog-postx' )
                        ]
                    ]
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_redirect_control() Method

        /**
         * Get all radio image controls
         * 
         * @since 1.0.0
         */
        public function get_radio_image( $id = '' ) {
            $theme_directory = get_template_directory_uri();
            $control_array = [
                'website_layout'  =>  [
                    'choices'  => [
                        'boxed--layout' => [
                            'label' => esc_html__( 'Boxed', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout' => [
                            'label' => esc_html__( 'Full Width', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ],
                    'transport' =>  'postMessage'
                ],
                'archive_post_layout' =>  [
                   'label' =>  esc_html__( 'Archive Layout', 'blog-postx' ),
                   'choices'  => [
                       'grid' => [
                           'label' => esc_html__( 'Grid', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/archive-grid.png'
                        ],
                       'block-two' => [
                           'label' => esc_html__( 'Block 2', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/archive-list.png'
                        ],
                    ],
                    'bottom_separator'  =>  true
                ],
                'archive_sidebar_layout'  =>  [
                   'label' =>  esc_html__( 'Sidebar Layout', 'blog-postx' ),
                   'choices'  => [
                       'right-sidebar' => [
                           'label' => esc_html__( 'Right Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                       ],
                       'left-sidebar' => [
                           'label' => esc_html__( 'Left Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                       ],
                       'both-sidebar' => [
                           'label' => esc_html__( 'Both Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                       ],
                       'no-sidebar' => [
                           'label' => esc_html__( 'No Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                       ]
                    ],
               ],   
                'single_post_layout'  =>  [
                   'label' =>  esc_html__( 'Single Layout', 'blog-postx' ),
                   'choices'  => [
                       'layout-six' => [
                           'label' => esc_html__( 'Layout 1', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/single-six.png'
                       ],
                       'layout-seven' => [
                           'label' => esc_html__( 'Layout 2', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/single-seven.png'
                       ]
                    ],
                    'bottom_separator'  =>  true
                ],
                'single_sidebar_layout'   =>  [
                    'label' =>  esc_html__( 'Sidebar Layout', 'blog-postx' ),
                    'choices'  => [
                        'right-sidebar' => [
                            'label' => esc_html__( 'Right Sidebar', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                        ],
                        'left-sidebar' => [
                            'label' => esc_html__( 'Left Sidebar', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                        ],
                        'both-sidebar' => [
                            'label' => esc_html__( 'Both Sidebar', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                        ],
                        'no-sidebar' => [
                            'label' => esc_html__( 'No Sidebar', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                        ]
                    ]
                ],
                'page_settings_sidebar_layout'    =>  [
                   'label' =>  esc_html__( 'Sidebar Layout', 'blog-postx' ),
                   'choices'  => [
                       'right-sidebar' => [
                           'label' => esc_html__( 'Right Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                       ],
                       'left-sidebar' => [
                           'label' => esc_html__( 'Left Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                       ],
                       'both-sidebar' => [
                           'label' => esc_html__( 'Both Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                       ],
                       'no-sidebar' => [
                           'label' => esc_html__( 'No Sidebar', 'blog-postx' ),
                           'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                       ]
                    ]
                ],
                'header_builder_section_width'  =>  [
                    'label' => esc_html__( 'Section Width', 'blog-postx' ),
                    'choices' => [
                        'boxed--layout' =>  [
                            'label' => esc_html__('Boxed', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout'    =>  [
                            'label' => esc_html__('Full Width', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ],
                    'transport' =>  'postMessage'
                ],
                'footer_builder_section_width'  =>  [
                    'label' => esc_html__( 'Section Width', 'blog-postx' ),
                    'choices' => [
                        'boxed--layout' =>  [
                            'label' => esc_html__('Boxed', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout'    =>  [
                            'label' => esc_html__('Full Width', 'blog-postx' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ],
                    'transport' =>  'postMessage'
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_radio_image() Method

        /**
         * Get all icon picker controls
         * 
         * @since 1.0.0
         */
        public function get_icon_picker( $id = '' ) {
            $default = [
                'include_media' =>  true
            ];

            $control_array = [
                'theme_mode_dark_icon'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Choose Dark Icon', 'blog-postx' ),
                    'include_media' =>  false,
                    'transport' =>  'postMessage'
                ]),
                'theme_mode_light_icon'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Choose Light Icon', 'blog-postx' ),
                    'include_media' =>  false,
                    'transport' =>  'postMessage'
                ]),
                'standard_post_format_icon_picker'    =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Standard', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
                'audio_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Audio', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
                'gallery_post_format_icon_picker' =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Gallery', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
                'image_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Image', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
                'quote_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Quote', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
                'video_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Video', 'blog-postx' ),
                   'transport' =>  'postMessage'
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_icon_picker() Method

        /**
         * Get all text controls
         * 
         * @since 1.0.0
         */
        public function get_text( $id = '' ) {
            $default = [
                'label' =>  esc_html__( 'Button Label', 'blog-postx' ),
                'type'  =>  'text',
                'transport' =>  'postMessage'
            ];

            $control_array = [
                'custom_button_label' =>  $this->get_params( $default, []),
                'stt_text'  =>  $this->get_params( $default, []),
                'you_may_have_missed_title'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Section title', 'blog-postx' )
                ]),
                'single_post_related_posts_title'   =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Related articles title', 'blog-postx' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_text() Method

        /**
         * Get all select controls
         * 
         * @since 1.0.0
         */
        public function get_select( $id = '' ) {
            $default = [
                'type'  =>  'select',
            ];

            $control_array = [
                'site_title_tag_for_frontpage'    =>  $this->get_params( $default, [
                    'label'   =>  esc_html__( 'Site Title Tag (For Frontpage)', 'blog-postx' ),
                    'choices'   =>  apply_filters( 'blog_postx_get_title_tags_array_filter', [] ),
                    'priority'  =>  30
                ]),
                'site_title_tag_for_innerpage'    =>  $this->get_params( $default, [
                    'label'   =>  esc_html__( 'Site Title Tag (For Innerpage)', 'blog-postx' ),
                    'choices'   =>  apply_filters( 'blog_postx_get_title_tags_array_filter', [] ),
                    'priority'  =>  30
                ]),
                'header_menu_hover_effect'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover Effect', 'blog-postx' ),
                    'choices'   =>  [
                        'none'  =>  esc_html__( 'None', 'blog-postx' ),
                        'one'  =>  esc_html__( 'Effect 1', 'blog-postx' ),
                        'two'  =>  esc_html__( 'Effect 2', 'blog-postx' ),
                        'three'  =>  esc_html__( 'Effect 3', 'blog-postx' ),
                        'four'  =>  esc_html__( 'Effect 4', 'blog-postx' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'footer_menu_hover_effect'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover Effect', 'blog-postx' ),
                    'choices'   =>  [
                        'none'  =>  esc_html__( 'None', 'blog-postx' ),
                        'one'  =>  esc_html__( 'Effect 1', 'blog-postx' ),
                        'two'  =>  esc_html__( 'Effect 2', 'blog-postx' ),
                        'three'  =>  esc_html__( 'Effect 3', 'blog-postx' ),
                        'four'  =>  esc_html__( 'Effect 4', 'blog-postx' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'web_stories_orderby' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Order by', 'blog-postx' ),
                    'choices'   =>  [
                        'asc-name'  =>  esc_html__( 'Ascending Name', 'blog-postx' ),
                        'asc-count'  =>  esc_html__( 'Ascending Count', 'blog-postx' ),
                        'desc-name'  =>  esc_html__( 'Descending Name', 'blog-postx' ),
                        'desc-count'  =>  esc_html__( 'Descending Count', 'blog-postx' )
                    ],
                ]),
                'ticker_news_posts_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args()
                ]),
                'main_banner_posts_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args()
                ]),
                'main_banner_trailing_posts_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args()
                ]),
                'main_banner_image_sizes' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'carousel_posts_order' =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args(),
                ]),
                'carousel_image_sizes'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'category_collection_orderby' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Order by', 'blog-postx' ),
                    'choices'   =>  [
                        'asc-name'  =>  esc_html__( 'Ascending Name', 'blog-postx' ),
                        'asc-count'  =>  esc_html__( 'Ascending Count', 'blog-postx' ),
                        'desc-name'  =>  esc_html__( 'Descending Name', 'blog-postx' ),
                        'desc-count'  =>  esc_html__( 'Descending Count', 'blog-postx' )
                    ],
                ]),
                'category_collection_image_size'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'category_collection_hover_effects'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover effects', 'blog-postx' ),
                    'choices'   =>  [
                        'none'   =>  esc_html__( 'None', 'blog-postx' ),
                        'one'   =>  esc_html__( 'Effect 1', 'blog-postx' ),
                    ],
                    'transport' =>  'postMessage'
                ]),
                'archive_image_size'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'archive_pagination_type' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Pagination Type', 'blog-postx' ),
                    'choices'   =>  apply_filters( 'blog_postx_get_pagination_type_array_filter', [
                        'default'   => esc_html__( 'Default', 'blog-postx' ),
                        'number'    => esc_html__( 'Number', 'blog-postx' )
                    ]),
                    'transport' =>  'postMessage'
                ]),
                'single_image_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'page_image_size' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'you_may_have_missed_posts_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args(),
                ]),
                'you_may_have_missed_image_sizes' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer(),
                ]),
                'bottom_footer_header_or_custom'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo From', 'blog-postx' ),
                    'choices'   =>  [
                        'header'  =>  esc_html__( 'Default Site Logo', 'blog-postx' ),
                        'custom'  =>  esc_html__( 'Custom', 'blog-postx' )
                    ],
                ]),
                'site_date_format'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Date format', 'blog-postx' ),
                    'description' => esc_html__( 'Date format applied to single and archive pages.', 'blog-postx' ),
                    'choices'   => [
                        'theme_format'  => esc_html__( 'Default by theme', 'blog-postx' ),
                        'default'   => esc_html__( 'Wordpress default date', 'blog-postx' )
                    ]
                ]),
                'post_title_hover_effects'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Post title hover effects', 'blog-postx' ),
                    'description' => esc_html__( 'Applied to post titles listed in archive pages.', 'blog-postx' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blog-postx' ),
                        'eight'  => esc_html__( 'Effect One', 'blog-postx' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'site_image_hover_effects'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Image hover effects', 'blog-postx' ),
                    'description' => esc_html__( 'Applied to post thumbanails listed in archive pages.', 'blog-postx' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blog-postx' ),
                        'five'  => esc_html__( 'Effect One', 'blog-postx' ) 
                    ],
                    'transport' =>  'postMessage'
                ]),
                'cursor_animation'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Cursor animation', 'blog-postx' ),
                    'description' => esc_html__( 'Applied to mouse pointer.', 'blog-postx' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blog-postx' ),
                        'one'  => esc_html__( 'Animation 1', 'blog-postx' )
                    ]
                ]),
                'site_breadcrumb_type'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Breadcrumb type', 'blog-postx' ),
                    'description' => esc_html__( 'If you use other than "default" one you will need to install and activate respective plugins Breadcrumb NavXT, Yoast SEO and Rank Math SEO', 'blog-postx' ),
                    'choices'   => [
                        'default' => esc_html__( 'Default', 'blog-postx' ),
                        'bcn'  => esc_html__( 'NavXT', 'blog-postx' ),
                        'yoast'  => esc_html__( 'Yoast SEO', 'blog-postx' ),
                        'rankmath'  => esc_html__( 'Rank Math', 'blog-postx' )
                    ]
                ]),
                'custom_button_animation_type'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Animation Type', 'blog-postx' ),
                    'choices'   => [
                        'none'  => esc_html__( 'None', 'blog-postx' ),
                        'one'   => esc_html__( 'Effect one', 'blog-postx' ),
                        'two'   => esc_html__( 'Effect Two', 'blog-postx' ),  
                        'three' => esc_html__( 'Effect Three', 'blog-postx' ),  
                        'four'  => esc_html__( 'Effect Four', 'blog-postx' ),  
                        'five'  => esc_html__( 'Effect Five', 'blog-postx' )  
                    ],
                    'transport' =>  'postMessage'
                ]),
                'site_background_animation'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Background animation', 'blog-postx' ),
                    'choices'	=>	[
                        'none'	=>	esc_html__( 'None', 'blog-postx' ),
                        'three'	=>	esc_html__( 'Animation 3', 'blog-postx' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'sticky_posts_order'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Order by', 'blog-postx' ),
                    'choices'   =>  blog_postx_post_order_args()
                ]),
                'web_stories_image_sizes'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Sizes', 'blog-postx' ),
                    'choices'   =>  blog_postx_get_image_sizes_option_array_for_customizer()
                ]),
                'header_secondary_menu_hover_effect'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Hover Effects', 'blog-postx' ),
                    'choices'   =>  [
                        'none'  =>  esc_html__( 'None', 'blog-postx' ),
                        'one'   =>  esc_html__( 'Effect 1', 'blog-postx' ),
                        'two'   =>  esc_html__( 'Effect 2', 'blog-postx' ),
                        'three' =>  esc_html__( 'Effect 3', 'blog-postx' ),
                        'four'  =>  esc_html__( 'Effect 4', 'blog-postx' )
                    ]
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_select() Method

        /**
         * Get all preset controls
         * 
         * @since 1.0.0
         */
        public function get_preset_colors( $id = '' ) {
            $default = [
                'transport' =>  'postMessage'
            ];

            $control_array = [
                'solid_color_preset'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Solid Presets', 'blog-postx' ),
                    'description'   =>  esc_html__( 'Set color presets', 'blog-postx' ),
                    'bottom_separator'  =>  true
                ]),
                'gradient_color_preset'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Gradient Presets', 'blog-postx' ),
                    'description'   =>  esc_html__( 'Set gradient presets', 'blog-postx' ),
                    'blend' =>  'gradient'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_preset_colors() Method

        /**
         * Get all color controls
         * 
         * @since 1.0.0
         */
        public function get_colors( $id = '' ) {
            $default = [
                'involve'   =>  [ 'solid' ],
                'hover' =>  false,
                'transport' =>  'postMessage'
            ];
            
            $control_array = [
                'site_background_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Background Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid', 'gradient' ],
                    'description'   =>  esc_html__( 'If background image is set, this will act as overlay.', 'blog-postx' )
                ]),
                'header_menu_color'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Text Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true,
                ]),
                'header_sub_menu_color' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Text Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true,
                ]),
                'search_icon_color'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Icon Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'theme_mode_dark_icon_color'  => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Dark Icon Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'theme_mode_light_icon_color' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Light Icon Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'canvas_menu_icon_color'   => $this->get_params( $default, [
                    'label'     => esc_html__( 'Canvas Menu Icon Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'stt_color_group' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Icon Text', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'pagination_button_text_color'   => $this->get_params( $default, [
                    'label'     => esc_html__( 'Button Text Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'header_custom_button_background_color_group'   => $this->get_params( $default, [
                    'label' => esc_html__( 'Background Color', 'blog-postx' ),
                    'involve'   =>  [ 'solid', 'gradient' ], 
                    'hover' =>  true
                ]),
                'pagination_button_background_color'   => $this->get_params( $default, [
                    'label' => esc_html__( 'Button Background Color', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'archive_pagination_type' )->value(), [ 'number' ] ) );
                    },
                    'involve'   =>  [ 'solid', 'gradient' ],
                    'hover' =>  true
                ]),
                'header_builder_background' => $this->get_params( $default, [
                   'label' => esc_html__( 'Background', 'blog-postx' ),
                   'involve' => [ 'solid', 'gradient', 'image' ]
                ]),
                /* Date / Time */
                'date_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Date Color', 'blog-postx' ),
                   'involve' => [ 'solid' ]
                ]),
                'time_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Time Color', 'blog-postx' ),
                   'involve' => [ 'solid' ]
                ]),
                'date_time_separator_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Separator Color', 'blog-postx' ),
                   'involve' => [ 'solid', 'gradient' ]
                ]),
                'mobile_canvas_icon_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Icon Color', 'blog-postx' ),
                   'involve' => [ 'solid' ],
                   'hover'  =>  true,
                ]),
                'footer_menu_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Color', 'blog-postx' ),
                   'involve' => [ 'solid' ],
                   'hover'  =>  true
                ]),
                'header_secondary_menu_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Color', 'blog-postx' )
                ])
            ];
            $totalCats = get_categories();
            if( $totalCats ) :
                $totalCats_count = count( $totalCats );
                foreach( $totalCats as $key => $singleCat ) :
                    $cat_color_id = 'category_' . absint( $singleCat->term_id ) . '_color';
                    $control_array[ 'category_top_spacing_' . $key ] = [];
                    $control_array[ $cat_color_id ] = [
                        'label' => esc_html__( 'Text Color', 'blog-postx' ),
                        'involve'   =>  [ 'solid' ],
                        'hover' =>  true,
                        'transport' =>  'postMessage'
                    ];

                    $background_id = 'category_background_' . absint( $singleCat->term_id ) . '_color';
                    $control_array[ $background_id ] = [
                        'label' => esc_html__( 'Background', 'blog-postx' ),
                        'involve'   =>  [ 'solid', 'gradient' ],
                        'hover' =>  true,
                        'bottom_separator'  =>  true,
                        'transport' =>  'postMessage'
                    ];
                    if( $totalCats_count != ( $key + 1 ) ) $control_array[ 'category_bottom_spacing_' . $key ] = [];
                endforeach;
            endif;

            $totalTags = get_tags();
            $tag_priority = 10;
            if( $totalTags ) :
                $totalTags_count = count( $totalTags );
                foreach( $totalTags as $key => $singleTag ) :
                    $tag_color_id = 'tag_' . absint( $singleTag->term_id ) . '_color';
                    $control_array[ 'tag_top_spacing_' . $key ] = [];
                    $control_array += [ $tag_color_id =>  [
                        'label' => esc_html__( 'Text Color', 'blog-postx' ),
                        'involve'   =>  [ 'solid' ],
                        'hover' =>  true,
                        'transport' =>  'postMessage'
                    ]];

                    $background_id = 'tag_background_' . absint( $singleTag->term_id ) . '_color';
                    $control_array += [ $background_id   =>  [
                        'label' => esc_html__( 'Background', 'blog-postx' ),
                        'involve'   =>  [ 'solid', 'gradient' ],
                        'hover' =>  true,
                        'bottom_separator'  =>  true,
                        'transport' =>  'postMessage'
                    ]];
                    $tag_priority += 10;
                    if( $totalTags_count != ( $key + 1 ) ) $control_array[ 'tag_bottom_spacing_' . $key ] = [];
                endforeach;
            endif;
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_colors() Method

        /**
         * Get all Media controls
         * 
         * @since 1.0.0
         */
        public function get_media_control( $id = '' ) {
            $default = [
                'mime_type' => 'image',
            ];

            $control_array = [
                'bottom_footer_logo_option'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Footer Logo', 'blog-postx' ),
                    'description' => esc_html__( 'Upload image for bottom footer', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( $control->manager->get_setting( 'bottom_footer_header_or_custom' )->value() == 'custom' );
                    },
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_media_control() Method

        /**
         * Get all wordpress default color controls
         * 
         * @since 1.0.0
         */
        public function get_predefined_colors( $id = '' ) {
            $default = [
                'priority'  =>  20,
                'transport' =>  'postMessage'
            ];

            $control_array = [
                'site_title_hover_textcolor'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Title Hover Color', 'blog-postx' )
                ]),
                'site_description_color'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Description Color', 'blog-postx' )
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_predefined_colors() Method

        /**
         * Get all custom repeater controls
         * 
         * @since 1.0.0
         */
        public function get_custom_repeaters( $id = '' ) {
            $default = [];
            $control_array = [
                'social_icons' =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Social Icons', 'blog-postx' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blog-postx' ),
                    'row_label'     => 'inherit-icon_class',
                    'add_new_label' => esc_html__( 'Add New Icon', 'blog-postx' ),
                    'fields'        => [
                        'icon_class'   => array(
                            'type'          =>  'fontawesome-icon-picker',
                            'label'         =>  esc_html__( 'Social Icon', 'blog-postx' ),
                            'description'   =>  esc_html__( 'Select from dropdown.', 'blog-postx' ),
                            'default'       =>  esc_attr( 'fa-brands fa-instagram' ),
                            'families'      =>  'social'
                        ),
                        'icon_url'  => array(
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL for icon', 'blog-postx' ),
                            'default'   => ''
                        ),
                        'item_option'             => 'show'
                    ]
                ]),
                'footer_social_icons' =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Social Icons', 'blog-postx' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blog-postx' ),
                    'row_label'     => 'inherit-icon_class',
                    'add_new_label' => esc_html__( 'Add New Icon', 'blog-postx' ),
                    'fields'        => [
                        'icon_class'   => array(
                            'type'          =>  'fontawesome-icon-picker',
                            'label'         =>  esc_html__( 'Social Icon', 'blog-postx' ),
                            'description'   =>  esc_html__( 'Select from dropdown.', 'blog-postx' ),
                            'default'       =>  esc_attr( 'fa-brands fa-instagram' ),
                            'families'      =>  'social'
                        ),
                        'icon_count'  => array(
                            'type'      => 'text',
                            'label'     => esc_html__( 'Count', 'blog-postx' ),
                            'default'   => '1K'
                        ),
                        'icon_label'  => array(
                            'type'      => 'text',
                            'label'     => esc_html__( 'Label', 'blog-postx' )
                        ),
                        'icon_url'  => array(
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL for icon', 'blog-postx' ),
                            'default'   => ''
                        ),
                        'item_option'             => 'show'
                    ]
                ]),
                'advertisement_repeater'  =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Advertisements', 'blog-postx' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blog-postx' ),
                    'row_label'     => esc_html__( 'Advertisement', 'blog-postx' ),
                    'add_new_label' => esc_html__( 'Add New Advertisement', 'blog-postx' ),
                    'fields'        => [
                        'item_code'   => [
                            'type'          => 'number',
                            'label'         => esc_html__( 'Item Code', 'blog-postx' ),
                            'default'       => 0
                        ],
                        'item_image'   => [
                            'type'          => 'image',
                            'label'         => esc_html__( 'Image', 'blog-postx' ),
                            'default'       => 0
                        ],
                        'item_url'  => [
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL', 'blog-postx' ),
                            'default'   => ''
                        ],
                        'item_target'   =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Open in', 'blog-postx' ),
                            'default'   =>  '_self',
                            'options'   =>  [
                                '_blank'    =>  esc_html__( 'New tab', 'blog-postx' ),
                                '_self'    =>  esc_html__( 'Same tab', 'blog-postx' )
                            ]
                        ],
                        'item_rel_attribute'    =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Rel', 'blog-postx' ),
                            'default'   =>  'opener',
                            'options'   =>  [
                                'nofollow'  =>  esc_html__( 'No follow', 'blog-postx' ),
                                'noopener'  =>  esc_html__( 'No opener', 'blog-postx' ),
                                'noreferrer'  =>  esc_html__( 'No referrer', 'blog-postx' )
                            ]
                        ],
                        'item_heading'  =>  [
                            'type'  =>  'heading',
                            'label' =>  esc_html__( 'Display Area', 'blog-postx' )
                        ],
                        'item_checkbox_before_post_content' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'Before post content', 'blog-postx' ),  
                            'default'   =>  false
                        ],
                        'item_checkbox_after_post_content' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'After post content', 'blog-postx' ),  
                            'default'   =>  false
                        ],
                        'item_checkbox_random_post_archives' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'Random post archives', 'blog-postx' ),  
                            'default'   =>  false
                        ],
                        'item_alignment'    =>   [
                            'type'  =>  'alignment',
                            'label' =>  esc_html__( 'Ad Alignment', 'blog-postx' ),
                            'default'   =>  'left',
                            'options'   =>  [
                                'left'  =>  esc_html__( 'fa-solid fa-align-left', 'blog-postx' ),
                                'center'  =>  esc_html__( 'fa-solid fa-align-center', 'blog-postx' ),
                                'right'  =>  esc_html__( 'fa-solid fa-align-right', 'blog-postx' )
                            ]
                        ],
                        'item_image_option' =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Image Option', 'blog-postx' ),
                            'default'   =>  'original',
                            'options'   =>  [
                                'full_width'  =>  esc_html__( 'Full Width', 'blog-postx' ),
                                'original'  =>  esc_html__( 'Original', 'blog-postx' )
                            ]
                        ],
                        'item_option' => 'show'
                    ]
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_custom_repeaters() Method

        /**
         * Get all controls rendered using predefined number control
         * 
         * @since 1.0.0
         */
        public function get_custom_number_controls( $id = '' ) {
            $default = [
                'type'  =>  'number',
                'input_attrs'   =>  $this->get_input_attrs([
                    'min'   =>  1
                ]),
            ];

            $control_array = [
                'ticker_news_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  5,
                        'min'   =>  1
                    ]),
                ]),
                'main_banner_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blog-postx' ),
                ]),
                'main_banner_trailing_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blog-postx' ),
                ]),
                'main_banner_image_border_radius'   => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'transport' =>  'postMessage'
                ]),
                'carousel_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blog-postx' ),
                ]),
                'category_collection_number'  => $this->get_params( $default, [
                    'label' => esc_html__( 'Number of category', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  10,
                        'min'   =>  1
                    ])
                ]),
                'single_image_border_radius'  => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 100
                    ]),
                    'transport' =>  'postMessage',
                    'active_callback'   =>  function( $control ) {
                        return ( $control->manager->get_setting( 'single_post_layout' )->value() !== 'layout-seven' );
                    }
                ]),
                'page_image_border_radius' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_no_of_columns' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'No of Columns', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'min'   =>  2,
                        'max'   =>  4
                    ]),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_posts_to_show' => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  4,
                        'min'   =>  1
                    ])
                ]),
                'sortable_advertisement_number' =>  [
                    'label' =>  esc_html__( 'Ad Item code', 'blog-postx' ),
                    'description'   =>  esc_html__( 'Advertisement with the same item code will be sortable through re-order section.', 'blog-postx' ),
                    'full_width'    =>  true,
                    'type'  =>  'number'
                ],
                'sidebar_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  50
                    ]),
                    'transport' =>  'postMessage'
                ]),
                'sidebar_image_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Border Radius (px)', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  50
                    ]),
                    'transport' =>  'postMessage'
                ]),
                'sticky_posts_posts_to_append'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Posts to Append', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs()
                ]),
                'sticky_posts_to_show'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Total Number of Posts', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs()
                ]),
                'footer_social_icons_columns'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Columns', 'blog-postx' ),
                    'description'   =>  esc_html__( 'The effects of this field is only seen in widgets.', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'full_width'    =>  true
                ]),
                'web_stories_no_of_cats_to_show'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'No. of category to show', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  10,
                        'min'   =>  3
                    ]),
                ]),
                'web_stories_max_no_of_inner_stories'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Max no. of inner stories', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                ]),
                'web_stories_image_radius'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Radius', 'blog-postx' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_border_radius'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blog-postx' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'transport' =>  'postMessage'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_Farray );
        }   // End of get_custom_number_controls() Method

        /**
         * Get a list of all url controls
         * 
         * @since 1.0.0
         */
        public function get_url( $id = '' ) {
            $default = [
                'type'  =>  'url',
            ];

            $control_array = [
                'custom_button_redirect_href_link'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Redirect URL', 'blog-postx' ),
                    'description'   =>  esc_html__( 'Add url for the button to redirect', 'blog-postx' ),
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_url() Method

        /**
         * Get all multiselect controls
         * 
         * @since 1.0.0
         */
        public function get_multiselect_controls( $id = '' ) {
            $default = [
                'endpoint'   =>  'extend/get_taxonomy',
                'purpose'   =>  'post',
            ];

            $control_array = [
                // category
                'ticker_news_posts_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'main_banner_posts_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'main_banner_trailing_posts_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'carousel_posts_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'category_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Category to include', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'category_to_exclude' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Category to exclude', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'you_may_have_missed_posts_categories' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'web_stories_categories_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Category to include', 'blog-postx' ),
                    'purpose'   =>  'category',
                    'bottom_separator'  =>  true
                ]),
                // posts
                'ticker_news_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts'
                ]),
                'main_banner_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts',
                    'bottom_separator'  =>  true
                ]),
                'main_banner_trailing_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts',
                    'bottom_separator'  =>  true
                ]),
                'carousel_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts',
                    'bottom_separator'  =>  true
                ]),
                'you_may_have_missed_posts_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts',
                    'bottom_separator'  =>  true
                ]),
                // users
                'sticky_posts_categories' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blog-postx' ),
                    'purpose'   =>  'category'
                ]),
                'sticky_posts_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts to Include', 'blog-postx' ),
                    'endpoint'   =>  'extend/get_posts',
                    'bottom_separator'  =>  true
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_multiselect_controls() Method

        /**
         * Get all reflector controls
         * 
         * @since 1.0.0
         */
        public function get_builder_reflector_controls( $id ) {
            $default = [
                'label' =>  esc_html__( 'Row Widgets', 'blog-postx' )
            ];
            $control_array = [
                /* Header builder reflectors */
                'header_first_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	1,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                'header_second_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	2,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                'header_third_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	3,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                /* Footer builder reflectors */
                'footer_first_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	1,
                    'bottom_separator'  =>  true
                ]),
                'footer_second_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	2,
                    'bottom_separator'  =>  true
                ]),
                'footer_third_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	3,
                    'bottom_separator'  =>  true
                ]),
                /* Responsive Header Builder reflector */
                'mobile_canvas_reflector' => $this->get_params( $default, [
                    'placement'	=>	'responsive-header',
                    'builder'	=>	'responsive_header_builder',
                    'row'	=>	4
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_builder_reflector_controls() Method

        /**
         * Get all responsive radio image  controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_radio_image( $id ) {
            $default = [];
            $theme_directory = get_template_directory_uri();
            $column_layouts = [
                'one' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_one.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 1 ]
                ],
                'two' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_two.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'three' => [
                    'label' => esc_html__( 'Layout Two', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_three.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'five' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_five.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'six' => [
                    'label' => esc_html__( 'Layout Two', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_six.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'thirteen' => [
                    'label' => esc_html__( 'Layout Three', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_thirteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 2 ]
                ],
                'sixteen' => [
                    'label' => esc_html__( 'Layout Three', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_sixteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 3 ]
                ]
            ];

            $footer_column_layouts = [
                'one' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_one.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 1 ]
                ],
                'two' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_two.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'three' => [
                    'label' => esc_html__( 'Layout Two', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_three.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'five' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_five.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'nine' => [
                    'label' => esc_html__( 'Layout One', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_nine.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 4 ]
                ],
                'thirteen' => [
                    'label' => esc_html__( 'Layout Three', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_thirteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 2 ]
                ],
                'sixteen' => [
                    'label' => esc_html__( 'Layout Two', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_sixteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 3 ]
                ],
                'eighteen' => [
                    'label' => esc_html__( 'Layout Two', 'blog-postx' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_eighteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 4 ]
                ]
            ];
            $control_array = [
                /* Header layout row controls */
                'header_first_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'choices'  => $column_layouts
                ],
                'header_second_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'row'   =>  2,
                    'choices'  => $column_layouts
                ],
                'header_third_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'row'   =>  3,
                    'choices'  => $column_layouts
                ],
                /* Footer layout row controls */
                'footer_first_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
                'footer_second_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'row'   =>  2,
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
                'footer_third_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blog-postx' ),
                    'row'   =>  3,
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_responsive_radio_image() Method

        /**
         * Gets all textarea controls
         * 
         * @since 1.0.0
         */
        public function get_textareas( $id = '' ){
            $default = [
                'type'  =>  'textarea'
            ];
            $control_array = [
                'bottom_footer_site_info' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Copyright Text', 'blog-postx' ),
                    'description' => esc_html__( 'Add %year% to retrieve current year.', 'blog-postx' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Gets all responsive radio tab controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_radio_tab( $id = '' ){
            $default = [
                'choices' => [
                    [
                        'value' => 'left',
                        'icon'  =>  'editor-alignleft',
                        'label' =>  esc_html__( 'Left', 'blog-postx' )
                    ],
                    [
                        'value' => 'center',
                        'icon'  =>  'editor-aligncenter',
                        'label' =>  esc_html__( 'Center', 'blog-postx' )
                    ],
                    [
                        'value' => 'right',
                        'icon'  =>  'editor-alignright',
                        'label' =>  esc_html__( 'Right', 'blog-postx' )
                    ]
                ],
                'transport' =>  'postMessage'
            ];
            $control_array = [
                /* Header builder first row */
                'header_first_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_first_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_first_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Header builder second row */
                'header_second_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_second_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_second_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Header builder third row */
                'header_third_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_third_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_third_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Footer builder first row */
                'footer_first_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 4 ] ) );
                    },
                ]),
                /* Footer builder second row */
                'footer_second_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 4 ] ) );
                    },
                ]),
                /* Footer builder third row */
                'footer_third_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blog-postx' ),
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 4 ] ) );
                    },
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all typography preset controls
         * 
         * @since 1.0.0
         */
        public function get_typography_preset_controls( $id = '' ) {

            $control_array = [
                'typography_presets' =>   [
                    'label' =>  esc_html__( 'Typography Preset', 'blog-postx' ),
                    'description'   =>  esc_html__( 'This is the control to use in future projects.', 'blog-postx' ),
                    'transport' =>  'postMessage'
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all preset color controls
         * 
         * @since 1.0.0
         */
        public function get_theme_colors( $id = '' ) {
            $default = [
                'transport' =>  'postMessage'
            ];

            $control_array = [
                // preset colors
                'theme_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Theme Color', 'blog-postx' ),
                    'variable'   => '--blog-postx-global-preset-theme-color'
                ]),
                'gradient_theme_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Gradient Theme Color', 'blog-postx' ),
                    'variable'   => '--blog-postx-global-preset-gradient-theme-color',
                    'involve'   =>  'gradient'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all builder controls
         * 
         * @since 1.0.0
         */
        public function get_builder_controls( $id = '' ) {

            $default = [
            ];

            $control_array = [
                'header_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'header_builder_section_settings',
                    'responsive_builder'	=>	'responsive_header_builder',
                    'widgets'	=>	[
                        'site-logo'	=>	[
                            'label' 	=>	esc_html__( 'Site Logo and Title', 'blog-postx' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'title_tagline'
                        ],
                        'date-time'	=>	[
                            'label' 	=>	esc_html__( 'Date Time', 'blog-postx' ),
                            'icon' 	=>	'clock',
                            'section'	=>	'date_time_section'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blog-postx' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'social_icons_section'
                        ],
                        'search'	=>	[
                            'label' 	=>	esc_html__( 'Search', 'blog-postx' ),
                            'icon' 	=>	'search',
                            'section'	=>	'header_live_search_section'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Primary Menu', 'blog-postx' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'header_menu_options_section'
                        ],
                        'button'	=>	[
                            'label' 	=>	esc_html__( 'Button', 'blog-postx' ),
                            'icon' 	=>	'button',
                            'section'	=>	'custom_button_section'
                        ],
                        'theme-mode'	=>	[
                            'label' 	=>	esc_html__( 'Theme Mode', 'blog-postx' ),
                            'icon' 	=>	'lightbulb',
                            'section'	=>	'theme_mode_section'
                        ],
                        'off-canvas'	=>	[
                            'label' 	=>	esc_html__( 'Off Canvas', 'blog-postx' ),
                            'icon' 	=>	'text-page',
                            'section'	=>	'canvas_menu_section'
                        ],
                        'secondary-menu'	=>	[
                            'label' 	=>	esc_html__( 'Secondary Menu', 'blog-postx' ),
                            'icon' 	=>	'menu-alt2',
                            'section'	=>	'header_secondary_menu_options'
                        ],
                    ]
                ]),
                'footer_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'footer_builder_section_settings',
                    'placement'	=>	'footer',
                    'widgets'	=>	[
                        'logo'	=>	[
                            'label' 	=>	esc_html__( 'Logo', 'blog-postx' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'footer_logo'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blog-postx' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'footer_social_icons_section'
                        ],
                        'copyright'	=>	[
                            'label' 	=>	esc_html__( 'Copyright', 'blog-postx' ),
                            'icon' 	=>	'privacy',
                            'section'	=>	'footer_copyright'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Secondary Menu', 'blog-postx' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'footer_menu_options_section'
                        ],
                        'sidebar-one'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 1', 'blog-postx' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-one'
                        ],
                        'sidebar-two'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 2', 'blog-postx' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-two'
                        ],
                        'sidebar-three'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 3', 'blog-postx' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-three'
                        ],
                        'sidebar-four'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 4', 'blog-postx' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-four'
                        ],
                        'scroll-to-top'	=>	[
                            'label' 	=>	esc_html__( 'Scroll to Top', 'blog-postx' ),
                            'icon' 	=>	'arrow-up-alt2',
                            'section'	=>	'stt_options_section'
                        ],
                    ]
                ])
            ];

            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all responsive builder controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_builder_controls( $id = '' ) {

            $default = [
            ];

            $control_array = [
                'responsive_header_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'header_builder_section_settings',
                    'placement'	=>	'header',
                    'responsive_canvas_id'	=>	'responsive-canvas',
                    'responsive_section'	=>	'mobile_canvas_section',
                    'widgets'	=>	[
                        'site-logo'	=>	[
                            'label' 	=>	esc_html__( 'Site Logo and Title', 'blog-postx' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'title_tagline'
                        ],
                        'date-time'	=>	[
                            'label' 	=>	esc_html__( 'Date Time', 'blog-postx' ),
                            'icon' 	=>	'clock',
                            'section'	=>	'date_time_section'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blog-postx' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'social_icons_section'
                        ],
                        'search'	=>	[
                            'label' 	=>	esc_html__( 'Search', 'blog-postx' ),
                            'icon' 	=>	'search',
                            'section'	=>	'header_live_search_section'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Primary Menu', 'blog-postx' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'header_menu_options_section'
                        ],
                        'secondary-menu'	=>	[
                            'label' 	=>	esc_html__( 'Secondary Menu', 'blog-postx' ),
                            'icon' 	=>	'menu-alt2',
                            'section'	=>	'header_secondary_menu_options'
                        ],
                        'button'	=>	[
                            'label' 	=>	esc_html__( 'Button', 'blog-postx' ),
                            'icon' 	=>	'button',
                            'section'	=>	'custom_button_section'
                        ],
                        'theme-mode'	=>	[
                            'label' 	=>	esc_html__( 'Theme Mode', 'blog-postx' ),
                            'icon' 	=>	'lightbulb',
                            'section'	=>	'theme_mode_section'
                        ],
                        'off-canvas'	=>	[
                            'label' 	=>	esc_html__( 'Off Canvas', 'blog-postx' ),
                            'icon' 	=>	'text-page',
                            'section'	=>	'canvas_menu_section'
                        ],
                        'toggle-button'	=>	[
                            'label' 	=>	esc_html__( 'Toggle Button', 'blog-postx' ),
                            'icon' 	=>	'ellipsis',
                            'section'	=>	'mobile_canvas_section'
                        ]
                    ]
                ])
            ];

            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all term colors controls
         * 
         * @since 1.0.0
         */
        public function get_term_colors( $id = '' ) {
            $control_array = [
                'category_colors' => [
                    'bottom_separator'  =>  true,
                    'transport' =>  'postMessage',
                    'terms'  =>  get_categories([ 'fields' => 'id=>name', 'hide_empty' => true ])
                ],
                'tag_colors' => [
                    'bottom_separator'  =>  true,
                    'transport' =>  'postMessage',
                    'terms'  =>  get_tags([ 'fields' => 'id=>name', 'hide_empty' => true ])
                ]
            ];

            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Get controls parameters necessary in add_control function
         * 
         * @since 1.0.0
         */
        public function get_params( $default = [], $append = [] ) {
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
            return $default;
        }

        /**
         * Get input_attrs array
         * 
         * @since 1.0.0
         */
        public function get_input_attrs( $append = [] ) {
            $default = [
                'max'   =>  100,
                'min'   =>  0,
                'step'   =>  1,
                'reset'   =>  true
            ];
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
            return $default;
        }
    }
 endif;