/* global wp, jQuery */
/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *  
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	const themeCalls = {
		blogPostXGenerateTypoCss: function( selector, value, isVariable ) {
			const { preset, font_family, font_weight, text_transform, text_decoration, font_size, line_height, letter_spacing } = value
			var cssCode = ''
			if( isVariable ) {
				cssCode += 'body.blog-postx-variables {\n'
			} else {
				cssCode = selector + '{\n'
			}
			if( font_family ) cssCode += `${( isVariable ? `${ selector }-family` : 'font-family' )}: ${ this.blogPostXGetTypographyFormat( preset, font_family.value, '-family' ) };\n`

			if( font_weight ) cssCode += `${( isVariable ? `${ selector }-weight` : 'font-weight' )}: ${ this.blogPostXGetTypographyFormat( preset, font_weight.value, '-weight' ) };\n${( isVariable ? `${ selector }-style` : 'font-style' )}: ${ this.blogPostXGetTypographyFormat( preset, font_weight.variant, '-style' ) };\n`
			
			if( text_transform ) cssCode += `${( isVariable ? `${ selector }-texttransform` : 'text-transform' )}: ${ this.blogPostXGetTypographyFormat( preset, text_transform, '-texttransform' )};\n`

			if( text_decoration ) cssCode += `${( isVariable ? `${ selector }-textdecoration` : 'text-decoration' )}: ${ this.blogPostXGetTypographyFormat( preset, text_decoration, '-textdecoration' )};\n`

			if( font_size.desktop >= 0 ) cssCode += `${( isVariable ? `${ selector }-size` : 'font-size' )}: ${ this.blogPostXGetTypographyFormat( preset, font_size.desktop, '-size' ) };\n`

			if( line_height.desktop >= 0 ) cssCode += `${( isVariable ? `${ selector }-lineheight` : 'line-height' )}: ${ this.blogPostXGetTypographyFormat( preset, line_height.desktop, '-lineheight' ) };\n`

			if( letter_spacing.desktop >= 0 ) cssCode += `${( isVariable ? `${ selector }-letterspacing` : 'letter-spacing' )}: ${ this.blogPostXGetTypographyFormat( preset, letter_spacing.desktop, '-letterspacing' ) };\n`
			if( ! isVariable ) cssCode += '}'

			if( ! isVariable ) cssCode += `@media(max-width: 940px) {\n${ isVariable ? 'body.blog-postx-variables ' : `${ selector } ` } {\n`
			if( line_height.tablet >= 0 ) cssCode += `${( isVariable ? `${ selector }-lineheight-tab` : 'line-height' )}: ${ this.blogPostXGetTypographyFormat( preset, line_height.tablet, '-lineheight-tab' ) };\n`
			if( letter_spacing.tablet >= 0 ) cssCode += `${( isVariable ? `${ selector }-letterspacing-tab` : 'letter-spacing' )}: ${ this.blogPostXGetTypographyFormat( preset, letter_spacing.tablet, '-letterspacing-tab' ) };\n`
			if( font_size.tablet >= 0 ) cssCode += `${( isVariable ? `${ selector }-size-tab` : 'font-size' )}: ${ this.blogPostXGetTypographyFormat( preset, font_size.tablet, '-size-tab' ) };\n`
			if( ! isVariable ) cssCode += '}}'
			
			if( ! isVariable ) cssCode += `@media(max-width: 610px) {\n${ isVariable ? 'body.blog-postx-variables ' : `${ selector } ` } {\n`
			if( line_height.smartphone >= 0 ) cssCode += `${( isVariable ? `${ selector }-lineheight-mobile` : 'line-height' )}: ${ this.blogPostXGetTypographyFormat( preset, line_height.smartphone, '-lineheight-mobile' ) };\n`
			if( letter_spacing.smartphone >= 0 ) cssCode += `${( isVariable ? `${ selector }-letterspacing-mobile` : 'letter-spacing' )}: ${ this.blogPostXGetTypographyFormat( preset, letter_spacing.smartphone, '-letterspacing-mobile' ) };\n`
			if( font_size.smartphone >= 0 ) cssCode += `${( isVariable ? `${ selector }-size-mobile` : 'font-size' )}: ${ this.blogPostXGetTypographyFormat( preset, font_size.smartphone, '-size-mobile' ) };\n`
			if( ! isVariable ) cssCode += '}}'

			if( isVariable ) cssCode += '}'

			return cssCode
		},
		blogPostXGenerateStyleTag: function( code, id ) {
			if( code ) {
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id ).html( code )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + code + '</style>' )
				}
			} else {
				$( "head #" + id ).remove()
			}
		},
		blogPostXGetTypographyFormat: function( preset, value, suffix ) {
			if( preset === '-1' ) {
				let unitsArray = [ '-size', '-lineheight', '-letterspacing', '-lineheight-tab', '-letterspacing-tab', '-size-tab', '-lineheight-mobile', '-letterspacing-mobile', '-size-mobile' ]
				return ( unitsArray.includes( suffix ) ) ? value + 'px' : value;
			} else {
				let variable = 'var(--blog-postx-global-preset-typography-' + ( parseInt( preset ) + 1 ) + '-font' + suffix + ')';
				return variable
			}
		}
	}

	// typography preset
	wp.customize( 'typography_presets', function( value ) {
		value.bind( function(to) {
			const { typographies } = to
			typographies.forEach(( typography, index ) => {
				ajaxFunctions.typoFontsEnqueue( typography )
				let variable = '--blog-postx-global-preset-typography-',
					count = index + 1;
               	variable += count + '-font';
				cssCode = themeCalls.blogPostXGenerateTypoCss( variable, typography, true )
				themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-typography-preset-' + count )
			})
		});
	});

	// theme color bind changes
	wp.customize( 'theme_color', function( value ) {
		value.bind( function( to ) {
			helperFunctions.generateStyle(to, 'theme-color-style', '--blog-postx-global-preset-theme-color')
		});
	});

	// gradient theme color bind changes
	wp.customize( 'gradient_theme_color', function( value ) {
		value.bind( function( to ) {
			helperFunctions.generateStyle(to, 'theme-preset-gradient-color-1-style', '--blog-postx-global-preset-gradient-theme-color')
		});
	});

	// solid color presets
	wp.customize( 'solid_color_preset', function( value ) {
		value.bind( function( to ) {
			const { active_palette: activePaletteIndex, color_palettes: colorPalettes } = to
			const ACTIVEPALETTE = colorPalettes[ activePaletteIndex ]
			helperFunctions.bulkGenerateStyle( ACTIVEPALETTE, 'blog-postx-solid-presets', '--blog-postx-global-preset-color-' )
		});
	});

	// gradient color presets
	wp.customize( 'gradient_color_preset', function( value ) {
		value.bind( function( to ) {
			const { active_palette: activePaletteIndex, color_palettes: colorPalettes } = to
			const ACTIVEPALETTE = colorPalettes[ activePaletteIndex ]
			helperFunctions.bulkGenerateStyle( ACTIVEPALETTE, 'blog-postx-gradient-presets', '--blog-postx-global-preset-gradient-' )
		});
	});

	// single post related articles title option
	wp.customize( 'single_post_related_posts_title', function( value ) {
		value.bind( function(to) {
			if( $( ".single-related-posts-section-wrap" ).find('.blog-postx-block-title span:not(.divider)').length > 0 ) {
				$( ".single-related-posts-section-wrap" ).find('.blog-postx-block-title span:not(.divider)').text( to )
			} else {
				$( ".single-related-posts-section-wrap .single-related-posts-section" ).prepend('<h2 class="blog-postx-block-title"><span class="divider"></span><span>'+ to +'</span></h2>')
			}
		});
	});

	// blog description
	wp.customize( 'blogdescription_option', function( value ) {
		value.bind(function(to) {
			if( to ) {
				$( '.site-description' ).css( {
					clip: 'auto',
					position: 'relative',
				} );
			} else {
				$( '.site-description' ).css( {
					clip: 'rect(1px, 1px, 1px, 1px)',
					position: 'absolute',
				} );
			}
		})
	});

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			var cssCode = '.blog-postx-light-mode .site-header .site-title a { color: '+ to +' }'
			themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-site-title' )
		} );
	});

	// site title hover color
	wp.customize( 'site_title_hover_textcolor', function( value ) {
		value.bind( function( to ) {
			var cssCode = '.blog-postx-light-mode .site-header .site-title a:hover { color: '+ to +' }'
			themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-site-title-hover' )
		} );
	});

	// site description color
	wp.customize( 'site_description_color', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).css( {
				color: to,
			});
		} );
	});

	// single post related articles title option
	wp.customize( 'stt_text', function( value ) {
		value.bind( function(to) {
			if( $( ".blog-postx-scroll-btn" ).find('.icon-text').length > 0 ) {
				$( ".blog-postx-scroll-btn" ).find('.icon-text').text( to )
			} else {
				$( ".blog-postx-scroll-btn .scroll-top-wrap" ).prepend('<span class="icon-text">'+ to +'</span>')
			}
		});
	});

	// Category Colors
	wp.customize( `category_colors`, function( value ) {
		let previousValue = value.get()
		value.bind( function(to) {
			Object.entries( to ).map(([ catId, colors ]) => {
				let cssCode = '',
					{ color, background } = colors,
					{ initial: cInitial, hover: cHover } = color,
					{ initial: bInitial, hover: bHover } = background,
					{ color: pcolor, background: pbackground } = previousValue[ catId ],
					{ initial: pcInitial, hover: pcHover } = pcolor,
					{ initial: pbInitial, hover: pbHover } = pbackground

				if( JSON.stringify( colors ) !== JSON.stringify( previousValue[ catId ] ) ) {
					if( cInitial && JSON.stringify( pcInitial ) !== JSON.stringify( cInitial ) ) {
						cssCode += `body .post-categories .cat-item.cat-${ catId } a, body.archive.category.category-${ catId } #blog-postx-main-wrap .page-header .blog-postx-container i { color : ${ blog_postx_get_color_format( cInitial[ cInitial.type ] ) } } `
					}
					if( cHover && JSON.stringify( pcHover ) !== JSON.stringify( cHover ) ) {
						cssCode += `body .post-categories .cat-item.cat-${ catId } a:hover, body.archive.category.category-${ catId } #blog-postx-main-wrap .page-header .blog-postx-container i:hover { color : ${ blog_postx_get_color_format( cHover[ cHover.type ] ) } } `
					}
					if( bInitial && JSON.stringify( pbInitial ) !== JSON.stringify( bInitial ) ) {
						cssCode += `body .post-categories .cat-item.cat-${ catId } a, body.archive.category.category-${ catId } #blog-postx-main-wrap .page-header .blog-postx-container i { background : ${ blog_postx_get_color_format( bInitial[ bInitial.type ] ) } }`
					}
					if( bHover && JSON.stringify( pbHover ) !== JSON.stringify( bHover ) ) {
						cssCode += `body .post-categories .cat-item.cat-${ catId } a:hover, body.archive.category.category-${ catId } #blog-postx-main-wrap .page-header .blog-postx-container i:hover { background : ${ blog_postx_get_color_format( bHover[ bHover.type ] ) } }`
					}
					themeCalls.blogPostXGenerateStyleTag( cssCode, `blog-postx-category-${ catId }-style` )
				}
			})
		})
	})

	// Tag Colors
	wp.customize( `tag_colors`, function( value ) {
		let previousValue = value.get()
		value.bind( function(to) {
			Object.entries( to ).map(([ tagId, colors ]) => {
				let cssCode = '',
					{ color, background } = colors,
					{ initial: cInitial, hover: cHover } = color,
					{ initial: bInitial, hover: bHover } = background,
					{ color: pcolor, background: pbackground } = previousValue[ tagId ],
					{ initial: pcInitial, hover: pcHover } = pcolor,
					{ initial: pbInitial, hover: pbHover } = pbackground

				if( JSON.stringify( colors ) !== JSON.stringify( previousValue[ tagId ] ) ) {
					if( cInitial && JSON.stringify( pcInitial ) !== JSON.stringify( cInitial ) ) {
						cssCode += `body .tags-wrap .tags-item.tag-${ tagId } span { color : ${ blog_postx_get_color_format( cInitial[ cInitial.type ] ) } }`
					}
					if( cHover && JSON.stringify( pcHover ) !== JSON.stringify( cHover ) ) {
						cssCode += `body .tags-wrap .tags-item.tag-${ tagId }:hover span { color : ${ blog_postx_get_color_format( cHover[ cHover.type ] ) } }`
					}
					if( bInitial && JSON.stringify( pbInitial ) !== JSON.stringify( bInitial ) ) {
						cssCode += `body .tags-wrap .tags-item.tag-${ tagId } { background : ${ blog_postx_get_color_format( bInitial[ bInitial.type ] ) } }`
					}
					if( bHover && JSON.stringify( pbHover ) !== JSON.stringify( bHover ) ) {
						cssCode += `body .tags-wrap .tags-item.tag-${ tagId }:hover { background : ${ blog_postx_get_color_format( bHover[ bHover.type ] ) } }`
					}
					themeCalls.blogPostXGenerateStyleTag( cssCode, `blog-postx-tag-${ tagId }-style` )
				}
			})
		})
	})

	// custom button label
	wp.customize( 'custom_button_label', function( value ) {
		value.bind( function( to ) {
			if( $( "#masthead .header-custom-button-wrapper" ).find('.custom-button-label').length > 0 ) {
				$( "#masthead .header-custom-button-wrapper" ).find('.custom-button-label').text( to )
			} else {
				$( "#masthead .header-custom-button-wrapper .header-custom-button" ).append('<span class="custom-button-label">'+ to +'</span>')
			}
		})
	})

	// archive posts column
	wp.customize( 'archive_post_column', function( value ) {
		value.bind( function( to ) {
			if( to.desktop ) {
				$("body").removeClass( "archive-desktop-column--one archive-desktop-column--two archive-desktop-column--three archive-desktop-column--four" )
				$("body").addClass( "archive-desktop-column--" + blog_postx_get_numeric_string( to.desktop ) )
			}
			if( to.tablet ) {
				$("body").removeClass( "archive-tablet-column--one archive-tablet-column--two archive-tablet-column--three archive-tablet-column--four" )
				$("body").addClass( "archive-tablet-column--" + blog_postx_get_numeric_string( to.tablet ) )
			}
			if( to.smartphone ) {
				$("body").removeClass( "archive-mobile-column--one archive-mobile-column--two archive-mobile-column--three archive-mobile-column--four" )
				$("body").addClass( "archive-mobile-column--" + blog_postx_get_numeric_string( to.smartphone ) )
			}
		})
	})

	// category collection number of columns
	wp.customize( 'category_collection_number_of_columns', function( value ) {
		value.bind( function( to ) {
			if( to.desktop ) {
				$("#blog-postx-category-collection-section").removeClass( "column--one column--two column--three column--four column--five" )
				$("#blog-postx-category-collection-section").addClass( "column--" + blog_postx_get_numeric_string( to.desktop ) )
			}
			if( to.tablet ) {
				$("#blog-postx-category-collection-section").removeClass( "tab-column--one tab-column--two tab-column--three tab-column--four tab-column--five" )
				$("#blog-postx-category-collection-section").addClass( "tab-column--" + blog_postx_get_numeric_string( to.tablet ) )
			}
			if( to.smartphone ) {
				$("#blog-postx-category-collection-section").removeClass( "mobile-column--one mobile-column--two mobile-column--three mobile-column--four mobile-column--five" )
				$("#blog-postx-category-collection-section").addClass( "mobile-column--" + blog_postx_get_numeric_string( to.smartphone ) )
			}
		})
	})

	// you may have missed no of columns
	wp.customize( 'you_may_have_missed_no_of_columns', function( value ) {
		value.bind( function(to) {
			$('#blog-postx-you-may-have-missed-section').removeClass( 'no-of-columns--two no-of-columns--three no-of-columns--four' ).addClass( 'no-of-columns--' + blog_postx_get_numeric_string( parseInt(to) ) )
		});
	});

	// you may have missed section title option
	wp.customize( 'you_may_have_missed_title_option', function( value ) {
		value.bind( function(to) {
			if( $( "#blog-postx-you-may-have-missed-section" ).find('.section-title').length > 0 ) {
				if( to ){
					$('#blog-postx-you-may-have-missed-section .section-title').show()
				} else {
					$('#blog-postx-you-may-have-missed-section .section-title').hide()
				}
			} else {
				var sectionTitleControl = wp.customize.instance('you_may_have_missed_title').get();
				$( "#blog-postx-you-may-have-missed-section .blog-postx-you-may-missed-inner-wrap" ).prepend('<div class="blog-postx-block-title">'+ sectionTitleControl +'</div>')
			}
		});
	});

	// you may have missed section title
	wp.customize( 'you_may_have_missed_title', function( value ) {
		value.bind( function(to) {
			if( $( "#blog-postx-you-may-have-missed-section" ).find('.section-title').length > 0 ) {
				$( "#blog-postx-you-may-have-missed-section" ).find('.section-title .title').text( to )
			} else {
				$( "#blog-postx-you-may-have-missed-section .blog-postx-you-may-missed-inner-wrap" ).prepend('<div class="section-title"><span class="divider"></span><span class="title">'+ to +'</span></div>')
			}
		});
	})

	// canvas menu position
	wp.customize( 'canvas_menu_position', function( value ) {
		value.bind( function( to ) {
			if( to == 'right' ) {
				$('body').removeClass('blog-postx-canvas-position--left').addClass('blog-postx-canvas-position--right')
			} else {
				$('body').removeClass('blog-postx-canvas-position--right').addClass('blog-postx-canvas-position--left')
			}
		})
	})


	// Site Background Animation
	wp.customize( 'site_background_animation', function( value ) {
		value.bind( function( to ) {
			let prefix = 'background-animation--'
			$( 'body' ).removeClass( `${ prefix }none ${ prefix }one ${ prefix }two ${ prefix }three` ).addClass( `${ prefix }${ to }` )
			if( $( '.blog-postx-background-animation' ).length <= 0 ) {
				let arr = [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ],
					html = arr.map(() => {
						return '<span class="item"></span>';
					}).join('');

				$( 'body #page.site' ).append( `<div class="blog-postx-background-animation">${ html }</div>` )
			}
		})
	})

	// Website Layout
	wp.customize( 'website_layout', function( value ) {
		value.bind( function( to ) {
			$( 'body' ).toggleClass( 'boxed--layout full-width--layout' )
		})
	})

	// Header Builder Layout
	wp.customize( 'header_builder_section_width', function( value ) {
		value.bind( function( to ) {
			$( 'header.site-header' ).toggleClass( 'boxed--layout full-width--layout' )
		})
	})

	// Footer Builder Layout
	wp.customize( 'footer_builder_section_width', function( value ) {
		value.bind( function( to ) {
			$( 'footer.site-footer' ).toggleClass( 'boxed--layout full-width--layout' )
		})
	})

	// post format
	var postFormatIds = { 
		'standard': 'standard_post_format_icon_picker',
		'audio': 'audio_post_format_icon_picker',
		'gallery': 'gallery_post_format_icon_picker',
		'image': 'image_post_format_icon_picker',
		'quote': 'quote_post_format_icon_picker',
		'video': 'video_post_format_icon_picker' 
	}
	Object.entries( postFormatIds ).map(( [ currentKey, currentValue ] ) => {
		wp.customize( currentValue, function( value ) {
			value.bind( function(to) {
				if( to.type == 'none' ) {
					$( 'article.format-'+ currentKey +' .post-format-ss-wrap .post-format-icon' ).hide()
				} else {
					$( 'article.format-'+ currentKey +' .post-format-ss-wrap .post-format-icon' ).show()
				}
			});
		});
	})

	// check if string is variable and formats 
	function blog_postx_get_color_format( color ) {
		if( color === null ) return color
		if( color.includes('--blog-postx-global-preset-') ) {
			return ( 'var('+ color +')' )
		} else {
			return color
		}
	}

	// converts integer to string for attibutes value 
	function blog_postx_get_numeric_string(int) {
		switch( int ) {
			case 2:
				return "two";
				break;
			case 3:
				return "three";
				break;
			case 4:
				return "four";
				break;
			case 5:
				return "five";
				break;
			case 6:
				return "six";
				break;
			case 7:
				return "seven";
				break;
			case 8:
				return "eight";
				break;
			case 9:
				return "nine";
				break;
			case 10:
				return "ten";
				break;
			default:
				return "one";
		}
	}

	// constants
	const ajaxFunctions = {
		typoFontsEnqueue: function( typography ) {
			const { font_family, font_weight } = typography
			let linkTag = document.getElementById('blog-postx-generated-typo-fonts')
			let googleFontsUrl = 'https://fonts.googleapis.com/css2?'
			let googleFontsUrlQuery
			let fontStyle = ( font_weight.variant === 'italic' ) ? 'ital,wght@' : 'wght@'
			if( linkTag !== null ) {
				let parser = new URL( linkTag.href )
				let query = parser.search
				let toAppend = parseTheFontsQuery( query, typography )
				linkTag.href = googleFontsUrl + toAppend
			} else {
				let newLinkTag = document.createElement('link')
				newLinkTag.rel = 'stylesheet'
				newLinkTag.id = 'blog-postx-generated-typo-fonts'
				googleFontsUrlQuery = 'family=' + font_family.value + ':' + fontStyle + font_weight.value
				newLinkTag.href = googleFontsUrl + googleFontsUrlQuery
				document.head.appendChild( newLinkTag );
			}
		}
	}

	/**
     * Append new font family 
     * 
     * @since 1.0.0
     */
    const parseTheFontsQuery = ( query, typography ) => {
        const { font_weight:WEIGHT, font_family:FAMILY } = typography
        let toParse = query
        let removeQuestionMark = toParse.replaceAll( '?', '' )
        let filteredQuery = removeQuestionMark.replaceAll( '&', '' )
        let fontFamilyQuery = filteredQuery.split( 'family=' )
        let fontStyleProperty = WEIGHT.variant === 'italic' ? 'ital' : 'wght'
        var fontFamily = [ FAMILY.value ], fontWeight = { [FAMILY.value]: [ WEIGHT.value ] }, fontStyle = { [FAMILY.value]: [ fontStyleProperty ]}
		let filteredFamily = fontFamily.map(( current ) => {
			return current.replaceAll( '%20', ' ' )
		})
        fontFamilyQuery.forEach(( current ) => {
            if( current !== '' ) {
                let splitFamily = current.split( ':' )
                let family = splitFamily[0]
                if ( ! filteredFamily.includes( family ) ) filteredFamily.push( family );
                let splitWeightAndStyle = splitFamily[1].split('@')
                let weight = splitWeightAndStyle[1].replaceAll( '0,', '' ).replaceAll( '1,', '' ).replaceAll( ',', '' )
                let style = splitWeightAndStyle[0]
                if ( ! fontWeight[family] ) fontWeight[family] = []
                if ( ! fontStyle[family] ) fontStyle[family] = []
                if ( ! fontStyle[family].includes( style ) ) fontStyle[family].push( ...style.split(',') );
				
                if ( ! fontWeight[family].includes( weight ) ) fontWeight[family].push( ...weight.split(';') );
            }
        })
        let toAppend = filteredFamily.map(( family ) => {
			let sortedWeights = fontWeight[family].sort(( first, second ) => { return first - second })
			let duplicateRemovedWeights =  [ ...new Set( sortedWeights ) ]	//weights
			let duplicateRemovedStyles =  [ ...new Set( fontStyle[family] ) ]	// styles
			var structuredFontStyles, temporaryStyles = []
			if( duplicateRemovedStyles.includes( 'ital' ) ) {
				duplicateRemovedWeights.forEach(( current ) => { 
					if( current !== undefined && current !== '' ) temporaryStyles.push( '0,' + current + ';' )
				})
				duplicateRemovedWeights.forEach(( current, index ) => { 
					if( current !== undefined && current !== '' ) temporaryStyles.push( '1,' + current + ( index + 1 === duplicateRemovedWeights.length ? '' : ';' ) )
				})
				structuredFontStyles = temporaryStyles.join('')
			} else {
				structuredFontStyles = duplicateRemovedWeights.join(';')
			}
            return 'family=' + family + ':' + duplicateRemovedStyles.sort() + '@' + structuredFontStyles
        }).join('&')
        return toAppend;
    }

	// constants
	const helperFunctions = {
		generateStyle: function(color, id, variable) {
			if(color) {
				if( id === 'theme-color-style' ) {
					var styleText = 'body { ' + variable + ': ' + color + '}';
				} else {
					var styleText = 'body { ' + variable + ': ' + blog_postx_get_color_format( color ) + '}';
				}
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id).text( styleText )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + styleText + '</style>' )
				}
			}
		},
		bulkGenerateStyle: function( colors, id, variablePrefix ) {
			if( colors.length > 0 ) {
				let styleText = 'body {'
				colors.forEach(( color, index ) => {
					let count = index + 1
					styleText += variablePrefix + count + ': ' + color + ';'
				})
				styleText += '}'
				
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id).text( styleText )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + styleText + '</style>' )
				}
			}
		}
	}

	/**
	 * Controls
	 * 
	 * @since 1.0.0
	 */
	const BPXControls = {
		generateId( controlId ) {
			return controlId.replaceAll( '_', '-' );
		},
		color( obj = {} ){
			const THIS = this;
			let { controlId, selector = 'body.blog-postx-variables', property = 'background' } = obj,
				styleId = this.generateId( controlId ),
				isVariable = ( selector === 'body.blog-postx-variables' );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let cssCode = '',
						isObject = ( typeof to === 'object' ),
						isHover = ( isObject && ( 'hover' in to ) );
					if( isHover ) {
						let hoverProperty =  `${ property }${ isVariable ? '-' : ':' }hover`,
							{ initial, hover } = to;
						cssCode += `${ selector } { ${ property }: ${ THIS.getColorCSS( initial ) }; }\n`
						cssCode += `${ selector } { ${ hoverProperty }: ${ THIS.getColorCSS( hover ) }; }\n`
					} else {
						if( isObject && ( 'image' in to ) ) {
							cssCode += `${ selector } { ${ isObject ? THIS.getColorCSS( to ) : to }; }`
						} else {
							cssCode += `${ selector } { ${ property }: ${ isObject ? THIS.getColorCSS( to ) : to }; }`
						}
					}

					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		getColorCSS( color ){
			let cssCode = '';
			switch( color.type ) {
				case 'image' : 
						let { repeat = 'no-repeat', position = 'left top', attachment = 'fixed', size = 'auto'  } = color
						if( 'id' in color.image ) cssCode += 'background-image: url(' + color.image.url + ');\n'
						cssCode += " background-repeat: "+ repeat + ';\n'
						cssCode += " background-position: "+ position + ';\n'
						cssCode += " background-attachment: "+ attachment + ';\n'
						cssCode += " background-size: "+ size + ';\n'
					break;
				default: 
						cssCode = blog_postx_get_color_format( color[color.type] )
					break;
			}
			return cssCode;
		},
		typography( obj = {} ){
			let { controlId, selector = 'body.blog-postx-variables', property } = obj,
				styleId = this.generateId( controlId ),
				isVariable = ( selector === 'body.blog-postx-variables' );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					ajaxFunctions.typoFontsEnqueue( to )
					let cssCode = themeCalls.blogPostXGenerateTypoCss( ( isVariable ? property : selector ), to, isVariable )
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				})
			})
		},
		number( obj = {} ) {
			let { controlId, selector, property } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let cssCode = '';
					if( Array.isArray( property ) ) {
						cssCode = `${ selector }{`
						cssCode += property.map(( prop ) => {
							return `${ prop }: ${ to }px;`
						}).join( '' )
						cssCode += '}'
					} else {
						cssCode = `${ selector }{ ${ property }: ${ to }px }`;
					}
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		responsiveSlider( obj = {} ) {
			let { controlId, selector = 'body.blog-postx-variables', property = 'border-radius', unit = 'px' } = obj,
				styleId = this.generateId( controlId ),
				isVariable = ( selector === 'body.blog-postx-variables' );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { desktop, tablet, smartphone } = to,
						cssCode = '';

					if( isVariable ) {
						if( property.includes( 'image-ratio' ) ) unit = '';
						cssCode += `${ selector } {\n`
						if( desktop ) cssCode += `${ property } : ${ desktop }${ unit };\n`;
						if( tablet ) cssCode += `${ property }-tab: ${ tablet }${ unit };\n`
						if( smartphone ) cssCode += `${ property }-mobile: ${ smartphone }${ unit };\n`
						cssCode += '}'
					} else {
						// desktop
							let desktopValue = `${ desktop }${ unit }`
							cssCode += `${ selector } {\n`
							if( Array.isArray( property ) ) {
								cssCode += property.map(( prop ) => {
									return `${ prop }: ${ desktopValue };\n`
								}).join( '' )
							} else {
								cssCode += `${ property }: ${ desktopValue };\n`
							}
							cssCode += `}`
						// tablet
							let tabletValue = `${ tablet }${ unit }`
							cssCode += `@media(max-width: 940px) { ${ selector } {\n`
							if( Array.isArray( property ) ) {
								cssCode += property.map(( prop ) => {
									return `${ prop }: ${ tabletValue };\n`
								}).join( '' )
							} else {
								cssCode += `${ property }: ${ tabletValue };\n`
							}
							cssCode += `} }`
						// smartphone
							let mobileValue = `${ smartphone }${ unit }`
							cssCode += `@media(max-width: 610px) { ${ selector } {\n`
							if( Array.isArray( property ) ) {
								cssCode += property.map(( prop ) => {
									return `${ prop }: ${ mobileValue };\n`
								}).join( '' )
							} else {
								cssCode += `${ property }: ${ mobileValue };\n`
							}
							cssCode += `} }`
					}
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		toggleClassWithPrefix( obj = {} ) {
			let { controlId, selector = 'body', prefix = '' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function(to) {
					$( selector ).removeClass(function( index, currentClass ){
						return currentClass.split( /\s+/ ).filter( className => className.startsWith( prefix )).join( ' ' );
					}).addClass( prefix + to )
				});
			});
		},
		toggleClass( obj = {} ) {
			let { controlId, selector = 'body', classToToggle = '' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function() {
					if( $( selector ).hasClass( classToToggle ) ) {
						$( selector ).removeClass( classToToggle )
					} else {
						$( selector ).addClass( classToToggle )
					}
				});
			});
		},
		border( obj = {} ) {
			let { controlId, selector = 'body', property = 'border' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { type, color, width } = to
						cssCode = `${ selector } {\n`;

					if( type === 'none' ) {
						cssCode += `${ property }: none;`
					} else {
						if( typeof width === 'object' ) {
							let { top, right, bottom, left } = width
							cssCode += `border-width: ${ top }px ${ right }px ${ bottom }px ${ left }px;\n`;
							cssCode += `border-style: ${ type };\n`;
							cssCode += `border-color: ${ blog_postx_get_color_format( color ) };\n`;
						} else {
							cssCode += `${ property }: ${ width }px ${ type } ${ blog_postx_get_color_format( color ) };`
						}
					}
					cssCode += '}'
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		dimension( obj = {} ) {
			let { controlId, selector = 'body', property = 'padding' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					let { desktop, tablet, smartphone } = to
						cssCode = '';

					if( desktop ) cssCode += `${ selector } { ${ property }: ${ desktop.top }px ${ desktop.right }px ${ desktop.bottom }px ${ desktop.left }px; }`
					if( tablet ) cssCode += `@media(max-width: 940px) { ${ selector } { ${ property }: ${ tablet.top }px ${ tablet.right }px ${ tablet.bottom }px ${ tablet.left }px; } }`
					if( smartphone ) cssCode += `@media(max-width: 610px) { ${ selector } { ${ property }: ${ smartphone.top }px ${ smartphone.right }px ${ smartphone.bottom }px ${ smartphone.left }px; } }`
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		boxShadow( obj = {} ) {
			let { controlId, selector = 'body' } = obj,
				styleId = this.generateId( controlId );

			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					var cssCode = ''
					if( to && to.option ) {
						let boxShadowValue = `${ ( to.type === 'outset' ) ? '' : to.type } ${ to.hoffset }px ${ to.voffset }px ${ to.blur }px ${ to.spread }px ${ blog_postx_get_color_format( to.color ) }`
						cssCode += `${ selector } { box-shadow: ${ boxShadowValue }; -webkit-box-shadow: ${ boxShadowValue }; -moz-box-shadow ${ boxShadowValue } }`
					} else {
						cssCode += `${ selector } { box-shadow: 0px 0px 0px 0px; }`
					}
					themeCalls.blogPostXGenerateStyleTag( cssCode, 'blog-postx-' + styleId )
				});
			});
		},
		text( obj = {} ) {
			let { controlId, selector = 'body' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					$( selector ).text( to )
				});
			});
		},
		builderResponsive( obj = {} ) {
			let { controlId, selector = 'body', responsiveSelector = '', prefix = '' } = obj
			wp.customize( controlId, function( value ) {
				value.bind( function( to ) {
					if( responsiveSelector === '' ) responsiveSelector = selector
					const { desktop, tablet, smartphone } = to,
						desktopPrefix = prefix,
						tabletPrefix = `tablet-${ prefix }`,
						smartphonePrefix = `smartphone-${ prefix }`,
						desktopReg = new RegExp( `${ desktopPrefix }\\S+`, 'g' ),
						tabletReg = new RegExp( `${ tabletPrefix }\\S+`, 'g' ),
						smartphoneReg = new RegExp( `${ smartphonePrefix }\\S+`, 'g' );

					$( selector ).removeClass(function( index, _thisClass ) {
						return ( _thisClass.match( desktopReg ) || [] ).join(' ');
					}).addClass( `${ desktopPrefix }${ desktop }` )
					
					$( responsiveSelector ).removeClass(function( index, _thisClass ) {
						return ( _thisClass.match( tabletReg ) || [] ).join(' ');
					}).addClass( `${ tabletPrefix }${ tablet }` )

					$( responsiveSelector ).removeClass(function( index, _thisClass ) {
						return ( _thisClass.match( smartphoneReg ) || [] ).join(' ');
					}).addClass( `${ smartphonePrefix }${ smartphone }` )
				});
			});
		}
	}

	// Color Variable
	BPXControls.color({ controlId: 'date_color', property: 'color', selector: 'body header.site-header .top-date-time .top-date-time-inner .date' });
	BPXControls.color({ controlId: 'time_color', property: 'color', selector: 'body header.site-header .top-date-time .top-date-time-inner .time' });
	BPXControls.color({ controlId: 'date_time_separator_color', property: 'color', selector: 'body header.site-header .top-date-time .top-date-time-inner .date-time-separator i' });
	BPXControls.color({ controlId: 'header_menu_color', property: '--blog-postx-menu-color' });
	BPXControls.color({ controlId: 'footer_menu_color', property: '--blog-postx-footer-menu-color' });
	BPXControls.color({ controlId: 'mobile_canvas_icon_color', property: '--blog-postx-mobile-canvas-icon-color' });
	BPXControls.color({ controlId: 'header_sub_menu_color', property: '--blog-postx-menu-color-submenu' });
	BPXControls.color({ controlId: 'search_icon_color', property: '--blog-postx-search-icon-color' });
	BPXControls.color({ controlId: 'theme_mode_dark_icon_color', property: '--blog-postx-theme-darkmode-color' });
	BPXControls.color({ controlId: 'theme_mode_light_icon_color', property: '--blog-postx-theme-mode-color' });
	BPXControls.color({ controlId: 'canvas_menu_icon_color', property: '--blog-postx-canvas-icon-color' });
	BPXControls.color({ controlId: 'stt_color_group', property: '--blog-postx-scroll-text-color' });
	BPXControls.color({ controlId: 'pagination_button_text_color', property: '--blog-postx-ajax-pagination-color' });
	BPXControls.color({ controlId: 'header_custom_button_background_color_group', property: '--blog-postx-custom-button-bk-color' });
	BPXControls.color({ controlId: 'pagination_button_background_color', property: '--blog-postx-ajax-pagination-bk-color' });
	BPXControls.color({ controlId: 'header_secondary_menu_color', property: '--blog-postx-secondary-menu-color' });

	// Colors Selectors
	BPXControls.color({ controlId: 'site_background_color', selector: 'body:before' });
	BPXControls.color({ controlId: 'header_builder_background', selector: 'body.blog-postx-light-mode .site-header' });
	BPXControls.color({ controlId: 'header_secondary_menu_color', selector: '#site-navigation-secondary .menu li a', property: 'color' });

	// Typography Variable
	BPXControls.typography({ controlId: 'global_button_typo', property: '--blog-postx-readmore-font' });
	BPXControls.typography({ controlId: 'site_title_typo', property: '--blog-postx-site-title' });
	BPXControls.typography({ controlId: 'site_description_typo', property: '--blog-postx-site-description' });
	BPXControls.typography({ controlId: 'custom_button_text_typography', property: '--blog-postx-custom-button' });
	BPXControls.typography({ controlId: 'main_menu_typo', property: '--blog-postx-menu' });
	BPXControls.typography({ controlId: 'header_secondary_menu_typo', property: '--blog-postx-secondary-menu' });
	BPXControls.typography({ controlId: 'footer_menu_typography', property: '--blog-postx-footer-menu' });
	BPXControls.typography({ controlId: 'date_time_typography', property: 'body .top-date-time .top-date-time-inner' });
	BPXControls.typography({ controlId: 'main_menu_sub_menu_typo', property: '--blog-postx-submenu' });
	BPXControls.typography({ controlId: 'archive_title_typo', property: '--blog-postx-post-title-font' });
	BPXControls.typography({ controlId: 'archive_excerpt_typo', property: '--blog-postx-post-content-font' });
	BPXControls.typography({ controlId: 'category_collection_typo', property: '--blog-postx-category-collection-font' });
	BPXControls.typography({ controlId: 'site_block_title_typo', property: '--blog-postx-block-font' });
	BPXControls.typography({ controlId: 'you_may_have_missed_design_post_title_typography', property: '--blog-postx-youmaymissed-title-font' });
	BPXControls.typography({ controlId: 'sidebar_post_title_typography', property: '--blog-postx-widget-title-font' });
	BPXControls.typography({ controlId: 'main_banner_design_post_title_typography', property: '--blog-postx-banner-title-font' });
	BPXControls.typography({ controlId: 'main_banner_design_post_excerpt_typography', property: '--blog-postx-banner-excerpt-font' });
	BPXControls.typography({ controlId: 'main_banner_sidebar_post_typography', property: '--blog-postx-banner-sidebar-title-font' });

	BPXControls.typography({ controlId: 'global_category_typography', property: '--blog-postx-category-font' });
	BPXControls.typography({ controlId: 'global_date_typography', property: '--blog-postx-date-font' });
	BPXControls.typography({ controlId: 'global_author_typography', property: '--blog-postx-author-font' });
	BPXControls.typography({ controlId: 'global_read_time_typography', property: '--blog-postx-readtime-font' });
	BPXControls.typography({ controlId: 'global_comments_typography', property: '--blog-postx-comment-font' });

	// Typography Selectors
	BPXControls.typography({ controlId: 'breadcrumb_typo', selector: 'body .blog-postx-breadcrumb-wrap ul li span[itemprop="name"]' });
	BPXControls.typography({ controlId: 'archive_category_info_box_title_typo', selector: 'body.blog-postx-variables.archive.category .page-header .page-title, .archive.date .page-header .page-title, .tax-post_format #blog-postx-main-wrap .page-header .page-title' });
	BPXControls.typography({ controlId: 'archive_category_info_box_description_typo', selector: 'body.blog-postx-variables.archive.category .page-header .archive-description' });
	BPXControls.typography({ controlId: 'archive_tag_info_box_title_typo', selector: 'body.blog-postx-variables.archive.tag .page-header .page-title' });
	BPXControls.typography({ controlId: 'archive_tag_info_box_description_typo', selector: 'body.blog-postx-variables.archive.tag .page-header .archive-description' });
	BPXControls.typography({ controlId: 'archive_author_info_box_title_typo', selector: 'body.blog-postx-variables.archive.author .page-header .page-title' });
	BPXControls.typography({ controlId: 'archive_author_info_box_description_typo', selector: 'body.blog-postx-variables.archive.author .page-header .archive-description' });
	BPXControls.typography({ controlId: 'single_title_typo', selector: 'body.single-post.blog-postx-variables .site-main article .entry-title, body.single-post.blog-postx-variables .single-header-content-wrap .entry-title, body.single-post #primary .post-navigation .nav-links .nav-title, .single-related-posts-section-wrap.layout--list .single-related-posts-wrap article .post-element .post-title' });
	BPXControls.typography({ controlId: 'single_content_typo', selector: 'body.single-post.blog-postx-variables .site-main article .entry-content p' });
	BPXControls.typography({ controlId: 'page_title_typo', selector: 'body.page.blog-postx-variables #blog-postx-main-wrap #primary article .entry-title' });
	BPXControls.typography({ controlId: 'page_content_typo', selector: 'body.page.blog-postx-variables article .entry-content' });
	BPXControls.typography({ controlId: 'carousel_design_post_title_typography', selector: 'body.blog-postx-variables .blog-postx-carousel-section .carousel-wrap .post-elements .post-title' });
	BPXControls.typography({ controlId: 'heading_one_typo', selector: 'body article .post-inner h1' });
	BPXControls.typography({ controlId: 'heading_two_typo', selector: 'body article .post-inner h2' });
	BPXControls.typography({ controlId: 'heading_three_typo', selector: 'body article .post-inner h3' });
	BPXControls.typography({ controlId: 'heading_four_typo', selector: 'body article .post-inner h4' });
	BPXControls.typography({ controlId: 'heading_five_typo', selector: 'body article .post-inner h5' });
	BPXControls.typography({ controlId: 'heading_six_typo', selector: 'body article .post-inner h6' });
	BPXControls.typography({ controlId: 'sidebar_heading_one_typography', selector: 'body aside h1.wp-block-heading' });
	BPXControls.typography({ controlId: 'sidebar_heading_two_typo', selector: 'body aside h2.wp-block-heading' });
	BPXControls.typography({ controlId: 'sidebar_heading_three_typo', selector: 'body aside h3.wp-block-heading' });
	BPXControls.typography({ controlId: 'sidebar_heading_four_typo', selector: 'body aside h4.wp-block-heading' });
	BPXControls.typography({ controlId: 'sidebar_heading_five_typo', selector: 'body aside h5.wp-block-heading' });
	BPXControls.typography({ controlId: 'sidebar_heading_six_typo', selector: 'body aside h6.wp-block-heading' });
	BPXControls.typography({ controlId: 'sticky_posts_label_typography', selector: 'body .blog-postx-sticky-posts .label-wrapper .label' });
	BPXControls.typography({ controlId: 'sticky_posts_title_typography', selector: 'body .blog-postx-sticky-posts .post-list article .post-content .post-title' });
	BPXControls.typography({ controlId: 'web_stories_preview_count_typo', selector: 'body .blog-postx-web-stories .stories-wrap .preview .story-count' });
	BPXControls.typography({ controlId: 'web_stories_preview_title_typo', selector: 'body .blog-postx-web-stories .stories-wrap .story-title' });
	BPXControls.typography({ controlId: 'web_stories_title_typo', selector: 'body .blog-postx-web-stories .inner-stories-wrap .content-wrap .title' });
	BPXControls.typography({ controlId: 'sidebar_pagination_button_typo', selector: 'body .blog-postx-widget-loader .load-more' });
	BPXControls.typography({ controlId: 'footer_title_typography', selector: 'body footer .widget_block .wp-block-group__inner-container .wp-block-heading, body footer section.widget .widget-title, body footer .wp-block-heading' });
	BPXControls.typography({ controlId: 'footer_text_typography', selector: 'body footer ul.wp-block-latest-posts a, body footer ol.wp-block-latest-comments li footer, body footer ul.wp-block-archives a, body footer ul.wp-block-categories a, body footer ul.wp-block-page-list a, body footer .widget_blog_postx_post_grid_widget .post-grid-wrap .post-title, body footer .menu .menu-item a, body footer .widget_blog_postx_category_collection_widget .categories-wrap .category-item .category-name, body footer .widget_blog_postx_post_list_widget .post-list-wrap .post-title a' });
	BPXControls.typography({ controlId: 'bottom_footer_text_typography', selector: 'body footer .site-info' });
	BPXControls.typography({ controlId: 'ticker_news_post_title_typo', selector: 'body .blog-postx-ticker-news .ticker-news-wrap .ticker-item .title-wrap .post-title' });
	BPXControls.typography({ controlId: 'header_secondary_menu_typo', selector: 'body .blog-postx-ticker-news .ticker-news-wrap .ticker-item .title-wrap .post-title' });
	
	// Checkbox
	BPXControls.toggleClass({ 
		controlId: 'show_readtime_mobile_option', 
		selector: 'body.blog .blog-postx-article-inner .post-meta .post-read-time, body.archive .blog-postx-article-inner .post-meta .post-read-time, body.home .blog-postx-article-inner .post-meta .post-read-time, body.search .blog-postx-article-inner .post-meta .post-read-time', 
		classToToggle: 'hide-on-mobile' 
	});
	BPXControls.toggleClass({ 
		controlId: 'show_comment_number_mobile_option', 
		selector: 'body.blog .blog-postx-article-inner .post-meta .post-comments-num, body.archive .blog-postx-article-inner .post-meta .post-comments-num, body.home .blog-postx-article-inner .post-meta .post-comments-num, body.search .blog-postx-article-inner .post-meta .post-comments-num',
		classToToggle: 'hide-on-mobile'
	});
	BPXControls.toggleClass({ controlId: 'show_main_banner_excerpt_mobile_option', selector: '#blog-postx-main-banner-section .post-excerpt', classToToggle: 'hide-on-mobile' });
	BPXControls.toggleClass({ controlId: 'show_carousel_banner_excerpt_mobile_option', selector: '#blog-postx-carousel-section .post-excerpt', classToToggle: 'hide-on-mobile' });
	BPXControls.toggleClass({ controlId: 'show_background_animation_on_mobile', selector: 'body .blog-postx-background-animation', classToToggle: 'hide-on-mobile' });
	BPXControls.toggleClass({ controlId: 'show_scroll_to_top_on_mobile', selector: 'body #blog-postx-scroll-to-top', classToToggle: 'hide-on-mobile' });
	BPXControls.toggleClass({ controlId: 'header_first_row_header_sticky', selector: 'body .site-header .row-one', classToToggle: 'row-sticky' });
	BPXControls.toggleClass({ controlId: 'header_second_row_header_sticky', selector: 'body .site-header .row-two', classToToggle: 'row-sticky' });
	BPXControls.toggleClass({ controlId: 'header_third_row_header_sticky', selector: 'body .site-header .row-three', classToToggle: 'row-sticky' });
	// BPXControls.toggleClass({ controlId: 'website_layout' });
	
	// Dimension
	BPXControls.dimension({ controlId: 'carousel_image_border_radius', selector: '.blog-postx-carousel-section article.post-item .post-thumb', property: 'border-radius' });
	BPXControls.dimension({ controlId: 'header_first_row_padding', selector: 'body header.site-header .row-one' });
	BPXControls.dimension({ controlId: 'header_second_row_padding', selector: 'body header.site-header .row-two' });
	BPXControls.dimension({ controlId: 'header_third_row_padding', selector: 'body header.site-header .row-three' });
	BPXControls.dimension({ controlId: 'footer_first_row_padding', selector: 'body footer.site-footer .bb-bldr-row.row-one' });
	BPXControls.dimension({ controlId: 'footer_second_row_padding', selector: 'body footer.site-footer .bb-bldr-row.row-two' });
	BPXControls.dimension({ controlId: 'footer_third_row_padding', selector: 'body footer.site-footer .bb-bldr-row.row-three' });

	// Responsive Number
	BPXControls.responsiveSlider({ 
		controlId: 'main_banner_border_radius', 
		selector: 'body .blog-postx-main-banner-section .main-banner-sidebar .scrollable-post, .blog-postx-main-banner-section .main-banner-sidebar .scrollable-post .count-image-wrapper .post-thumb', 
		property: 'border-radius'
	});
	BPXControls.responsiveSlider({ controlId: 'site_logo_width', selector: 'body .bb-bldr-row .site-branding img', property: 'width' });
	BPXControls.responsiveSlider({ controlId: 'theme_mode_icon_size', selector: 'body .site-header .mode-toggle img, body .site-header .mode-toggle i', property: [ 'width', 'font-size' ] });
	BPXControls.responsiveSlider({ controlId: 'ticker_news_border_radius', selector: '.blog-postx-ticker-news .ticker-news-wrap .ticker-item .post-thumb, body .blog-postx-ticker-news .row', property: 'border-radius' });
	BPXControls.responsiveSlider({ controlId: 'bottom_footer_logo_width', selector: 'body .footer-logo img', property: 'width' });
	BPXControls.responsiveSlider({ controlId: 'search_icon_size', selector: 'body .site-header .search-trigger i', property: 'font-size' });
	BPXControls.responsiveSlider({ controlId: 'header_custom_button_border_radius', selector: 'body .site-header .header-custom-button', property: 'border-radius' });
	BPXControls.responsiveSlider({ controlId: 'category_collection_image_radius', selector: '.blog-postx-category-collection-section .category-wrap .category-thumb a', property: 'border-radius' });

	// Toggle class with prefix
	BPXControls.toggleClassWithPrefix({ controlId: 'header_first_row_column', selector: 'header.site-header .bb-bldr-row.row-one', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'header_second_row_column', selector: 'header.site-header .bb-bldr-row.row-two', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'header_third_row_column', selector: 'header.site-header .bb-bldr-row.row-three', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'footer_first_row_column', selector: 'footer.site-footer .bb-bldr-row.row-one', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'footer_second_row_column', selector: 'footer.site-footer .bb-bldr-row.row-two', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'footer_three_row_column', selector: 'footer.site-footer .bb-bldr-row.row-three', prefix: 'column-' });
	BPXControls.toggleClassWithPrefix({ controlId: 'post_title_hover_effects', prefix: 'title-hover--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'site_image_hover_effects', prefix: 'image-hover--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'header_menu_hover_effect', selector: '#site-navigation', prefix: 'hover-effect--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'footer_menu_hover_effect', selector: 'footer.site-footer .bb-bldr-widget .menu', prefix: 'hover-effect--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'custom_button_animation_type', selector: '.header-custom-button-wrapper a.header-custom-button', prefix: 'animation-type--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'main_banner_post_elements_alignment', selector: '.blog-postx-main-banner-section', prefix: 'banner-align--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'carousel_post_elements_alignment', selector: '#blog-postx-carousel-section', prefix: 'carousel-align--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'archive_post_elements_alignment', selector: 'body.archive .blog-postx-inner-content-wrap, body.blog .blog-postx-inner-content-wrap, body.home .blog-postx-inner-content-wrap, body.search .blog-postx-inner-content-wrap', prefix: 'archive-align--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'single_post_content_alignment', selector: 'body.single #primary .blog-postx-inner-content-wrap .entry-content', prefix: 'content-alignment--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'category_collection_hover_effects', selector: '#blog-postx-category-collection-section', prefix: 'hover-effect--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'you_may_have_missed_post_elements_alignment', selector: '.blog-postx-you-may-have-missed-section', prefix: 'you-may-have-missed-align--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'mobile_canvas_alignment', selector: 'header .bb-bldr--responsive .bb-bldr-row.mobile-canvas', prefix: 'alignment--' });
	BPXControls.toggleClassWithPrefix({ controlId: 'sticky_posts_position', selector: '.blog-postx-sticky-posts', prefix: 'position-' });

	// Text
	BPXControls.text({ controlId: 'blogname', selector: '.site-title a' });
	BPXControls.text({ controlId: 'blogdescription', selector: '.site-description' });

	// Number
	BPXControls.number({ controlId: 'single_page_border_radius', selector: 'body.single-post .post-thumbnail.no-single-featured-image, body.single-post #blog-postx-main-wrap .blog-postx-container .row #primary .blog-postx-inner-content-wrap article > div, body.single-post #blog-postx-main-wrap .blog-postx-container .row #primary nav.navigation, body.single-post #blog-postx-main-wrap .blog-postx-container .row #primary .single-related-posts-section-wrap.layout--list, body.single-post #primary article .post-card .bmm-author-thumb-wrap, body.single .wp-block-embed-soundcloud iframe, body.single .wp-block-embed-youtube iframe, .single .blog-postx-advertisement img', property: 'border-radius' });
	BPXControls.number({ controlId: 'main_banner_image_border_radius', selector: 'body .blog-postx-main-banner-section .main-banner-wrap .slick-list .post-thumb, body .blog-postx-main-banner-section .main-banner-wrap .slick-list .post-elements, body .blog-postx-main-banner-section .main-banner-swiper-thumbs .slick-slide', property: 'border-radius' });
	BPXControls.number({ controlId: 'archive_section_border_radius', selector: 'body .site #blog-postx-main-wrap > .blog-postx-container > .row #primary .blog-postx-inner-content-wrap article .blog-postx-article-inner, body #blog-postx-main-wrap > .blog-postx-container > .row #primary .blog-postx-inner-content-wrap article .blog-postx-article-inner .post-thumbnail-wrapper, body.search.search-results .site #blog-postx-main-wrap .blog-postx-container .page-header, #primary .blog-postx-inner-content-wrap .blog-postx-advertisement-block img, body.search section.no-results.not-found', property: 'border-radius' });
	BPXControls.number({ controlId: 'sidebar_border_radius', selector: 'body .site .widget, body #widget_block, body .widget.widget_media_image figure.wp-block-image img, body .widget-area .blog-postx-table-of-content .toc-wrapper, body.error404 #blog-postx-main-wrap #primary .not-found', property: 'border-radius' });
	BPXControls.number({ controlId: 'sidebar_image_border_radius', selector: '.widget .post-thumb-image, .widget .post-thumb, .widget_blog_postx_carousel_widget .post-thumb-wrap, .widget.widget_media_image, .widget_blog_postx_category_collection_widget .categories-wrap .category-item .category-name, body .widget_blog_postx_post_list_widget .post-list-wrap .post-thumb-image .post-thumb, body .widget_blog_postx_posts_grid_two_column_widget .posts-wrap .post-thumb, body .widget_blog_postx_author_info_widget .bmm-author-thumb-wrap .post-thumb img', property: 'border-radius' });
	BPXControls.number({ controlId: 'page_image_border_radius', selector: 'body.page-template-default.blog-postx-variables #primary article .post-thumbnail, body.page-template-default.blog-postx-variables #primary article .post-thumbnail img', property: 'border-radius' });
	BPXControls.number({ controlId: 'page_border_radius', selector: '.page #blog-postx-main-wrap #primary article, .error404 .error-404', property: 'border-radius' });
	BPXControls.number({ controlId: 'single_image_border_radius', selector: 'body.single .site .blog-postx-main-wrap .entry-header .post-thumbnail, body.single .site .post-inner .post-thumbnail', property: 'border-radius' });
	BPXControls.number({ controlId: 'you_may_have_missed_border_radius', selector: 'body .blog-postx-you-may-have-missed-section .blog-postx-you-may-missed-inner-wrap, body .blog-postx-you-may-have-missed-section .blog-postx-you-may-missed-inner-wrap .post-item .post-thumbnail-wrapper', property: 'border-radius' });
	BPXControls.number({ controlId: 'web_stories_image_radius', selector: 'body .blog-postx-web-stories .stories-wrap .preview', property: 'border-radius' });
	BPXControls.number({ controlId: 'carousel_section_border_radius', selector: 'body .blog-postx-carousel-section.carousel-layout--three article.post-item', property: 'border-radius' });

	// Builder Responsive layout
	BPXControls.builderResponsive({ controlId: 'header_first_row_column_layout', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one', prefix: 'layout-' });
	BPXControls.builderResponsive({ controlId: 'header_second_row_column_layout', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two', prefix: 'layout-' });
	BPXControls.builderResponsive({ controlId: 'header_third_row_column_layout', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three', prefix: 'layout-' });
	BPXControls.builderResponsive({ controlId: 'footer_first_row_column_layout', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one', prefix: 'layout-' });
	BPXControls.builderResponsive({ controlId: 'footer_second_row_column_layout', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two', prefix: 'layout-' });
	BPXControls.builderResponsive({ controlId: 'footer_third_row_column_layout', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three', prefix: 'layout-' });

	// Builder Responsive alignment
	BPXControls.builderResponsive({ controlId: 'header_first_row_column_one', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_first_row_column_two', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_first_row_column_three', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_second_row_column_one', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_second_row_column_two', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_second_row_column_three', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_third_row_column_one', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_third_row_column_two', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'header_third_row_column_three', selector: 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three', responsiveSelector: 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_first_row_column_one', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_first_row_column_two', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_first_row_column_three', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_first_row_column_four', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.four', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_second_row_column_one', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_second_row_column_two', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_second_row_column_three', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_second_row_column_four', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.four', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_third_row_column_one', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_third_row_column_two', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_third_row_column_three', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three', prefix: 'alignment-' });
	BPXControls.builderResponsive({ controlId: 'footer_third_row_column_four', selector: 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.four', prefix: 'alignment-' });
	
}( jQuery ) );