<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * You can add an optional custom header image to header.php like so ...
 *
	<?php the_header_image_tag(); ?>
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package Blog Postx Pro
 */

use BlogPostx\CustomizerDefault as BPX;
/**
 * Set up the WordPress core custom header feature.
 *
 * @uses blog_postx_header_style()
 */
function blog_postx_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'blog_postx_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => 'ffffff',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'blog_postx_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'blog_postx_custom_header_setup' );

if ( ! function_exists( 'blog_postx_header_style' ) ) :
	/**
	 * Styles the header image and text displayed on the blog.
	 *
	 * @see blog_postx_custom_header_setup().
	 */
	function blog_postx_header_style() {
		$header_text_color = BPX\blog_postx_get_customizer_option( 'header_textcolor' );
		$header_hover_textcolor = BPX\blog_postx_get_customizer_option( 'site_title_hover_textcolor' );
		$site_description_color = BPX\blog_postx_get_customizer_option( 'site_description_color' );

		/*
		 * If no custom options for text are set, let's bail.
		 * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
		 */
		if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
			return;
		}

		// If we get this far, we have custom styles. Let's do this.
		?>
		<style type="text/css">
		<?php
		// Has the text been hidden?
		if ( ! display_header_text() ) :
			?>
			.site-title {
				position: absolute;
				clip: rect(1px, 1px, 1px, 1px);
				}
			<?php
			// If the user has set a custom color for the text use that.
		else :
			if( $header_text_color !== BPX\blog_postx_get_customizer_default( 'header_textcolor' ) ) : ?>
				body.blog-postx-light-mode header.site-header .site-branding .site-title,
				body.blog-postx-light-mode header.site-header .site-branding .site-title a,
				.blog-postx-light-mode .site-footer .site-title,
				.blog-postx-light-mode .site-footer .site-title a {
					color: #<?php echo esc_attr( $header_text_color ); ?>;
				}
			<?php 
			endif;
			if( $site_description_color !== BPX\blog_postx_get_customizer_default( 'site_description_color' ) ) : ?>
				body.blog-postx-light-mode .site header.site-header .site-branding p.site-description {
					color: <?php echo esc_attr( $site_description_color ); ?>;
				}
			<?php
			endif;
			if( $header_hover_textcolor !== BPX\blog_postx_get_customizer_default( 'site_title_hover_textcolor' ) ) : ?>
				body.blog-postx-light-mode header.site-header .site-branding .site-title:hover,
				body.blog-postx-light-mode header.site-header .site-branding .site-title:hover a,
				.blog-postx-light-mode .site-footer .site-title:hover a,
				.blog-postx-light-mode .site-footer .site-title:hover {
					color: <?php echo esc_attr( $header_hover_textcolor ); ?>;
				}
			<?php
			endif;
		endif; ?>
		</style>
		<?php
	}
endif;