<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
require get_template_directory() . '/builder/responsive-header.php';
use Blog_Postx_Builder as BB;
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> <?php blog_postx_schema_body_attributes(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'blog-postx' ); ?></a>
	<?php
		/**
		 * hook - blog_postx_page_prepend_hook
		 * 
		 * hooked - blog_postx_loader_html - 1
		 * hooked - blog_postx_custom_header_html - 20
		 */
		if( has_action( 'blog_postx_page_prepend_hook' ) ) do_action( "blog_postx_page_prepend_hook" );

		$headerClass = 'site-header layout--one ' . BPX\blog_postx_get_customizer_option( 'header_builder_section_width' );
		?>
			<header id="masthead" class="<?php echo esc_attr( $headerClass ); ?>">
				<div class="blog-postx-container">
					<div class="row">
						<?php
							new BB\Header_Builder_Render();
							new BB\Responsive_Header_Builder_Render();
						?>
					</div>
				</div>
			</header><!-- #masthead -->
		<?php

		/**
		 * Hook - blog_postx_header_after_hook
		 * 
		 * @hooked  - blog_postx_progress_bar - 10
		 * @hooked  - blog_postx_sticky_posts - 20
		 */
		if( has_action( 'blog_postx_header_after_hook' ) ) do_action( 'blog_postx_header_after_hook' );