<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
require get_template_directory() . '/builder/footer-builder.php';
use Blog_Postx_Builder as BB;

	/**
	 * hook - blog_postx_you_may_have_missed_hook
	 * 
	 * @hooked - blog_postx_you_may_have_missed_html - 10
	 */
	if( has_action( 'blog_postx_you_may_have_missed_hook' ) ) do_action( 'blog_postx_you_may_have_missed_hook' );

	$footer_builder_section_width = BPX\blog_postx_get_customizer_option( 'footer_builder_section_width' );
	$footerClass = 'site-footer dark_bk';
	$footerClass .= ' ' . $footer_builder_section_width;
	?>
		<footer id="colophon" class="<?php echo esc_attr( $footerClass ); ?>">
			<div class="blog-postx-container">
				<div class="row">
					<?php
						new BB\Footer_Builder_Render();
					?>
				</div>
			</div>
		</footer><!-- #colophon -->

		<?php
			/**
			 * hook - blog_postx_animation_hook
			 * 
			 * hooked - blog_postx_get_background_and_cursor_animation
			 */
			if( has_action( 'blog_postx_animation_hook' ) ) do_action( 'blog_postx_animation_hook' );
		?>
	</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
