<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blog Postx Pro
 */
use BlogPostx\CustomizerDefault as BPX;
$archive_meta_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_meta_reorder' ) );
$archive_content_reorder = blog_postx_get_reorder_value( BPX\blog_postx_get_customizer_option( 'archive_content_reorder' ) );
$visible_elements = count( array_keys( $archive_content_reorder, true ) );
$args[ 'archive_meta_reorder' ] = $archive_meta_reorder;
$args[ 'archive_content_reorder' ] = $archive_content_reorder;
$args[ 'archive_post_layout' ] = BPX\blog_postx_get_customizer_option( 'archive_post_layout' );
$args[ 'show_archive_category_in_mobile' ] = true;
$args[ 'show_archive_date_in_mobile' ] = true;

get_header();

	do_action( 'blog_postx_main_content_opening' );
	$elementClass = ' archive-align--' . BPX\blog_postx_get_customizer_option('archive_post_elements_alignment');	
	$elementClass .= ' ' . blog_postx_convert_number_to_numeric_string( $visible_elements ) . '-items';
	if( $archive_content_reorder[ 'button' ] && $archive_meta_reorder[ 'date' ] ) $elementClass .= ' align-off';
	
	$archive_sidebar_layout = BPX\blog_postx_get_customizer_option( 'archive_sidebar_layout' );
	$sidebar_layout = blog_postx_get_current_page_sidebar();
	$is_customizer_settings = ( $sidebar_layout === 'customizer-setting' );
	$current_sidebar_layout = $is_customizer_settings ? $archive_sidebar_layout : $sidebar_layout;
	$show_right_sidebar = in_array( $current_sidebar_layout, [ 'both-sidebar', 'right-sidebar' ] );
	if( in_array( $current_sidebar_layout, [ 'both-sidebar', 'left-sidebar' ] ) ) get_sidebar( 'left' );
	?>
		<main id="primary" class="site-main">
			<?php
				/**
				 * Hook - blog_postx_page_header_hook
				 * 
				 * Hooked - blog_postx_archive_header_html - 10
				 */
				if ( have_posts() ) :
					$ads_info = blog_postx_algorithm_to_push_ads_in_archive();
					$count = 0;
					echo '<div class="blog-postx-inner-content-wrap'. esc_attr( $elementClass ) .'">'; //inner-content-wrap
						while ( have_posts() ) : the_post();
							if( ! is_null( $ads_info ) ) :
								if( in_array( $wp_query->current_post, $ads_info['random_numbers'] ) ) :
									blog_postx_random_post_archive_advertisement_part( is_array( $ads_info['ads_to_render'] ) ? $ads_info['ads_to_render'][$count] : $ads_info['ads_to_render'] );
									$count++;
								endif;
							endif;
							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part( 'template-parts/archive/layout', '', $args );
							// $post_counter++;
						endwhile;
					echo '</div>'; //  end: blog-postx-inner-content-wrap
					
					/**
					 * hook - blog_postx_pagination_link_hook
					 * 
					 * hooked - blog_postx_pagination_fnc - 10
					 * 
					 * @package Blog Postx Pro
					 * @since 1.0.0
					 */
					do_action( 'blog_postx_pagination_link_hook' );
				else :
					get_template_part( 'template-parts/content', 'none' );
				endif;
			?>
		</main><!-- #main -->

	<?php
	if( $show_right_sidebar ) get_sidebar( '', [ 'sidebar' => $show_right_sidebar ] );
	do_action( 'blog_postx_main_content_closing' );

get_footer();