/**
 * WordPress dependencies
 */
import { createReduxStore, register } from '@wordpress/data'

/**
 * Internal dependencies
 */
import reducer from './reducer'
import * as selectors from './selectors'
import * as actions from './actions'
import { STORE_NAME } from './constants'

/**
 * Block editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registering-a-store
 *
 * @type {Object}
 */
const storeConfig = {
	reducer,
	selectors,
	actions,
}

/**
 * Store definition for the edit widgets namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 *
 * @type {Object}
 */
export const store = createReduxStore(STORE_NAME, storeConfig)
register(store)
