( function( $ ) {

	"use strict";

	/**
	 * Real-time preview of the site title and description text.
	 */
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).html( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).html( to );
		} );
	} );

	/**
	 * Real-time preview of the footer site information text.
	 */
	wp.customize( 'block_lite_footer_text', function( value ) {
		value.bind( function( to ) {
			$( '.footer-site-info' ).html( to );
		} );
	} );

	/**
	 * Real-time preview of the site title.
	 */
	wp.customize( 'block_lite_site_title', function( value ) {
		value.bind( function( to ) {
			if ( '1' != to ) {
				$( '.site-title' ).css( {
					'padding' : '0',
					'text-indent' : '-9999px',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title' ).css( {
					'padding' : '24px 12px',
					'text-indent' : '0',
					'position': 'relative'
				} );
			}
		} );
	} );

	/**
	 * Real-time preview of the site tagline.
	 */
	wp.customize( 'block_lite_site_tagline', function( value ) {
		value.bind( function( to ) {
			if ( '1' != to ) {
				$( '.site-description' ).css( {
					'padding' : '0',
					'left' : '-9999px',
					'position': 'absolute'
				} );
			} else {
				$( '.site-description' ).css( {
					'padding' : '12px',
					'left' : '0',
					'position': 'relative'
				} );
			}
		} );
	} );

	/**
	 * Real-time preview of the navigation menu background color.
	 */
	wp.customize( 'block_lite_colors_header', function( value ) {
		value.bind( function( to ) {
			$('.block-header-inactive #header, .block-header-inactive #nav-bar').css('background-color', to );
			$('#header, #nav-bar').bgBrightness();
		} );
	} );

	/**
	 * Real-time preview of the footer background color.
	 */
	wp.customize( 'block_lite_colors_footer', function( value ) {
		value.bind( function( to ) {
			$('.footer').css('background-color', to );
			$('.footer').bgBrightness();
		} );
	} );

})( jQuery );
