<?php

namespace Codemanas\ThemeInfo;

class Translations {
	private static $_instance = null;

	public static function get_instance() {
		return ( self::$_instance == null ) ? self::$_instance = new self() : self::$_instance;
	}

	public $translations = [];

	private function __construct() {
		$this->translations = apply_filters( 'cm_theme_info_translations', [
			'general'      => [
				'our_plugins'          => 'Our Plugins',
				'activate'             => 'Activate',
				'learn_more'           => 'Learn More',
				'demo_link'            => 'Live Demo',
				'documentation'        => 'See Documentation',
				'documentation_link'   => 'See Documentation',
				'install_and_activate' => 'Install and Activate',
				'activated'            => 'Activated',
				'support'              => 'Go to Support',
				'sticky_header_info'   => 'To enable sticky header please install and activate CM Blocks',
				'cm_blocks'            => 'CM Blocks',
			],
			'header'       => [
				'upgrade' => 'Upgrade to Pro',
			],
			'banner'       => [
				'heading'     => 'CM BLOCKS',
				'sub_heading' => 'Start with Simplicity, Grow with Ease.',
				'copy'        => 'Get started quickly with professionally designed starter sites, explore a rich design library of patterns and page layouts, and enjoy advanced features like Block Visibility, Scroll to Top, and Maintenance Mode. With intuitive, easy-to-use blocks, building beautiful, functional websites has never been simpler.',
				'link_text'   => 'Get started with CM Blocks',
			],
			'sidebar'      => [
				'help_and_support'   => 'Help & Support',
				'support_copy'       => 'Need a hand with something? We’re here for you! Just click the button below to find support options and helpful resources.',
				'documentation_copy' => 'Learn how to make the most of our products with our detailed documentation.',
				'leave_a_review'     => 'Leave a Review',
				'review_copy'        => 'Enjoy using our products ? We\'d love to hear your feedback.',
			],
			'tab_headings' => [
				'get_started' => 'Get Started',
				'cm_blocks'   => 'CM Blocks',
				'changelog'   => 'Change Log',
			],
			'general_tab'  => [
				'tab_title'      => 'Quick Settings',
				'quick_settings' => [
					'header'        => [
						'title' => 'Header',
						'desc'  => 'The header is a key section at the top of your site that can include your logo, site title, menu, or other important elements.'
					],
					'footer'        => [
						'title' => 'Footer',
						'desc'  => 'The footer is the section at the bottom of your site, often used to display credits, navigation links, or additional information.'
					],
					'global_styles' => [
						'title' => 'Global Styles',
						'desc'  => 'Global styles allows users to customize the overall appearance of their site, including typography, colors, and layouts, across all blocks and templates.'
					],
					'navigation'    => [
						'title' => 'Navigation',
						'desc'  => 'Navigation menus help users explore and move between different areas of the website.'
					],
					'templates'     => [
						'title' => 'Templates',
						'desc'  => 'Templates define the overall layout and structure of your pages and posts, determining how content is displayed.'
					],
					'patterns'      => [
						'title' => 'Patterns',
						'desc'  => 'Patterns are predefined block layouts that help you quickly design and organize content on your WordPress site with ease.'
					]
				],
				'plugins'        => [
					'zoom'         => [
						'title' => 'Video Conferencing with Zoom',
						'desc'  => 'Manage Zoom meetings and webinars effortlessly from your WordPress dashboard.'
					],
					'typesense'    => [
						'title' => 'Search with Typesense',
						'desc'  => 'Turbocharge your sites search with Typesense.Get lightning fast search at your fingertips'
					],
					'simple_popup' => [
						'title' => 'Simple Popup Block',
						'desc'  => 'The easy way to manage popups on your website. Enjoy enhanced engagement without sacrificing page speed.'
					]
				]
			],
			'blocks_tab'   => [
				'docs'      => 'Docs',
				'tab_title' => 'Blocks',
				'intro'     => [
					'title' => 'Craft Your Distinctive Web Presence',
					'copy'  => 'Explore our extensive collection of expertly crafted patterns and page designs. Choose from a variety of options to create your site exactly as you envision it.

With just a few clicks, easily create beautiful sections anywhere on your site.'
				],
				'sidebar'   => [
					'title' => 'Elevate your design',
					'copy'  => 'Unlock premium designs and access a collection of unique, high-quality templates that will make your site stand out. With dedicated priority support, you will have everything you need to create exceptional websites effortlessly. Elevate your design capabilities today with our Premium Designs!'
				],
				'blocks'    => [
					'slider'          => [ 'title' => 'Slider', 'desc' => 'Use the Slider block to display content such as images, testimonials, or promotions, with smooth transitions that engage users interactively.' ],
					'accordion'       => [ 'title' => 'Accordion', 'desc' => 'Use the Accordion block to present content in expandable sections, making it easy for users to access detailed information without cluttering the page.' ],
					'progress-bar'    => [ 'title' => 'Progress Bar', 'desc' => 'Use the Progress Bar block to visually represent the completion of a task, goal, or process, offering clear feedback to users.' ],
					'countdown'       => [ 'title' => 'Countdown', 'desc' => 'Use the Countdown block to count down to a specific date or event, creating a sense of anticipation and urgency.' ],
					'counter'         => [ 'title' => 'Counter', 'desc' => ' Use the Counter block to display a numerical value that can increase or decrease, perfect for showing stats or interactive data.' ],
					'masonry-gallery' => [ 'title' => 'Masonry Gallery', 'desc' => 'Use the Masonry Gallery block to create a dynamic, grid-based layout for images or content, adjusting to different sizes and creating an organized yet creative display.' ]

				]
			],
			'notice'       => [
				'title' => 'Thanks for installing  %s',
			],
		] );
	}

	public function get_banner_translations() {
		return array_merge( $this->get_general_translations(), $this->translations['banner'] );
	}

	public function get_general_translations() {
		return $this->translations['general'];
	}

	public function get_header_translations() {
		return array_merge( $this->get_general_translations(), $this->translations['header'] );
	}

	public function get_tabs() {
		return $this->translations['tab_headings'];
	}

	public function get_general_tab() {
		return array_merge( $this->translations['general'], $this->translations['general_tab'] );
	}

	public function get_sidebar() {
		return array_merge( $this->translations['general'], $this->translations['sidebar'] );
	}

	public function get_cm_blocks_tab() {
		return array_merge( $this->translations['general'], $this->translations['blocks_tab'] );
	}

	public function get_notice_translations() {
		return array_merge( $this->translations['general'], $this->translations['notice'] );
	}
}