<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blaize
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<h2 class="comments-title">
			<?php
			$blaize_comment_count = get_comments_number();
			if ( '1' === $blaize_comment_count ) {
				printf(
					/* translators: 1: title. */
					esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'blaize' ),
					'<span>' . get_the_title() . '</span>'
				);
			} else {
				printf( // WPCS: XSS OK.
					/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $blaize_comment_count, 'comments title', 'blaize' ) ),
					number_format_i18n( $blaize_comment_count ),
					'<span>' . get_the_title() . '</span>'
				);
			}
			?>
		</h2><!-- .comments-title -->

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
			wp_list_comments( array(
				'style'      => 'ol',
				'callback' => 'blaize_custom_comment',
				'short_ping' => true,
				'avatar_size' => 200,
			) );
			?>
		</ol><!-- .comment-list -->

		<?php
		the_comments_navigation();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'blaize' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().

	comment_form( array (
		'fields' => apply_filters( 'comment_form_default_fields', blaize_custom_comment_fields() ),
		'comment_field' => '<textarea id="comment" name="comment" placeholder="' . esc_html__('Your Comment', 'blaize') .'" cols="45" rows="8" aria-required="true"></textarea></p>'
		)
	);
?>

</div><!-- #comments -->
