<?php get_header(); ?>

	<?php if (have_posts()) : ?>
		<h3 id="searchResult"><?php _e('Search Results'); ?></h3>

		<?php while (have_posts()) : the_post(); ?>        
		<div class="post">
			<h3 class="storytitle" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php if (get_the_title()): the_title(); else: ?>no title<?php endif; ?></a></h3>
			<div class="meta">
				<?php the_time('Y/n/j (l)') ?> | <?php _e("Filed under:"); ?> <?php the_category(',') ?>
			</div>
		
        	<div class="storycontent">
				<?php the_content(); ?>
			
            	<div class="meta_bottom">
					<?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?><!-- by <?php the_author() ?> --><?php edit_post_link(__("Edit This"), ' | '); ?>
				</div>
            
			</div><!-- / storycontent -->
		
        </div><!-- / post -->
		<?php endwhile; ?>

			<div class="navigation">
				<div class="next"><?php next_posts_link() ?></div>
				<div class="prev"><?php previous_posts_link() ?></div>
			</div>

		<?php else : ?>
		<div class="post">
			<h3 class="storytitle"><?php _e('No posts found.');?></h3>
			
            <div class="storycontent">
			
            <div id="searchform">
				<form method="get" id="searchform" action="<?php bloginfo('url'); ?>/">
					<input type="text" value="<?php the_search_query(); ?>" name="s" id="s" />
					<input type="image" name="submit" src="<?php bloginfo('template_url'); ?>/images/searchBody.png" alt="<?php _e('Search'); ?>" title="<?php _e('Search'); ?>" id="searchBody" class="btn" />
				</form>
			</div>
			</div><!-- / storycontent -->
		
        </div><!-- / post --> 
		<?php endif; ?>

    </div><!-- / content -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>