<?php
if ( function_exists('register_sidebars') )
	register_sidebars(2,array(
        'before_widget' => '<li id="%1$s" class="widget %2$s">',
        'after_widget' => '</li>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
	
	register_sidebar(array(
		'name' => 'footer',
        'before_widget' => '<div id="%1$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="heading">',
        'after_title' => '</h3>',
    ));

function get_pings_count() {
	global $post, $wpdb, $id;
	$pings = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = '$post->ID' && comment_approved = '1' && comment_type != ''");
	return count($pings);
}

function get_comments_count() {
	global $post, $wpdb, $id;
    $comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID && comment_approved = '1' && comment_type NOT REGEXP '^(trackback|pingback)$'");
    return count($comments);
}

/* Plugin Name: Shorten Link Text
Plugin URI: http://www.filmtraveler.com/2008/11/18/wordpress-plugin-shorten-link-text/
Description: Shortens the text on Previous and Next links at the top of the page when viewing a post
Author: Matt Friedman
Version: 1.0
Author URI: http://www.filmtraveler.com
*/

/*  Copyright 2008  Matt Friedman  (email : public@frame25productions.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

function filter_shorten_linktext($linkstring,$link) {
	$characters = 30;
	preg_match('/<a.*?>(.*?)<\/a>/is',$linkstring,$matches);
	$displayedTitle = $matches[1];
	$newTitle = shorten_with_ellipsis($displayedTitle,$characters);
	return str_replace('>'.$displayedTitle.'<','>'.$newTitle.'<',$linkstring);
}

function shorten_with_ellipsis($inputstring,$characters) {
  return (mb_strlen($inputstring) >= $characters) ? mb_substr($inputstring,0,($characters-3)) . '...' : $inputstring;
}

add_filter('previous_post_link','filter_shorten_linktext',10,2);
add_filter('next_post_link','filter_shorten_linktext',10,2);	
	
?>