<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bizzweb
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php bizzweb_post_thumbnail(); ?>
	<div class="post-detail">
		<?php if ( 'post' === get_post_type() ) : ?>
			<div class="entry-meta">
				<?php
				bizzweb_posted_on();
				bizzweb_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
		<header class="entry-header">
			<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;
			?>
		</header><!-- .entry-header -->
		<div class="entry-content">
			<?php the_excerpt(); ?>
		</div><!-- .entry-content -->
		<footer class="entry-footer">
			<?php bizzweb_categories_list(); ?>
		</footer>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
