<?php
if ( ! get_theme_mod( 'bizzweb_enable_video_section', false ) ) {
	return;
}

$section_content                     = array();
$section_content['subtitle']         = get_theme_mod( 'bizzweb_video_subtitle', '' );
$section_content['title']            = get_theme_mod( 'bizzweb_video_title', __( 'Watch the Video', 'bizzweb' ) );
$section_content['background_image'] = get_theme_mod( 'bizzweb_video_background_image' );
$section_content['video_url']        = get_theme_mod( 'bizzweb_video_link', '#' );

$section_content = apply_filters( 'bizzweb_video_section_content', $section_content );
bizzweb_render_video_section( $section_content );

/**
 * Render Video Section.
 */
function bizzweb_render_video_section( $section_content ) {
	if ( empty( $section_content ) ) {
		return;
	}

	?>
	<section id="bizzweb_video_section" class="bizzweb-video section-image-background " style="background-image:url(' <?php echo esc_url( $section_content['background_image'] ); ?> ');">
		<?php
		if ( is_customize_preview() ) :
			bizzweb_section_link( 'bizzweb_video_section' );
		endif;
		?>
		<div class="section-wrapper">
			<div class="bizzweb-video-wrapper">
				<?php if ( ! empty( $section_content['subtitle'] || $section_content['title'] ) ) : ?>
					<div class="video-heading-container">
						<p class="subtitle"><?php echo esc_html( $section_content['subtitle'] ); ?></p>
						<h3 class="video-heading"><?php echo esc_html( $section_content['title'] ); ?></h3>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $section_content['video_url'] ) ) : ?>
					<div class="play-button">
						<a id="play-video" class="video-play-button" href="<?php echo esc_url( $section_content['video_url'] ); ?>"><span></span></a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<?php
}
