<?php
if ( ! get_theme_mod( 'bizzweb_enable_team_section', false ) ) {
	return;
}

$team_content_ids  = array();
$team_content_type = get_theme_mod( 'bizzweb_team_content_type', 'post' );

for ( $i = 1; $i <= 3; $i++ ) {
	$team_content_ids[] = get_theme_mod( 'bizzweb_team_content_' . $team_content_type . '_' . $i );
}
$team_args = array(
	'post_type'           => $team_content_type,
	'posts_per_page'      => absint( 3 ),
	'ignore_sticky_posts' => true,
);
if ( ! empty( array_filter( $team_content_ids ) ) ) {
		$team_args['post__in'] = array_filter( $team_content_ids );
		$team_args['orderby']  = 'post__in';
} else {
	$team_args['orderby'] = 'date';
}
$team_args = apply_filters( 'bizzweb_team_section_args', $team_args );

bizzweb_render_team_section( $team_args );

/**
 * Render Team Section.
 */
function bizzweb_render_team_section( $team_args ) {

	$query = new WP_Query( $team_args );
	if ( $query->have_posts() ) {
		$section_title    = get_theme_mod( 'bizzweb_team_section_title', __( 'Meet Our volunteers', 'bizzweb' ) );
		$section_subtitle = get_theme_mod( 'bizzweb_team_subtitle', '' );
		?>
		<section id="bizzweb_team_section" class="bizzweb-team team-style-1 section-splitter">
			<?php
			if ( is_customize_preview() ) :
				bizzweb_section_link( 'bizzweb_team_section' );
			endif;
			?>
			<div class="section-wrapper">
				<?php if ( ! empty( $section_title || $section_subtitle ) ) : ?>
					<div class="title-heading">
						<h3 class="main-title"><?php echo esc_html( $section_title ); ?></h3>
						<p class="sub-title"><?php echo esc_html( $section_subtitle ); ?></p>
					</div>
				<?php endif; ?>
				<div class="bizzweb-team-container">
					<div class="bizzweb-team-wrapper">
						<?php
						$i = 1;
						while ( $query->have_posts() ) :
							$query->the_post();
							$designation      = get_theme_mod( 'bizzweb_team_designation_' . $i, '' );
							$social_links_str = get_theme_mod( 'bizzweb_team_social_links_' . $i );
							if ( ! empty( $social_links_str ) ) {
								$social_links[ get_the_ID() ] = explode( ',', $social_links_str );
							}
							?>
							<div class="bizzweb-team-content">
								<div class="bizzweb-team-inner">
									<div class="team-image">
										<?php the_post_thumbnail( 'post-thumbnail' ); ?>
									</div>
									<div class="team-designation-wrapper">
										<div class="team-designation">
											<h3 class="team-name"><?php the_title(); ?></h3>
											<?php if ( ! empty( $designation ) ) : ?>
												<p class="designation"><?php echo esc_html( $designation ); ?></p>
											<?php endif; ?>
										</div>
										<?php if ( ! empty( $social_links[ get_the_ID() ] ) ) { ?>
											<div class="our-team-socialicon">
												<ul class="social-links">
													<?php foreach ( $social_links[ get_the_ID() ] as $link ) { ?>
														<li><a href="<?php echo esc_url( $link ); ?>"></a></li>
													<?php } ?>
												</ul>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<?php
							$i++;
						endwhile;
						wp_reset_postdata();
						?>
					</div>
				</div>
			</div>
		</section>
		<?php
	}

}
