<?php

if ( ! get_theme_mod( 'bizzweb_enable_service_section', false ) ) {
	return;
}

$content_ids  = array();
$content_type = get_theme_mod( 'bizzweb_service_content_type', 'post' );

for ( $i = 1; $i <= 6; $i++ ) {
	$content_ids[] = get_theme_mod( 'bizzweb_service_content_' . $content_type . '_' . $i );
}

$args = array(
	'post_type'           => $content_type,
	'posts_per_page'      => absint( 6 ),
	'ignore_sticky_posts' => true,
);
if ( ! empty( array_filter( $content_ids ) ) ) {
		$args['post__in'] = array_filter( $content_ids );
		$args['orderby']  = 'post__in';
} else {
	$args['orderby'] = 'date';
}


$args = apply_filters( 'bizzweb_service_section_args', $args );

bizzweb_render_service_section( $args );

/**
 * Render Service Section.
 */
function bizzweb_render_service_section( $args ) {

	$query = new WP_Query( $args );
	if ( $query->have_posts() ) :
		$section_title    = get_theme_mod( 'bizzweb_service_title', __( 'What We Do For You', 'bizzweb' ) );
		$section_subtitle = get_theme_mod( 'bizzweb_service_subtitle', '' );
		?>
		<section id="bizzweb_service_section" class="bizzweb-service bizzweb-service-style-2 section-splitter">
			<?php
			if ( is_customize_preview() ) :
				bizzweb_section_link( 'bizzweb_service_section' );
			endif;
			?>
			<div class="section-wrapper">
				<?php if ( ! empty( $section_title || $section_subtitle ) ) : ?>
					<div class="title-heading">
						<h3 class="main-title"><?php echo esc_html( $section_title ); ?></h3>
						<p class="sub-title"><?php echo esc_html( $section_subtitle ); ?></p>
					</div>
				<?php endif; ?>
				<div class="bizzweb-service-wrapper">
					<?php
					$i = 1;
					while ( $query->have_posts() ) :
						$query->the_post();
						$service_icons = get_theme_mod( 'bizzweb_service_icon_' . $i, '' );
						?>
						<div class="bizzweb-service-container">
							<div class="bizzweb-service-inner">
								<?php if ( ! empty( $service_icons ) ) : ?>
									<div class="service-image">
										<img src="<?php echo esc_url( $service_icons ); ?>" alt="<?php echo esc_attr( $section_title ); ?>">
									</div>
								<?php endif; ?>
								<div class="service-text">
									<h4 class="service-text-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>	
									</h4>
									<P class="service-text-description">
										<?php echo wp_kses_post( wp_trim_words( get_the_content(), 20 ) ); ?>
									</P>
								</div>
							</div>	
						</div>
						<?php
						$i++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
		</section>
		<?php
	endif;
}
