<?php

/**
 * Render homepage sections.
 */
function bizzweb_homepage_sections() {
	$homepage_sections = array_keys( bizzweb_get_homepage_sections() );

	$sortable_sections = get_theme_mod( 'bizzweb_sortable' );

	if ( empty( $sortable_sections ) ) {
		$sorted_sections = $homepage_sections;
	} else {
		$sorted_sections = explode( ',', $sortable_sections );
		$sorted_sections = array_unique( array_merge( $sorted_sections, $homepage_sections ) );
	}

	foreach ( $sorted_sections as $section ) {
		if ( in_array( $section, $homepage_sections ) ) {
			require get_template_directory() . '/sections/' . $section . '.php';
		}
	}
}
