<?php

if ( ! get_theme_mod( 'bizzweb_enable_mission_section', false ) ) {
	return;
}

$content_id = array();

$content_type = get_theme_mod( 'bizzweb_mission_content_type', 'post' );

if ( 'post' === $content_type ) {
	$content_id[] = get_theme_mod( 'bizzweb_mission_content_post' );
} else {
	$content_id[] = get_theme_mod( 'bizzweb_mission_content_page' );
}
$args = array(
	'post_type'           => $content_type,
	'posts_per_page'      => absint( 1 ),
	'ignore_sticky_posts' => true,
);
if ( ! empty( array_filter( $content_id ) ) ) {
		$args['post__in'] = array_filter( $content_id );
		$args['orderby']  = 'post__in';
} else {
	$args['orderby'] = 'date';
}
$args = apply_filters( 'bizzweb_mission_section_content', $args );

bizzweb_render_mission_section( $args );

/**
 * Render Mission Section
 */
function bizzweb_render_mission_section( $args ) {
	$query = new WP_Query( $args );
	if ( $query->have_posts() ) :
		$subtitle     = get_theme_mod( 'bizzweb_mission_subtitle', __( 'Our Mission', 'bizzweb' ) );
		$mission_list = get_theme_mod( 'bizzweb_mission_list' );
		while ( $query->have_posts() ) :
			$query->the_post();
			?>
			<section id="bizzweb_mission_section" class="bizzweb-mission bizzweb-mission-style-2 section-splitter">
				<?php
				if ( is_customize_preview() ) :
					bizzweb_section_link( 'bizzweb_mission_section' );
				endif;
				?>
				<div class="section-wrapper">
					<div class="bizzweb-mission-container">
						<div class="bizzweb-mission-wrapper">
							<div class="bizzweb-mission-image">
								<?php the_post_thumbnail( 'post-thumbnail' ); ?>
							</div>	
							<div class="mission-text">
								<div class="title-heading title-heading-alternate">
									<h3 class="main-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>
									<?php if ( ! empty( $subtitle ) ) : ?>
										<p class="sub-title"><?php echo esc_html( $subtitle ); ?></p>
									<?php endif; ?>
								</div>
								<div class="mission-text-container">
									<p class="mission-text-paragraph"><?php echo wp_kses_post( wp_trim_words( get_the_content(), 40 ) ); ?></p>
									<?php
									$mission_point = ! empty( $mission_list ) ? explode( '|', $mission_list ) : array();
									?>
									<ul class="mission-list">
										<?php foreach ( $mission_point as $list ) : ?>
											<li><?php echo esc_html( $list ); ?></li>
										<?php endforeach; ?>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<?php
		endwhile;
		wp_reset_postdata();
	endif;
}
