<?php

if ( ! get_theme_mod( 'bizzweb_enable_latest_news_section', false ) ) {
	return;
}

$latest_news_content_ids  = array();
$latest_news_posts_count  = get_theme_mod( 'bizzweb_latest_news_count', 3 );
$latest_news_content_type = get_theme_mod( 'bizzweb_latest_news_content_type', 'post' );

if ( $latest_news_content_type === 'post' ) {
	for ( $i = 1; $i <= $latest_news_posts_count; $i++ ) {
		$latest_news_content_ids[] = get_theme_mod( 'bizzweb_latest_news_content_post_' . $i );
	}
	$latest_news_args = array(
		'post_type'           => $latest_news_content_type,
		'posts_per_page'      => absint( $latest_news_posts_count ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $latest_news_content_ids ) ) ) {
		$latest_news_args['post__in'] = array_filter( $latest_news_content_ids );
		$latest_news_args['orderby']  = 'post__in';
	} else {
		$latest_news_args['orderby'] = 'date';
	}
} else {
	$cat_content_id   = get_theme_mod( 'bizzweb_latest_news_content_category' );
	$latest_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( $latest_news_posts_count ),
	);
}
$latest_news_args = apply_filters( 'bizzweb_latest_news_section_args', $latest_news_args );

bizzweb_render_latest_news_section( $latest_news_args );

/**
 * Render Latest News Section.
 */
function bizzweb_render_latest_news_section( $latest_news_args ) {
	$section_title    = get_theme_mod( 'bizzweb_latest_news_section_title', __( 'Latest From News', 'bizzweb' ) );
	$section_subtitle = get_theme_mod( 'bizzweb_latest_news_subtitle', '' );
	$query            = new WP_Query( $latest_news_args );
	if ( $query->have_posts() ) :
		?>
		<section id="bizzweb_latest_news_section" class="bizzweb-news section-grey-background">
			<?php
			if ( is_customize_preview() ) :
				bizzweb_section_link( 'bizzweb_latest_news_section' );
			endif;
			?>
			<div class="section-wrapper">
				<?php if ( ! empty( $section_title || $section_subtitle ) ) : ?>
					<div class="title-heading">
						<h3 class="main-title"><?php echo esc_html( $section_title ); ?></h3>
						<p class="sub-title"><?php echo esc_html( $section_subtitle ); ?></p>
					</div>
				<?php endif; ?>
				<div class="bizzweb-news-container">
					<div class="bizzweb-news-wrapper">
						<?php
						while ( $query->have_posts() ) :
							$query->the_post();
							?>
							<div class="news-content">
								<div class="news-inside">
									<div class="news-image">
										<?php the_post_thumbnail( 'post-thumbnail' ); ?>
									</div>
									<?php bizzweb_categories_list(); ?>
									<h3 class="news-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									<div class="news-date">
										<?php if ( get_theme_mod( 'bizzweb_post_hide_author', false ) === false ) : ?>
											<div class="post-author">
												<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="fa fa-user"></i><?php echo esc_html( get_the_author() ); ?></a>
											</div>
										<?php endif; ?>
										<?php bizzweb_posted_on(); ?>
									</div>
									<div class="news-comment-time">
										<div class="comment">
											<?php
											$get_comments   = get_comments_number( get_the_ID() );
											$posts_comments = $get_comments <= 1 ? $get_comments . ' comment' : $get_comments . ' comments';
											?>
											<a href="<?php the_permalink(); ?>"><i class="fa fa-comments" aria-hidden="true"></i>
												<p><?php echo esc_html( $posts_comments ); ?></a></p>
											</div>
											<div class="time">
												<i class="fa fa-clock-o" aria-hidden="true"></i></i>
												<p>
													<?php
													echo bizzweb_reading_time( get_the_content() );
													echo esc_html__( ' min to read', 'bizzweb' );
													?>
												</p>
											</div>
										</div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
						?>
					</div>
				</div>
			</div>
		</section>
		<?php
	endif;
}
