<?php
if ( ! get_theme_mod( 'bizzweb_enable_counter_section', false ) ) {
	return;
}

$section_content                     = array();
$section_content['background_image'] = get_theme_mod( 'bizzweb_counter_background_image' );
$section_content                     = apply_filters( 'bizzweb_counter_section_content', $section_content );

bizzweb_render_counter_section( $section_content );

/**
 * Render Counter Section
 */
function bizzweb_render_counter_section( $section_content ) {
	$counter_title    = get_theme_mod( 'bizzweb_counter_title', __( 'Counter Section', 'bizzweb' ) );
	$counter_subtitle = get_theme_mod( 'bizzweb_counter_subtitle', '' );
	?>
	<section id="bizzweb_counter_section" class="bizzweb-counter counter-style-1 section-image-background" style="background-color: '#4D5DB4'">
		<?php
		if ( is_customize_preview() ) :
			bizzweb_section_link( 'bizzweb_counter_section' );
		endif;
		?>
		<?php if ( ! empty( $section_content['background_image'] ) ) : ?>
			<div class="counter-image">
				<img src="<?php echo esc_url( $section_content['background_image'] ); ?>" alt="<?php esc_attr_e( 'Counter Section', 'bizzweb' ); ?>">
			</div>
		<?php endif; ?>
		<div class="section-wrapper">
			<?php if ( ! empty( $counter_title || $counter_subtitle ) ) : ?>
				<div class="title-heading">
					<h3 class="main-title"><?php echo esc_html( $counter_title ); ?></h3>
					<p class="sub-title"><?php echo esc_html( $counter_subtitle ); ?></p>
				</div>
			<?php endif; ?>
			<div class="bizzweb-counter-wrapper">
				<?php
				for ( $i = 1; $i <= 4; $i++ ) {
					$icon         = get_theme_mod( 'bizzweb_counter_icon_' . $i );
					$label        = get_theme_mod( 'bizzweb_counter_label_' . $i );
					$value        = get_theme_mod( 'bizzweb_counter_value_' . $i );
					$value_suffix = get_theme_mod( 'bizzweb_counter_value_suffix_' . $i );
					?>
					<div class="bizzweb-counter-container">
						<?php if ( ! empty( $icon ) ) { ?>
							<div class="counter-icon">
								<img src="<?php echo esc_url( $icon ); ?>" alt="<?php echo esc_attr( $label ); ?>">
							</div>
						<?php } ?>
						<div class="counter-text">
							<?php if ( ! empty( $value ) ) { ?>
								<div class="data-counter">
									<span class="counter" data-count="<?php echo esc_attr( $value ); ?>"><?php echo absint( 0 ); ?></span>
									<span class="suffix"><?php echo esc_html( $value_suffix ); ?></span>
								</div>
								<?php
							}
							if ( ! empty( $label ) ) {
								?>
								<div class="counter-description">
									<p><?php echo esc_html( $label ); ?></p>
								</div>
							<?php } ?>
						</div>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</section>
	<?php
}
