<?php

if ( ! get_theme_mod( 'bizzweb_enable_banner_section', false ) ) {
	return;
}

$slider_content_ids  = array();
$slider_content_type = get_theme_mod( 'bizzweb_banner_slider_content_type', 'post' );

for ( $i = 1; $i <= 3; $i++ ) {
	$slider_content_ids[] = get_theme_mod( 'bizzweb_banner_slider_content_' . $slider_content_type . '_' . $i );
}
$banner_slider_args = array(
	'post_type'           => $slider_content_type,
	'posts_per_page'      => absint( 3 ),
	'ignore_sticky_posts' => true,
);
if ( ! empty( array_filter( $slider_content_ids ) ) ) {
		$banner_slider_args['post__in'] = array_filter( $slider_content_ids );
		$banner_slider_args['orderby']  = 'post__in';
} else {
	$banner_slider_args['orderby'] = 'date';
}

$banner_slider_args = apply_filters( 'bizzweb_banner_section_args', $banner_slider_args );

bizzweb_render_banner_section( $banner_slider_args );

/**
 * Render Banner Section.
 */
function bizzweb_render_banner_section( $banner_slider_args ) {

	$query = new WP_Query( $banner_slider_args );
	if ( $query->have_posts() ) :
		?>
		<section id="bizzweb_banner_section" class="bizzweb-banner">
			<?php
			if ( is_customize_preview() ) :
				bizzweb_section_link( 'bizzweb_banner_section' );
			endif;
			?>
			<div class="bizzweb-container">
				<div class="banner-slider slick-button banner-btn" data-slick='{"autoplay": false }'>
					<?php
					$i = 1;
					while ( $query->have_posts() ) :
						$query->the_post();
						$slider_button     = get_theme_mod( 'bizzweb_banner_button_label_' . $i, __( 'Get Started', 'bizzweb' ) );
						$slider_button_url = get_theme_mod( 'bizzweb_banner_button_link_' . $i );
						$slider_button_url = ! empty( $slider_button_url ) ? $slider_button_url : '#';
						?>
						<div class="bizzweb-banner-container">
							<div class="banner-image">
								<?php the_post_thumbnail( 'full' ); ?>
								<div class="banner-text">
									<div class="section-wrapper">
										<div class="banner-description">
											<h3 class="banner-heading"><?php the_title(); ?></h3>
											<p class="description"><?php echo wp_kses_post( wp_trim_words( get_the_content(), 25 ) ); ?></p>
										</div>
									</div>
									<?php if ( ! empty( $slider_button ) ) : ?>
										<div class="banner-button">
											<a href="<?php echo esc_url( $slider_button_url ); ?>" class="bizzweb-button"><?php echo esc_html( $slider_button ); ?></a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<?php
						$i++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
		</section>
		<?php
	endif;

}
