<?php

if ( ! get_theme_mod( 'bizzweb_enable_about_section', false ) ) {
	return;
}

$content_id = array();

$content_type = get_theme_mod( 'bizzweb_about_content_type', 'post' );

if ( 'post' === $content_type ) {
	$content_id[] = get_theme_mod( 'bizzweb_about_content_post' );
} else {
	$content_id[] = get_theme_mod( 'bizzweb_about_content_page' );
}
$args = array(
	'post_type'           => $content_type,
	'posts_per_page'      => absint( 1 ),
	'ignore_sticky_posts' => true,
);
if ( ! empty( array_filter( $content_id ) ) ) {
	$args['post__in'] = array_filter( $content_id );
	$args['orderby']  = 'post__in';
} else {
	$args['orderby'] = 'date';
}
$args = apply_filters( 'bizzweb_about_section_content', $args );

bizzweb_render_about_section( $args );

/**
 * Render About Us Section
 */
function bizzweb_render_about_section( $args ) {
	$query = new WP_Query( $args );
	if ( $query->have_posts() ) :
		$section_subtitle = get_theme_mod( 'bizzweb_about_subtitle', '' );
		$button_label     = get_theme_mod( 'bizzweb_about_button_label', __( 'Read More', 'bizzweb' ) );
		while ( $query->have_posts() ) :
			$query->the_post();
			?>
			<section id="bizzweb_about_section" class="bizzweb-about-us bizzweb-about-us-style-1 section-splitter">
				<?php
				if ( is_customize_preview() ) :
					bizzweb_section_link( 'bizzweb_about_section' );
				endif;
				?>
				<div class="section-wrapper">
					<div class="bizzweb-about-us-wrapper">
						<div class="bizzweb-about-us-text">
							<div class="title-heading title-heading-alternate">
								<h3 class="main-title"><?php the_title(); ?></h3>
								<p class="sub-title"><?php echo esc_html( $section_subtitle ); ?></p>
							</div>
							<div class="about-us-content">
								<p><?php echo wp_kses_post( wp_trim_words( get_the_content(), 50 ) ); ?></p>
							</div>
							<?php if ( $button_label ) : ?>
								<div class="about-us-button">
									<a href="<?php the_permalink(); ?>" class="bizzweb-button"><?php echo esc_html( $button_label ); ?></a>
								</div>
							<?php endif; ?>
						</div>
						<div class="bizzweb-pro-about-us-image">
							<?php the_post_thumbnail( 'post-thumbnail' ); ?>
						</div>
					</div>
				</div>	
			</section>
			<?php
		endwhile;
		wp_reset_postdata();
	endif;
}
