<?php
/**
 * Validation functions
 *
 * @package Bizzweb
 */

if ( ! function_exists( 'bizzweb_validate_excerpt_length' ) ) :
	function bizzweb_validate_excerpt_length( $validity, $value ) {
		$value = intval( $value );
		if ( empty( $value ) || ! is_numeric( $value ) ) {
			$validity->add( 'required', esc_html__( 'You must supply a valid number.', 'bizzweb' ) );
		} elseif ( $value < 1 ) {
			$validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 1', 'bizzweb' ) );
		} elseif ( $value > 100 ) {
			$validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'bizzweb' ) );
		}
		return $validity;
	}
endif;

if ( ! function_exists( 'bizzweb_validate_latest_news_count' ) ) :
	function bizzweb_validate_latest_news_count( $validity, $value ) {
		$value = intval( $value );
		if ( empty( $value ) || ! is_numeric( $value ) ) {
			$validity->add( 'required', esc_html__( 'You must supply a valid number.', 'bizzweb' ) );
		} elseif ( $value < 1 ) {
			$validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'bizzweb' ) );
		} elseif ( $value > 6 ) {
			$validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'bizzweb' ) );
		}
		return $validity;
	}
endif;
