<?php
/**
 * Typography
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_typography',
	array(
		'panel' => 'bizzweb_theme_options',
		'title' => esc_html__( 'Typography', 'bizzweb' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'bizzweb_site_title_font',
	array(
		'default'           => 'Lustria',
		'sanitize_callback' => 'bizzweb_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'bizzweb_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'bizzweb' ),
		'section'  => 'bizzweb_typography',
		'settings' => 'bizzweb_site_title_font',
		'type'     => 'select',
		'choices'  => bizzweb_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'bizzweb_site_description_font',
	array(
		'default'           => 'Domine',
		'sanitize_callback' => 'bizzweb_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'bizzweb_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'bizzweb' ),
		'section'  => 'bizzweb_typography',
		'settings' => 'bizzweb_site_description_font',
		'type'     => 'select',
		'choices'  => bizzweb_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'bizzweb_header_font',
	array(
		'default'           => 'EB Garamond',
		'sanitize_callback' => 'bizzweb_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'bizzweb_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'bizzweb' ),
		'section'  => 'bizzweb_typography',
		'settings' => 'bizzweb_header_font',
		'type'     => 'select',
		'choices'  => bizzweb_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'bizzweb_body_font',
	array(
		'default'           => 'Domine',
		'sanitize_callback' => 'bizzweb_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'bizzweb_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'bizzweb' ),
		'section'  => 'bizzweb_typography',
		'settings' => 'bizzweb_body_font',
		'type'     => 'select',
		'choices'  => bizzweb_get_all_google_font_families(),
	)
);
