<?php
/**
 * Sidebar Option
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_sidebar_option',
	array(
		'title' => esc_html__( 'Layout', 'bizzweb' ),
		'panel' => 'bizzweb_theme_options',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'bizzweb_sidebar_position',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'bizzweb_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'bizzweb' ),
		'section' => 'bizzweb_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'bizzweb' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'bizzweb' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'bizzweb' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'bizzweb_post_sidebar_position',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'bizzweb_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'bizzweb' ),
		'section' => 'bizzweb_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'bizzweb' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'bizzweb' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'bizzweb' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'bizzweb_page_sidebar_position',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'bizzweb_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'bizzweb' ),
		'section' => 'bizzweb_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'bizzweb' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'bizzweb' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'bizzweb' ),
		),
	)
);
