<?php
/**
 * Pagination
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_pagination',
	array(
		'panel' => 'bizzweb_theme_options',
		'title' => esc_html__( 'Pagination', 'bizzweb' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'bizzweb_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'bizzweb' ),
			'section'  => 'bizzweb_pagination',
			'settings' => 'bizzweb_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'bizzweb_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'bizzweb_sanitize_select',
	)
);

$wp_customize->add_control(
	'bizzweb_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'bizzweb' ),
		'section'         => 'bizzweb_pagination',
		'settings'        => 'bizzweb_pagination_type',
		'active_callback' => 'bizzweb_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'bizzweb' ),
			'numeric' => __( 'Numeric', 'bizzweb' ),
		),
	)
);
