<?php
/**
 * Header Options
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_header_options',
	array(
		'panel' => 'bizzweb_theme_options',
		'title' => esc_html__( 'Header Options', 'bizzweb' ),
	)
);

// Header Options - Enable Topbar.
$wp_customize->add_setting(
	'bizzweb_enable_topbar',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_topbar',
		array(
			'label'   => esc_html__( 'Enable Topbar', 'bizzweb' ),
			'section' => 'bizzweb_header_options',
		)
	)
);

// Topbar Options - Contact Label.
$wp_customize->add_setting(
	'bizzweb_topbar_contact_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_topbar_contact_label',
	array(
		'label'           => esc_html__( 'Contact Label', 'bizzweb' ),
		'section'         => 'bizzweb_header_options',
		'settings'        => 'bizzweb_topbar_contact_label',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_topbar_enabled',
	)
);

// Header Options - Contact Number.
$wp_customize->add_setting(
	'bizzweb_contact_number',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_contact_number',
	array(
		'label'           => esc_html__( 'Contact Number', 'bizzweb' ),
		'section'         => 'bizzweb_header_options',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_topbar_enabled',
	)
);

// Topbar Options - Email Label.
$wp_customize->add_setting(
	'bizzweb_topbar_email_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_topbar_email_label',
	array(
		'label'           => esc_html__( 'Email Label', 'bizzweb' ),
		'section'         => 'bizzweb_header_options',
		'settings'        => 'bizzweb_topbar_email_label',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_topbar_enabled',
	)
);

// Header Options - Email Address.
$wp_customize->add_setting(
	'bizzweb_email_address',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_email_address',
	array(
		'label'           => esc_html__( 'Email Address', 'bizzweb' ),
		'section'         => 'bizzweb_header_options',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_topbar_enabled',
	)
);
