<?php
/**
 * Footer Options
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_footer_options',
	array(
		'panel' => 'bizzweb_theme_options',
		'title' => esc_html__( 'Footer Options', 'bizzweb' ),
	)
);

// Footer Options - Copyright Text.
/* translators: 1: Year, 2: Site Title with home URL. */
$copyright_default = sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'bizzweb' ), '[the-year]', '[site-link]' );
$wp_customize->add_setting(
	'bizzweb_footer_copyright_text',
	array(
		'default'           => $copyright_default,
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'bizzweb_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'bizzweb' ),
		'section'  => 'bizzweb_footer_options',
		'settings' => 'bizzweb_footer_copyright_text',
		'type'     => 'textarea',
	)
);

// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'bizzweb_scroll_top',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'bizzweb' ),
			'section' => 'bizzweb_footer_options',
		)
	)
);
