<?php
/**
 * Excerpt
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_excerpt_options',
	array(
		'panel' => 'bizzweb_theme_options',
		'title' => esc_html__( 'Excerpt', 'bizzweb' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'bizzweb_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'bizzweb_pro_sanitize_number_range',
		'validate_callback' => 'bizzweb_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'bizzweb_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'bizzweb' ),
		'description' => esc_html__( 'Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'bizzweb' ),
		'section'     => 'bizzweb_excerpt_options',
		'settings'    => 'bizzweb_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 100,
			'step' => 1,
		),
	)
);
