<?php
/**
 * Breadcrumb
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'bizzweb' ),
		'panel' => 'bizzweb_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'bizzweb_enable_breadcrumb',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'bizzweb' ),
			'section' => 'bizzweb_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'bizzweb_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'bizzweb_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'bizzweb' ),
		'active_callback' => 'bizzweb_is_breadcrumb_enabled',
		'section'         => 'bizzweb_breadcrumb',
	)
);
