<?php
/**
 * Video Section
 *
 * @package Bizzweb
 */

$wp_customize->add_section(
	'bizzweb_video_section',
	array(
		'panel'    => 'bizzweb_front_page_options',
		'title'    => esc_html__( 'Video Section', 'bizzweb' ),
		'priority' => 60,
	)
);

// Video Section - Enable Section.
$wp_customize->add_setting(
	'bizzweb_enable_video_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'bizzweb_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Bizzweb_Toggle_Switch_Custom_Control(
		$wp_customize,
		'bizzweb_enable_video_section',
		array(
			'label'    => esc_html__( 'Enable Video Section', 'bizzweb' ),
			'section'  => 'bizzweb_video_section',
			'settings' => 'bizzweb_enable_video_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'bizzweb_enable_video_section',
		array(
			'selector' => '#bizzweb_video_section .section-link',
			'settings' => 'bizzweb_enable_video_section',
		)
	);
}

// Video Section - Background Image.
$wp_customize->add_setting(
	'bizzweb_video_background_image',
	array(
		'sanitize_callback' => 'bizzweb_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'bizzweb_video_background_image',
		array(
			'label'           => esc_html__( 'Background Image', 'bizzweb' ),
			'section'         => 'bizzweb_video_section',
			'settings'        => 'bizzweb_video_background_image',
			'active_callback' => 'bizzweb_is_video_section_enabled',
		)
	)
);

// Video Section - Section Subtitle.
$wp_customize->add_setting(
	'bizzweb_video_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_video_subtitle',
	array(
		'label'           => esc_html__( 'Video Subtitle', 'bizzweb' ),
		'section'         => 'bizzweb_video_section',
		'settings'        => 'bizzweb_video_subtitle',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_video_section_enabled',
	)
);

// Video Section - Section Title.
$wp_customize->add_setting(
	'bizzweb_video_title',
	array(
		'default'           => __( 'Watch the Video', 'bizzweb' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'bizzweb_video_title',
	array(
		'label'           => esc_html__( 'Video Title', 'bizzweb' ),
		'section'         => 'bizzweb_video_section',
		'settings'        => 'bizzweb_video_title',
		'type'            => 'text',
		'active_callback' => 'bizzweb_is_video_section_enabled',
	)
);

// Video Section - Video Link.
$wp_customize->add_setting(
	'bizzweb_video_link',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'bizzweb_video_link',
	array(
		'label'           => esc_html__( 'Video Link', 'bizzweb' ),
		'section'         => 'bizzweb_video_section',
		'settings'        => 'bizzweb_video_link',
		'type'            => 'url',
		'active_callback' => 'bizzweb_is_video_section_enabled',
	)
);
